/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.ADefinitionExpression;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.APredicateDefinitionDefinition;
import de.be4.classicalb.core.parser.node.ASubstitutionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PDefinition;
import de.tlc4b.analysis.MachineContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;

public class DefinitionsSorter
extends DepthFirstAdapter {
    private final MachineContext machineContext;
    private final Hashtable<Node, HashSet<Node>> dependenciesTable;
    private HashSet<Node> current;
    private final ArrayList<PDefinition> allDefinitions;

    public ArrayList<PDefinition> getAllDefinitions() {
        return this.allDefinitions;
    }

    public DefinitionsSorter(MachineContext machineContext, ArrayList<PDefinition> allDefinitions) {
        this.machineContext = machineContext;
        this.dependenciesTable = new Hashtable();
        for (PDefinition def : allDefinitions) {
            def.apply(this);
        }
        this.allDefinitions = this.sort(new ArrayList<PDefinition>(allDefinitions));
    }

    private ArrayList<PDefinition> sort(ArrayList<PDefinition> list) {
        ArrayList<PDefinition> result = new ArrayList<PDefinition>();
        boolean newRun = true;
        block0: while (newRun) {
            newRun = false;
            for (PDefinition def : list) {
                HashSet<Node> set;
                if (result.contains(def) || !(set = this.dependenciesTable.get(def)).isEmpty()) continue;
                newRun = true;
                result.add(def);
                Node defRef = this.machineContext.getReferences().get(def);
                if (null != defRef) {
                    this.removeDef(defRef);
                    continue block0;
                }
                this.removeDef(def);
                continue block0;
            }
        }
        if (result.size() != list.size()) {
            throw new RuntimeException("Found cyclic Definitions.");
        }
        return result;
    }

    private void removeDef(Node def) {
        for (HashSet<Node> nodes : this.dependenciesTable.values()) {
            nodes.remove(def);
        }
    }

    @Override
    public void inAExpressionDefinitionDefinition(AExpressionDefinitionDefinition node) {
        this.current = new HashSet();
    }

    @Override
    public void outAExpressionDefinitionDefinition(AExpressionDefinitionDefinition node) {
        this.dependenciesTable.put(node, this.current);
        this.current = null;
    }

    @Override
    public void inAPredicateDefinitionDefinition(APredicateDefinitionDefinition node) {
        this.current = new HashSet();
    }

    @Override
    public void outAPredicateDefinitionDefinition(APredicateDefinitionDefinition node) {
        this.dependenciesTable.put(node, this.current);
        this.current = null;
    }

    @Override
    public void inASubstitutionDefinitionDefinition(ASubstitutionDefinitionDefinition node) {
        this.current = new HashSet();
    }

    @Override
    public void outASubstitutionDefinitionDefinition(ASubstitutionDefinitionDefinition node) {
        this.dependenciesTable.put(node, this.current);
        this.current = null;
    }

    @Override
    public void inADefinitionExpression(ADefinitionExpression node) {
        Node refNode = this.machineContext.getReferences().get(node);
        if (null != refNode) {
            this.current.add(refNode);
        }
    }

    @Override
    public void inAIdentifierExpression(AIdentifierExpression node) {
        Node identifierRef = this.machineContext.getReferences().get(node);
        if (identifierRef == null) {
            return;
        }
        if (this.machineContext.getConstants().containsValue(identifierRef)) {
            return;
        }
        if (this.machineContext.getReferences().get(identifierRef) instanceof PDefinition) {
            this.current.add(identifierRef);
        }
    }
}

