/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.ACardExpression;
import de.be4.classicalb.core.parser.node.AConjunctPredicate;
import de.be4.classicalb.core.parser.node.AConstraintsMachineClause;
import de.be4.classicalb.core.parser.node.ADisjunctPredicate;
import de.be4.classicalb.core.parser.node.AEqualPredicate;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AIntegerExpression;
import de.be4.classicalb.core.parser.node.AInvariantMachineClause;
import de.be4.classicalb.core.parser.node.APredicateParseUnit;
import de.be4.classicalb.core.parser.node.APropertiesMachineClause;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.tlc4b.analysis.MachineContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;

public class ConstantsEvaluator
extends DepthFirstAdapter {
    private final LinkedHashMap<Node, HashSet<Node>> dependsOnIdentifierTable = new LinkedHashMap();
    private final MachineContext machineContext;
    private final ValuesOfIdentifierFinder valuesOfConstantsFinder;
    private final HashMap<Node, Integer> integerValueTable = new HashMap();
    private final ArrayList<Node> propertiesList;
    private final ArrayList<Node> invariantList;
    private final LinkedHashMap<Node, Node> valueOfIdentifier;

    public Node getValueOfConstant(Node con) {
        return this.valueOfIdentifier.get(con);
    }

    public ArrayList<Node> getInvariantList() {
        return this.invariantList;
    }

    public ArrayList<Node> getPropertiesList() {
        return this.propertiesList;
    }

    public LinkedHashMap<Node, Node> getValueOfIdentifierMap() {
        return this.valueOfIdentifier;
    }

    public Integer getIntValue(Node node) {
        return this.integerValueTable.get(node);
    }

    public ArrayList<PExpression> getRangeOfIdentifier(Node con) {
        return (ArrayList)this.valuesOfConstantsFinder.rangeOfIdentifierTable.get(con);
    }

    public ConstantsEvaluator(MachineContext machineContext) {
        AConstraintsMachineClause constraints;
        APropertiesMachineClause properties;
        this.machineContext = machineContext;
        this.propertiesList = new ArrayList();
        this.invariantList = new ArrayList();
        ConstantsInTreeFinder constantInTreeFinder = new ConstantsInTreeFinder();
        if (machineContext.getConstantsSetup() != null) {
            machineContext.getConstantsSetup().apply(constantInTreeFinder);
        }
        if (null != (properties = machineContext.getPropertiesMachineClause())) {
            properties.apply(constantInTreeFinder);
        }
        if (null != (constraints = machineContext.getConstraintMachineClause())) {
            constraints.apply(constantInTreeFinder);
        }
        this.valuesOfConstantsFinder = new ValuesOfIdentifierFinder();
        this.valueOfIdentifier = new LinkedHashMap();
        this.evalIdentifier(machineContext.getConstants().values());
        this.evalIdentifier(machineContext.getScalarParameter().values());
    }

    private void evalIdentifier(Collection<Node> ids) {
        boolean newRun = true;
        while (newRun) {
            newRun = false;
            block1: for (Node id : ids) {
                if (this.valueOfIdentifier.containsKey(id)) continue;
                HashSet idValues = (HashSet)this.valuesOfConstantsFinder.valuesOfIdentifierTable.get(id);
                for (Node val : idValues) {
                    HashSet<Node> idsInVal = this.dependsOnIdentifierTable.get(val);
                    idsInVal.remove(id);
                    if (!idsInVal.isEmpty()) continue;
                    this.valueOfIdentifier.put(id, val);
                    this.removeIdentifier(ids, id);
                    newRun = true;
                    continue block1;
                }
            }
        }
    }

    private void removeIdentifier(Collection<Node> collection, Node identifierToRemove) {
        for (Node id : collection) {
            HashSet idValues = (HashSet)this.valuesOfConstantsFinder.valuesOfIdentifierTable.get(id);
            for (Node val : idValues) {
                HashSet<Node> idsInVal = this.dependsOnIdentifierTable.get(val);
                idsInVal.remove(identifierToRemove);
            }
        }
    }

    class ValuesOfIdentifierFinder
    extends DepthFirstAdapter {
        private final Hashtable<Node, HashSet<Node>> valuesOfIdentifierTable = new Hashtable();
        private final Hashtable<Node, ArrayList<PExpression>> rangeOfIdentifierTable = new Hashtable();
        private final HashSet<Node> identifiers = new HashSet();

        public ValuesOfIdentifierFinder() {
            AInvariantMachineClause invariantClause;
            APropertiesMachineClause aPropertiesMachineClause;
            this.identifiers.addAll(ConstantsEvaluator.this.machineContext.getConstants().values());
            this.identifiers.addAll(ConstantsEvaluator.this.machineContext.getScalarParameter().values());
            for (Node node : this.identifiers) {
                this.valuesOfIdentifierTable.put(node, new HashSet());
                this.rangeOfIdentifierTable.put(node, new ArrayList());
            }
            AConstraintsMachineClause constraints = ConstantsEvaluator.this.machineContext.getConstraintMachineClause();
            if (constraints != null) {
                this.analysePredicate(constraints.getPredicates(), false);
            }
            if (ConstantsEvaluator.this.machineContext.getConstantsSetup() != null) {
                if (ConstantsEvaluator.this.machineContext.getConstantsSetup() instanceof ADisjunctPredicate) {
                    this.analyseConstantSetupPredicate(ConstantsEvaluator.this.machineContext.getConstantsSetup());
                    for (Node con : this.identifiers) {
                        ArrayList<PExpression> list = this.rangeOfIdentifierTable.get(con);
                        if (list.size() != 1) continue;
                        this.valuesOfIdentifierTable.get(con).add(list.get(0));
                    }
                } else {
                    this.analysePredicate(ConstantsEvaluator.this.machineContext.getConstantsSetup(), true);
                }
            }
            if ((aPropertiesMachineClause = ConstantsEvaluator.this.machineContext.getPropertiesMachineClause()) != null) {
                PPredicate predicate = aPropertiesMachineClause.getPredicates();
                this.analysePredicate(predicate, true);
            }
            if ((invariantClause = ConstantsEvaluator.this.machineContext.getInvariantMachineClause()) != null) {
                this.analyseInvariantPredicate(invariantClause.getPredicates());
            }
        }

        private void analyseConstantSetupPredicate(PPredicate constantsSetup) {
            if (constantsSetup instanceof ADisjunctPredicate) {
                ADisjunctPredicate dis = (ADisjunctPredicate)constantsSetup;
                this.analyseConstantSetupPredicate(dis.getLeft());
                this.analyseConstantSetupPredicate(dis.getRight());
            } else if (constantsSetup instanceof AConjunctPredicate) {
                AConjunctPredicate con = (AConjunctPredicate)constantsSetup;
                this.analyseConstantSetupPredicate(con.getLeft());
                this.analyseConstantSetupPredicate(con.getRight());
            } else if (constantsSetup instanceof AEqualPredicate) {
                AEqualPredicate equals = (AEqualPredicate)constantsSetup;
                PExpression left = equals.getLeft();
                Node left_ref = ConstantsEvaluator.this.machineContext.getReferences().get(left);
                if (this.rangeOfIdentifierTable.containsKey(left_ref)) {
                    // empty if block
                }
                ArrayList<PExpression> currentRange = this.rangeOfIdentifierTable.get(left_ref);
                boolean found = false;
                for (PExpression pExpression : currentRange) {
                    if (!pExpression.toString().equals(equals.getRight().toString())) continue;
                    found = true;
                }
                if (!found) {
                    currentRange.add(equals.getRight());
                }
            }
        }

        private void analyseInvariantPredicate(Node node) {
            if (node instanceof AConjunctPredicate) {
                AConjunctPredicate conjunction = (AConjunctPredicate)node;
                this.analyseInvariantPredicate(conjunction.getLeft());
                this.analyseInvariantPredicate(conjunction.getRight());
                return;
            }
            ConstantsEvaluator.this.invariantList.add(node);
        }

        private void analysePredicate(Node node, boolean isProperties) {
            if (node instanceof AEqualPredicate) {
                this.analyseEqualsPredicate((AEqualPredicate)node);
            } else if (node instanceof AConjunctPredicate) {
                AConjunctPredicate conjunction = (AConjunctPredicate)node;
                this.analysePredicate(conjunction.getLeft(), isProperties);
                this.analysePredicate(conjunction.getRight(), isProperties);
                return;
            }
            if (isProperties) {
                ConstantsEvaluator.this.propertiesList.add(node);
            }
        }

        private void analyseEqualsPredicate(AEqualPredicate node) {
            int size;
            AIntegerExpression intExpr2;
            Node ref;
            PExpression left = node.getLeft();
            Node left_ref = ConstantsEvaluator.this.machineContext.getReferences().get(left);
            PExpression right = node.getRight();
            Node right_ref = ConstantsEvaluator.this.machineContext.getReferences().get(right);
            if (left instanceof ACardExpression) {
                ref = ConstantsEvaluator.this.machineContext.getReferences().get(((ACardExpression)left).getExpression());
                if (!ConstantsEvaluator.this.machineContext.getConstants().containsValue(ref)) {
                    try {
                        intExpr2 = (AIntegerExpression)right;
                        size = Integer.parseInt(intExpr2.getLiteral().getText());
                        ConstantsEvaluator.this.integerValueTable.put(ref, size);
                    }
                    catch (ClassCastException intExpr2) {
                        // empty catch block
                    }
                }
            }
            if (right instanceof ACardExpression) {
                ref = ConstantsEvaluator.this.machineContext.getReferences().get(((ACardExpression)right).getExpression());
                if (!ConstantsEvaluator.this.machineContext.getConstants().containsValue(ref)) {
                    try {
                        intExpr2 = (AIntegerExpression)left;
                        size = Integer.parseInt(intExpr2.getLiteral().getText());
                        ConstantsEvaluator.this.integerValueTable.put(ref, size);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
            if (this.identifiers.contains(left_ref)) {
                this.valuesOfIdentifierTable.get(left_ref).add(right);
            }
            if (this.identifiers.contains(right_ref)) {
                this.valuesOfIdentifierTable.get(right_ref).add(left);
            }
        }
    }

    class ConstantsInTreeFinder
    extends DepthFirstAdapter {
        ConstantsInTreeFinder() {
        }

        @Override
        public void defaultIn(Node node) {
            ConstantsEvaluator.this.dependsOnIdentifierTable.put(node, new HashSet());
        }

        @Override
        public void defaultOut(Node node) {
            HashSet set = (HashSet)ConstantsEvaluator.this.dependsOnIdentifierTable.get(node);
            Node parent = node.parent();
            HashSet parentSet = (HashSet)ConstantsEvaluator.this.dependsOnIdentifierTable.get(parent);
            if (parentSet != null) {
                parentSet.addAll(set);
            }
        }

        @Override
        public void caseAPropertiesMachineClause(APropertiesMachineClause node) {
            this.defaultIn(node);
            node.getPredicates().apply(this);
        }

        @Override
        public void caseAPredicateParseUnit(APredicateParseUnit node) {
            this.defaultIn(node);
            node.getPredicate().apply(this);
        }

        @Override
        public void caseAConstraintsMachineClause(AConstraintsMachineClause node) {
            this.defaultIn(node);
            node.getPredicates().apply(this);
        }

        @Override
        public void caseAIdentifierExpression(AIdentifierExpression node) {
            this.defaultIn(node);
            Node refNode = ConstantsEvaluator.this.machineContext.getReferences().get(node);
            if (ConstantsEvaluator.this.machineContext.getConstants().containsValue(refNode)) {
                HashSet set = (HashSet)ConstantsEvaluator.this.dependsOnIdentifierTable.get(node);
                set.add(refNode);
            }
            this.defaultOut(node);
        }
    }
}

