/*
 * Decompiled with CFR 0.152.
 */
package de.be4.ltl.core.parser.internal;

import de.be4.ltl.core.parser.analysis.DepthFirstAdapter;
import de.be4.ltl.core.parser.internal.PrologGeneratorHelper;
import de.be4.ltl.core.parser.internal.UniversalToken;
import de.be4.ltl.core.parser.node.AActionLtl;
import de.be4.ltl.core.parser.node.AAndFair1Ltl;
import de.be4.ltl.core.parser.node.AAndFair2Ltl;
import de.be4.ltl.core.parser.node.AAvailableLtl;
import de.be4.ltl.core.parser.node.ABeforeAfterLtl;
import de.be4.ltl.core.parser.node.AChangedLtl;
import de.be4.ltl.core.parser.node.ACtrlLtl;
import de.be4.ltl.core.parser.node.ACurrentLtl;
import de.be4.ltl.core.parser.node.ADeadlockLtl;
import de.be4.ltl.core.parser.node.ADecreasingLtl;
import de.be4.ltl.core.parser.node.ADetLtl;
import de.be4.ltl.core.parser.node.ADetOutputLtl;
import de.be4.ltl.core.parser.node.ADlkLtl;
import de.be4.ltl.core.parser.node.AEnabledLtl;
import de.be4.ltl.core.parser.node.AErrorLtl;
import de.be4.ltl.core.parser.node.AExistsLtl;
import de.be4.ltl.core.parser.node.AForallLtl;
import de.be4.ltl.core.parser.node.AGoalLtl;
import de.be4.ltl.core.parser.node.AIncreasingLtl;
import de.be4.ltl.core.parser.node.AOpActions;
import de.be4.ltl.core.parser.node.ASinkLtl;
import de.be4.ltl.core.parser.node.AStrongFairAllLtl;
import de.be4.ltl.core.parser.node.AStrongFairLtl;
import de.be4.ltl.core.parser.node.AUnchangedLtl;
import de.be4.ltl.core.parser.node.AUnparsedLtl;
import de.be4.ltl.core.parser.node.AWeakFairAllLtl;
import de.be4.ltl.core.parser.node.AWeakFairLtl;
import de.be4.ltl.core.parser.node.Node;
import de.be4.ltl.core.parser.node.PLtl;
import de.be4.ltl.core.parser.node.Start;
import de.be4.ltl.core.parser.node.TActionChar;
import de.be4.ltl.core.parser.node.TAtomicPropositionBegin;
import de.be4.ltl.core.parser.node.TAvailable;
import de.be4.ltl.core.parser.node.TEnabled;
import de.be4.ltl.core.parser.node.TLSq;
import de.be4.ltl.core.parser.node.TStrongFair;
import de.be4.ltl.core.parser.node.TWeakFair;
import de.prob.parserbase.ProBParserBase;
import de.prob.prolog.output.IPrologTermOutput;

public class PrologGenerator
extends DepthFirstAdapter {
    private final IPrologTermOutput p;
    private final PrologGeneratorHelper helper;

    public PrologGenerator(IPrologTermOutput pto, String currentStateID, ProBParserBase specParser) {
        this.p = pto;
        this.helper = new PrologGeneratorHelper(pto, currentStateID, specParser);
    }

    @Override
    public void defaultOut(Node node) {
        this.helper.defaultOut();
    }

    @Override
    public void defaultIn(Node node) {
        this.helper.defaultIn(node.getClass());
    }

    @Override
    public void caseAUnparsedLtl(AUnparsedLtl node) {
        TAtomicPropositionBegin token = node.getPredicate();
        this.helper.caseUnparsed(UniversalToken.createToken(token));
    }

    @Override
    public void caseAActionLtl(AActionLtl node) {
        TLSq token = node.getOperation();
        this.p.openTerm("action");
        this.helper.parseTransitionPredicate(UniversalToken.createToken(token));
        this.p.closeTerm();
    }

    @Override
    public void caseAEnabledLtl(AEnabledLtl node) {
        TEnabled token = node.getOperation();
        this.helper.enabled(UniversalToken.createToken(token));
    }

    @Override
    public void caseAAvailableLtl(AAvailableLtl node) {
        TAvailable token = node.getOperation();
        this.helper.available(UniversalToken.createToken(token));
    }

    @Override
    public void caseAStrongFairLtl(AStrongFairLtl node) {
        TStrongFair token = node.getOperation();
        this.helper.strong_fair(UniversalToken.createToken(token));
    }

    @Override
    public void caseAWeakFairLtl(AWeakFairLtl node) {
        TWeakFair token = node.getOperation();
        this.helper.weak_fair(UniversalToken.createToken(token));
    }

    @Override
    public void caseAAndFair1Ltl(AAndFair1Ltl node) {
        PLtl left_node = node.getLeft();
        PLtl right_node = node.getRight();
        this.helper.and_fair1(left_node, right_node, this);
    }

    @Override
    public void caseAAndFair2Ltl(AAndFair2Ltl node) {
        PLtl left_node = node.getLeft();
        PLtl right_node = node.getRight();
        this.helper.and_fair2(left_node, right_node, this);
    }

    @Override
    public void caseASinkLtl(ASinkLtl node) {
        this.helper.sink();
    }

    @Override
    public void caseAGoalLtl(AGoalLtl node) {
        this.helper.goal();
    }

    @Override
    public void caseADetOutputLtl(ADetOutputLtl node) {
        this.helper.det_output();
    }

    @Override
    public void caseAErrorLtl(AErrorLtl node) {
        this.helper.state_error();
    }

    @Override
    public void caseADeadlockLtl(ADeadlockLtl node) {
        this.helper.deadlock();
    }

    @Override
    public void caseACurrentLtl(ACurrentLtl node) {
        this.helper.current();
    }

    @Override
    public void caseAWeakFairAllLtl(AWeakFairAllLtl node) {
        this.helper.weak_fair_all();
    }

    @Override
    public void caseAStrongFairAllLtl(AStrongFairAllLtl node) {
        this.helper.strong_fair_all();
    }

    @Override
    public void caseAExistsLtl(AExistsLtl node) {
        this.helper.existsTerm(node, this);
    }

    @Override
    public void caseAForallLtl(AForallLtl node) {
        this.helper.forallTerm(node, this);
    }

    @Override
    public void caseAUnchangedLtl(AUnchangedLtl node) {
        this.helper.unchangedTerm(node, this);
    }

    @Override
    public void caseAChangedLtl(AChangedLtl node) {
        this.helper.changedTerm(node, this);
    }

    @Override
    public void caseADecreasingLtl(ADecreasingLtl node) {
        this.helper.decreasingTerm(node, this);
    }

    @Override
    public void caseAIncreasingLtl(AIncreasingLtl node) {
        this.helper.increasingTerm(node, this);
    }

    @Override
    public void caseABeforeAfterLtl(ABeforeAfterLtl node) {
        this.helper.before_afterTerm(node, this);
    }

    @Override
    public void caseADlkLtl(ADlkLtl node) {
        this.helper.dlk(node, this);
    }

    @Override
    public void caseADetLtl(ADetLtl node) {
        this.helper.det(node, this);
    }

    @Override
    public void caseACtrlLtl(ACtrlLtl node) {
        this.helper.ctrl(node, this);
    }

    @Override
    public void caseAOpActions(AOpActions node) {
        TActionChar token = node.getOperation();
        this.helper.parseTransitionPredicate(UniversalToken.createToken(token));
    }

    @Override
    public void inStart(Start node) {
    }

    @Override
    public void outStart(Start node) {
    }
}

