/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.rules;

import de.be4.classicalb.core.parser.analysis.prolog.MachineReference;
import de.be4.classicalb.core.parser.exceptions.CheckException;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.rules.AbstractOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ComputationOperation
extends AbstractOperation {
    private final Map<String, TIdentifierLiteral> defineMap = new HashMap<String, TIdentifierLiteral>();

    public ComputationOperation(TIdentifierLiteral computationName, String fileName, String machineName, List<MachineReference> machineReferences) {
        super(computationName, fileName, machineName, machineReferences);
    }

    public void addDefineVariable(TIdentifierLiteral identifierLiteral) throws CheckException {
        String name = identifierLiteral.getText();
        if (this.defineMap.containsKey(name)) {
            throw new CheckException("Variable '" + name + "' is defined more than once.", Arrays.asList(identifierLiteral, this.defineMap.get(name)));
        }
        if (this.readMap.containsKey(name)) {
            throw new CheckException("Variable '" + name + "' read before defined.", Arrays.asList((Node)this.readMap.get(name), identifierLiteral));
        }
        this.defineMap.put(name, identifierLiteral);
    }

    public Set<String> getDefineVariables() {
        return new HashSet<String>(this.defineMap.keySet());
    }

    public List<TIdentifierLiteral> getDefineLiterals() {
        return new ArrayList<TIdentifierLiteral>(this.defineMap.values());
    }
}

