/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.analysis.checking;

import de.be4.classicalb.core.parser.IDefinitions;
import de.be4.classicalb.core.parser.analysis.OptimizedTraversingAdapter;
import de.be4.classicalb.core.parser.analysis.checking.SemanticCheck;
import de.be4.classicalb.core.parser.exceptions.CheckException;
import de.be4.classicalb.core.parser.node.ADefinitionExpression;
import de.be4.classicalb.core.parser.node.ADefinitionPredicate;
import de.be4.classicalb.core.parser.node.ADefinitionSubstitution;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class DefinitionUsageCheck
extends OptimizedTraversingAdapter
implements SemanticCheck {
    private final IDefinitions definitions;
    private final List<CheckException> exceptions = new ArrayList<CheckException>();

    public DefinitionUsageCheck(IDefinitions definitions) {
        this.definitions = definitions;
    }

    @Override
    public void runChecks(Start rootNode) {
        if (!Utils.isCompleteMachine(rootNode)) {
            return;
        }
        rootNode.apply(this);
    }

    @Override
    public void inADefinitionPredicate(ADefinitionPredicate node) {
        this.check(node, node.getParameters().size(), node.getDefLiteral().getText());
    }

    @Override
    public void inADefinitionSubstitution(ADefinitionSubstitution node) {
        this.check(node, node.getParameters().size(), node.getDefLiteral().getText());
    }

    @Override
    public void inADefinitionExpression(ADefinitionExpression node) {
        this.check(node, node.getParameters().size(), node.getDefLiteral().getText());
    }

    private void check(Node node, int paramCount, String literal) {
        int expected = this.definitions.getParameterCount(literal);
        if (paramCount != expected) {
            this.exceptions.add(new CheckException("Number of parameters (" + paramCount + ") doesn't match declaration of definition " + literal + " (" + expected + ")", node));
        }
    }

    @Override
    public List<CheckException> getCheckExceptions() {
        return this.exceptions;
    }
}

