/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import model.ModelInJar;
import util.ToolIO;

public class MailSender {
    public static final String MODEL_NAME = "modelName";
    public static final String SPEC_NAME = "specName";
    public static final String MAIL_ADDRESS = "result.mail.address";
    private String modelName = "unknown model";
    private String specName = "unknown spec";
    private File err;
    private File out;

    private static void throttleRetry(String msg, long minutes) {
        try {
            System.err.println(msg);
            System.out.println(msg);
            Thread.sleep(minutes * 60L * 1000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    private static List<MXRecord> getMXForDomain(String aDomain) throws NamingException {
        InitialDirContext ctx = new InitialDirContext();
        Attributes attributes = ctx.getAttributes("dns:/" + aDomain, new String[]{"MX"});
        Attribute attr = attributes.get("MX");
        ArrayList<MXRecord> list = new ArrayList<MXRecord>();
        if (attr == null) {
            list.add(new MXRecord(0, aDomain));
        } else {
            for (int i = 0; i < attr.size(); ++i) {
                String[] split;
                Object object = attr.get(i);
                if (object == null || !(object instanceof String) || (split = ((String)object).split("\\s+")) == null || split.length != 2) continue;
                Integer weight = Integer.parseInt(split[0]);
                list.add(new MXRecord(weight, split[1]));
            }
        }
        Collections.sort(list);
        return list;
    }

    public static void main(String[] args) throws FileNotFoundException, UnknownHostException {
        MailSender mailSender = new MailSender();
        mailSender.send();
    }

    public MailSender() throws FileNotFoundException, UnknownHostException {
        ModelInJar.loadProperties();
        String mailto = System.getProperty(MAIL_ADDRESS);
        if (mailto != null) {
            String tmpdir = System.getProperty("java.io.tmpdir");
            this.out = new File(tmpdir + File.separator + "MC.out");
            ToolIO.out = new LogPrintStream(this.out);
            this.err = new File(tmpdir + File.separator + "MC.err");
            ToolIO.err = new ErrLogPrintStream(this.err);
        }
    }

    public MailSender(String mainFile) throws FileNotFoundException, UnknownHostException {
        this();
        this.setModelName(mainFile);
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setSpecName(String specName) {
        this.specName = specName;
    }

    public boolean send() {
        return this.send(new ArrayList<File>());
    }

    public boolean send(List<File> files) {
        return true;
    }

    private String extractBody(File out) {
        StringBuffer result = new StringBuffer();
        try {
            Scanner scanner = new Scanner(out);
            while (scanner.hasNext()) {
                String line = scanner.nextLine();
                if (line == null || line.startsWith("@!@!@")) continue;
                result.append(line);
                result.append("\n");
            }
            scanner.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            result.append("Failed to find file " + out.getAbsolutePath());
        }
        return result.toString();
    }

    private static class ErrLogPrintStream
    extends PrintStream {
        public ErrLogPrintStream(File file) throws FileNotFoundException {
            super(new FileOutputStream(file));
        }

        @Override
        public void println(String str) {
            System.err.println(str);
            super.println(str);
        }
    }

    private static class LogPrintStream
    extends PrintStream {
        public LogPrintStream(File file) throws FileNotFoundException {
            super(new FileOutputStream(file));
        }

        @Override
        public void println(String str) {
            System.out.println(str);
            super.println(str);
        }
    }

    private static class MXRecord
    implements Comparable<MXRecord> {
        public Integer weight;
        public String hostname;

        public MXRecord(int aWeight, String aHostname) {
            this.weight = aWeight;
            this.hostname = aHostname;
        }

        @Override
        public int compareTo(MXRecord o) {
            return this.weight.compareTo(o.weight);
        }
    }
}

