/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import tlc2.tool.Action;
import tlc2.tool.TLCState;
import tlc2.util.BitVector;
import tlc2.util.IStateWriter;
import tlc2.util.StateWriter;
import util.FileUtil;

public class DotStateWriter
extends StateWriter {
    private static final String dotColorScheme = "paired12";
    private final Map<String, Integer> actionToColors = new HashMap<String, Integer>();
    private final Map<Integer, Set<Long>> rankToNodes = new HashMap<Integer, Set<Long>>();
    private final boolean colorize;
    private final boolean actionLabels;
    private Integer colorGen = 1;
    private final boolean snapshot;

    public DotStateWriter(String fname, String strict) throws IOException {
        this(fname, strict, false, false, false);
    }

    public DotStateWriter(String fname, boolean colorize, boolean actionLabels, boolean snapshot) throws IOException {
        this(fname, "strict ", colorize, actionLabels, snapshot);
    }

    public DotStateWriter(String fname, String strict, boolean colorize, boolean actionLabels, boolean snapshot) throws IOException {
        super(fname);
        this.colorize = colorize;
        this.actionLabels = actionLabels;
        this.snapshot = snapshot;
        this.writer.append(strict + "digraph DiskGraph {\n");
        if (colorize) {
            this.writer.append(String.format("edge [colorscheme=\"%s\"]\n", dotColorScheme));
        }
        this.writer.append("nodesep=0.35;\n");
        this.writer.append("subgraph cluster_graph {\n");
        this.writer.append("color=\"white\";\n");
        this.writer.flush();
    }

    @Override
    public boolean isDot() {
        return true;
    }

    @Override
    public synchronized void writeState(TLCState state) {
        this.writer.append(Long.toString(state.fingerPrint()));
        this.writer.append(" [label=\"");
        this.writer.append(DotStateWriter.states2dot(state));
        this.writer.append("\",style = filled]");
        this.writer.append("\n");
        this.maintainRanks(state);
        if (this.snapshot) {
            try {
                this.snapshot();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    protected void maintainRanks(TLCState state) {
        this.rankToNodes.computeIfAbsent(state.getLevel(), k -> new HashSet()).add(state.fingerPrint());
    }

    @Override
    public synchronized void writeState(TLCState state, TLCState successor, boolean successorStateIsNew) {
        this.writeState(state, successor, successorStateIsNew, IStateWriter.Visualization.DEFAULT);
    }

    @Override
    public synchronized void writeState(TLCState state, TLCState successor, boolean successorStateIsNew, Action action) {
        this.writeState(state, successor, null, 0, 0, successorStateIsNew, IStateWriter.Visualization.DEFAULT, action);
    }

    @Override
    public synchronized void writeState(TLCState state, TLCState successor, boolean successorStateIsNew, IStateWriter.Visualization visualization) {
        this.writeState(state, successor, null, 0, 0, successorStateIsNew, visualization, null);
    }

    @Override
    public synchronized void writeState(TLCState state, TLCState successor, BitVector actionChecks, int from, int length, boolean successorStateIsNew) {
        this.writeState(state, successor, actionChecks, from, length, successorStateIsNew, IStateWriter.Visualization.DEFAULT, null);
    }

    public synchronized void writeState(TLCState state, TLCState successor, BitVector actionChecks, int from, int length, boolean successorStateIsNew, IStateWriter.Visualization visualization, Action action) {
        String successorsFP = Long.toString(successor.fingerPrint());
        this.writer.append(Long.toString(state.fingerPrint()));
        this.writer.append(" -> ");
        this.writer.append(successorsFP);
        if (visualization == IStateWriter.Visualization.STUTTERING) {
            this.writer.append(" [style=\"dashed\"];\n");
        } else {
            if (action != null) {
                String transitionLabel = this.dotTransitionLabel(state, successor, action);
                this.writer.append(transitionLabel);
            }
            this.writer.append(";\n");
            if (successorStateIsNew) {
                this.writer.append(successorsFP);
                this.writer.append(" [label=\"");
                this.writer.append(DotStateWriter.states2dot(successor));
                this.writer.append("\"]");
                this.writer.append(";\n");
            }
        }
        this.maintainRanks(state);
        if (this.snapshot) {
            try {
                this.snapshot();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    protected Integer getActionColor(Action action) {
        if (action == null) {
            return 1;
        }
        String actionName = action.getName().toString();
        if (this.actionToColors.containsKey(actionName)) {
            return this.actionToColors.get(actionName);
        }
        DotStateWriter dotStateWriter = this;
        Integer n = dotStateWriter.colorGen;
        Integer n2 = dotStateWriter.colorGen = Integer.valueOf(dotStateWriter.colorGen + 1);
        this.actionToColors.put(actionName, this.colorGen);
        return this.colorGen;
    }

    protected String dotTransitionLabel(TLCState state, TLCState successor, Action action) {
        String color = this.colorize ? this.getActionColor(action).toString() : "black";
        String actionName = this.actionLabels ? action.getName().toString() : "";
        String labelFmtStr = " [label=\"%s\",color=\"%s\",fontcolor=\"%s\"]";
        return String.format(" [label=\"%s\",color=\"%s\",fontcolor=\"%s\"]", actionName, color, color);
    }

    protected String dotLegend(String name, Set<String> actions) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("subgraph %s {", "cluster_legend"));
        sb.append("graph[style=bold];");
        sb.append("label = \"Next State Actions\" style=\"solid\"\n");
        sb.append(String.format("node [ labeljust=\"l\",colorscheme=\"%s\",style=filled,shape=record ]\n", dotColorScheme));
        for (String action : actions) {
            String str = String.format("%s [label=\"%s\",fillcolor=%d]", action.replaceAll("!", ":"), action, this.actionToColors.get(action));
            sb.append(str);
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    protected static String states2dot(TLCState state) {
        return state.toString().replace("\\", "\\\\").replace("\"", "\\\"").trim().replace("\n", "\\n");
    }

    @Override
    public void close() {
        for (Set<Long> entry : this.rankToNodes.values()) {
            this.writer.append("{rank = same; ");
            for (Long l : entry) {
                this.writer.append(l + ";");
            }
            this.writer.append("}\n");
        }
        this.writer.append("}\n");
        if (this.colorize && this.actionToColors.size() > 1) {
            this.writer.append(this.dotLegend("DotLegend", this.actionToColors.keySet()));
        }
        this.writer.append("}");
        super.close();
    }

    @Override
    public void snapshot() throws IOException {
        this.writer.flush();
        String snapshot = this.fname.replace(".dot", "_snapshot.dot");
        FileUtil.copyFile(this.fname, snapshot);
        StringBuffer buf = new StringBuffer();
        for (Set<Long> entry : this.rankToNodes.values()) {
            buf.append("{rank = same; ");
            for (Long l : entry) {
                buf.append(l + ";");
            }
            buf.append("}\n");
        }
        buf.append("}\n");
        if (this.colorize && this.actionToColors.size() > 1) {
            buf.append(this.dotLegend("DotLegend", this.actionToColors.keySet()));
        }
        buf.append("}");
        Files.write(Paths.get(snapshot, new String[0]), buf.toString().getBytes(), StandardOpenOption.APPEND);
    }
}

