/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.io.IOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import tlc2.tool.TLCTrace;
import tlc2.tool.distributed.fp.DistributedFPSet;
import tlc2.tool.distributed.fp.FPSetRMI;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.util.BitVector;
import tlc2.util.LongVec;

public abstract class FPSet
extends UnicastRemoteObject
implements FPSetRMI {
    protected static final long LongSize = 8L;
    protected long statesSeen = 0L;
    protected final FPSetConfiguration fpSetConfig;

    protected FPSet(FPSetConfiguration fpSetConfig) throws RemoteException {
        this.fpSetConfig = fpSetConfig;
    }

    public abstract FPSet init(int var1, String var2, String var3) throws IOException;

    public void incWorkers(int num) {
    }

    @Override
    public abstract long size();

    @Override
    public abstract boolean put(long var1) throws IOException;

    @Override
    public abstract boolean contains(long var1) throws IOException;

    @Override
    public void close() {
    }

    @Override
    public void addThread() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exit(boolean cleanup) throws IOException {
        DistributedFPSet.shutdown();
        FPSet fPSet = this;
        synchronized (fPSet) {
            this.notify();
        }
    }

    @Override
    public abstract long checkFPs() throws IOException;

    @Override
    public abstract void beginChkpt() throws IOException;

    @Override
    public abstract void commitChkpt() throws IOException;

    @Override
    public abstract void recover(TLCTrace var1) throws IOException;

    public abstract void recoverFP(long var1) throws IOException;

    @Override
    public abstract void beginChkpt(String var1) throws IOException;

    @Override
    public abstract void commitChkpt(String var1) throws IOException;

    @Override
    public abstract void recover(String var1) throws IOException;

    @Override
    public boolean checkInvariant() throws IOException {
        return true;
    }

    public boolean checkInvariant(long expectFPs) throws IOException {
        return true;
    }

    @Override
    public BitVector putBlock(LongVec fpv) throws IOException {
        int size = fpv.size();
        BitVector bv = new BitVector(size);
        for (int i = 0; i < fpv.size(); ++i) {
            if (this.put(fpv.elementAt(i))) continue;
            bv.set(i);
        }
        return bv;
    }

    @Override
    public BitVector containsBlock(LongVec fpv) throws IOException {
        this.statesSeen += (long)fpv.size();
        BitVector bv = new BitVector(fpv.size());
        for (int i = 0; i < fpv.size(); ++i) {
            if (this.contains(fpv.elementAt(i))) continue;
            bv.set(i);
        }
        return bv;
    }

    @Override
    public long getStatesSeen() throws RemoteException {
        return this.statesSeen;
    }

    public FPSetConfiguration getConfiguration() {
        return this.fpSetConfig;
    }

    public static boolean isValid(int fpBits) {
        return fpBits >= 0 && fpBits <= 30;
    }

    public void unexportObject(boolean force) throws NoSuchObjectException {
        UnicastRemoteObject.unexportObject(this, force);
    }
}

