/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import tla2tex.Debug;
import tla2tex.Misc;
import tla2tex.Position;
import tla2tex.Token;

public class CommentToken
extends Token {
    public int rsubtype;
    public static final int NORMAL = 1;
    public static final int LINE = 2;
    public static final int BEGIN_OVERRUN = 3;
    public static final int END_OVERRUN = 4;
    public static final int OVERRUN = 5;
    public int subtype;
    public static final int ONE_LINE = 6;
    public static final int BEGIN_MULTI = 7;
    public static final int MULTI = 8;
    public static final int NULL = 9;
    public static final int PAR = 10;
    private int delimiters = 0;

    public CommentToken(String str, int col, int sub, boolean pseudo) {
        this.type = 5;
        this.column = col;
        this.string = str;
        this.rsubtype = sub;
        this.subtype = 0;
        switch (this.rsubtype) {
            case 1: {
                this.delimiters = pseudo ? 2 : 4;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.delimiters = pseudo ? 0 : 2;
                break;
            }
            case 5: {
                break;
            }
            default: {
                Debug.ReportBug("CommentToken constructor called with illegal subtype");
            }
        }
    }

    @Override
    public int getWidth() {
        if (this.string == null) {
            return 0;
        }
        return this.string.length() + this.delimiters;
    }

    public static void ProcessComments(Token[][] spec) {
        int beginLine = -1;
        for (int line = 0; line < spec.length; ++line) {
            boolean beginMultiLine = false;
            boolean endMultiLine = false;
            for (int item = 0; item < spec[line].length; ++item) {
                if (spec[line][item].type == 5) {
                    boolean starLine = true;
                    CommentToken tok = (CommentToken)spec[line][item];
                    if (item == spec[line].length - 1) {
                        int ch;
                        if (tok.rsubtype != 2 && tok.rsubtype != 1 || tok.string.length() == 0) {
                            starLine = false;
                        }
                        for (ch = 0; starLine && ch < tok.string.length() && ch <= 3; ++ch) {
                            if (tok.string.charAt(ch) == '*' || tok.string.charAt(ch) == '-') continue;
                            starLine = false;
                        }
                        for (ch = 4; starLine && ch < tok.string.length(); ++ch) {
                            if (tok.string.charAt(ch) == '*' || tok.string.charAt(ch) == '-' || tok.string.charAt(ch) == ' ') continue;
                            starLine = false;
                        }
                        if (beginLine != -1 && (tok.rsubtype != 2 && tok.rsubtype != 1 || tok.column != spec[beginLine][spec[beginLine].length - 1].column || starLine)) {
                            endMultiLine = true;
                        }
                        if (starLine && (beginLine == -1 || tok.column != spec[beginLine][spec[beginLine].length - 1].column)) {
                            beginMultiLine = true;
                        }
                    }
                    switch (tok.rsubtype) {
                        case 1: 
                        case 2: {
                            if (beginMultiLine) {
                                tok.subtype = 7;
                                break;
                            }
                            if (endMultiLine) {
                                if (starLine) {
                                    tok.subtype = 9;
                                    break;
                                }
                                tok.subtype = 6;
                                break;
                            }
                            if (beginLine != -1 && item == spec[line].length - 1) {
                                tok.subtype = 8;
                                break;
                            }
                            tok.subtype = 6;
                            break;
                        }
                        case 3: {
                            if (item == 0) {
                                tok.subtype = 10;
                                break;
                            }
                            tok.subtype = 6;
                            break;
                        }
                        case 4: {
                            if (item == spec[line].length - 1) {
                                tok.subtype = 10;
                                break;
                            }
                            tok.subtype = 6;
                            break;
                        }
                        case 5: {
                            tok.subtype = 10;
                            break;
                        }
                        default: {
                            Debug.ReportBug("Bad token rsubtype in CommentToken.ProcessComments");
                        }
                    }
                    if (tok.subtype != 8 && tok.subtype != 9) continue;
                    tok.aboveAlign = new Position(beginLine, spec[beginLine].length - 1);
                    continue;
                }
                if (beginLine == -1 || item != spec[line].length - 1) continue;
                endMultiLine = true;
            }
            if (endMultiLine || spec[line].length == 0) {
                beginLine = -1;
            }
            if (!beginMultiLine) continue;
            beginLine = line;
        }
    }

    @Override
    public String toString() {
        String rstypeName = "";
        String stypeName = "";
        switch (this.rsubtype) {
            case 1: {
                rstypeName = "NORMAL";
                break;
            }
            case 2: {
                rstypeName = "LINE";
                break;
            }
            case 3: {
                rstypeName = "BEGIN_OVERRUN";
                break;
            }
            case 4: {
                rstypeName = "END_OVERRUN";
                break;
            }
            case 5: {
                rstypeName = "OVERRUN";
            }
        }
        switch (this.subtype) {
            case 6: {
                stypeName = "ONE_LINE";
                break;
            }
            case 7: {
                stypeName = "BEGIN_MULTI";
                break;
            }
            case 8: {
                stypeName = "MULTI";
                break;
            }
            case 9: {
                stypeName = "NULL";
                break;
            }
            case 10: {
                stypeName = "PAR";
            }
        }
        return Misc.BreakLine(this.mostOfString() + ",\t subtype |-> " + stypeName + ",\t rsubtype |-> " + rstypeName + ",\t delim |-> " + this.delimiters + "]");
    }
}

