/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ProofNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.xml.SymbolContext;

public class LeafProofNode
extends ProofNode {
    LevelNode[] facts = null;
    SymbolNode[] defs = null;
    boolean omitted;
    boolean isOnly;

    public LeafProofNode(TreeNode stn, LevelNode[] theFacts, SymbolNode[] theDefs, boolean omit, boolean only) {
        super(33, stn);
        this.facts = theFacts;
        this.defs = theDefs;
        this.omitted = omit;
        this.isOnly = only;
    }

    public LevelNode[] getFacts() {
        return this.facts;
    }

    public SymbolNode[] getDefs() {
        return this.defs;
    }

    public boolean getOmitted() {
        return this.omitted;
    }

    public boolean getOnlyFlag() {
        return this.isOnly;
    }

    @Override
    public boolean levelCheck(int iter) {
        if (this.levelChecked >= iter) {
            return this.levelCorrect;
        }
        return this.levelCheckSubnodes(iter, this.facts);
    }

    @Override
    public SemanticNode[] getChildren() {
        if (this.facts == null || this.facts.length == 0) {
            return null;
        }
        SemanticNode[] res = new SemanticNode[this.facts.length];
        for (int i = 0; i < this.facts.length; ++i) {
            res[i] = this.facts[i];
        }
        return res;
    }

    @Override
    public void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        for (int i = 0; i < this.facts.length; ++i) {
            this.facts[i].walkGraph(semNodesTable, visitor);
        }
        visitor.postVisit(this);
    }

    @Override
    public String toString(int depth) {
        int i;
        if (depth <= 0) {
            return "";
        }
        String ret = "\n*LeafProofNode:\n" + super.toString(depth) + Strings.indent(2, "\nfacts:");
        for (i = 0; i < this.facts.length; ++i) {
            ret = ret + Strings.indent(4, this.facts[i].toString(depth - 1));
        }
        ret = ret + Strings.indent(2, "\ndefs:");
        for (i = 0; i < this.defs.length; ++i) {
            ret = ret + Strings.indent(4, this.defs[i].toString(depth - 1));
        }
        ret = ret + Strings.indent(2, "\nomitted: " + this.omitted) + Strings.indent(2, "\nonlyFlag: " + this.isOnly);
        return ret;
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context) {
        Element e;
        if (this.getOmitted()) {
            e = doc.createElement("omitted");
        } else if (this.getFacts().length == 0 && this.getDefs().length == 0) {
            e = doc.createElement("obvious");
        } else {
            int i;
            e = doc.createElement("by");
            Element factse = doc.createElement("facts");
            Element definitions = doc.createElement("defs");
            for (i = 0; i < this.facts.length; ++i) {
                factse.appendChild(this.facts[i].export(doc, context));
            }
            for (i = 0; i < this.defs.length; ++i) {
                definitions.appendChild(this.defs[i].export(doc, context));
            }
            e.appendChild(factse);
            e.appendChild(definitions);
            if (this.getOnlyFlag()) {
                e.appendChild(doc.createElement("only"));
            }
        }
        return e;
    }
}

