/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.translation;

import de.be4.classicalb.core.parser.util.Utils;
import de.tla2b.analysis.AbstractASTVisitor;
import de.tla2b.analysis.BOperation;
import de.tla2b.analysis.SpecAnalyser;
import java.util.HashSet;
import java.util.Set;
import tla2sany.semantic.AssumeNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SymbolNode;

public class BDefinitionsFinder
extends AbstractASTVisitor {
    private final Set<OpDefNode> bDefinitionsSet = new HashSet<OpDefNode>();

    public BDefinitionsFinder(SpecAnalyser specAnalyser) {
        if (specAnalyser.getConfigFileEvaluator() != null) {
            this.bDefinitionsSet.addAll(specAnalyser.getConfigFileEvaluator().getConstantOverrides().values());
            this.bDefinitionsSet.addAll(specAnalyser.getConfigFileEvaluator().getOperatorOverrides().values());
        }
        for (BOperation op : specAnalyser.getBOperations()) {
            this.visitExprNode(op.getNode());
            for (OpApplNode opApplNode : op.getExistQuans()) {
                ExprNode[] bdedQuantBounds;
                for (ExprNode exprNode : bdedQuantBounds = opApplNode.getBdedQuantBounds()) {
                    this.visitExprNode(exprNode);
                }
            }
        }
        if (specAnalyser.getInits() != null) {
            for (int i = 0; i < specAnalyser.getInits().size(); ++i) {
                this.visitExprNode(specAnalyser.getInits().get(i));
            }
        }
        for (AssumeNode assumeNode : specAnalyser.getModuleNode().getAssumptions()) {
            this.visitAssumeNode(assumeNode);
        }
        this.bDefinitionsSet.addAll(specAnalyser.getInvariants());
        for (LevelNode levelNode : specAnalyser.getModuleNode().getOpDefs()) {
            String defName = ((SymbolNode)levelNode).getName().toString();
            if (!Utils.isProBSpecialDefinitionName(defName)) continue;
            this.bDefinitionsSet.add((OpDefNode)levelNode);
        }
        HashSet<OpDefNode> temp = new HashSet<OpDefNode>(this.bDefinitionsSet);
        for (OpDefNode opDefNode : temp) {
            this.visitExprNode(opDefNode.getBody());
        }
    }

    @Override
    public void visitUserDefinedNode(OpApplNode n) {
        OpDefNode def = (OpDefNode)n.getOperator();
        if (this.bDefinitionsSet.add(def)) {
            this.visitExprNode(def.getBody());
        }
        for (ExprOrOpArgNode exprOrOpArgNode : n.getArgs()) {
            this.visitExprOrOpArgNode(exprOrOpArgNode);
        }
    }

    public Set<OpDefNode> getBDefinitionsSet() {
        return this.bDefinitionsSet;
    }
}

