/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.config;

import de.tla2b.config.ConfigfileEvaluator;
import de.tla2b.config.TLCValueNode;
import java.util.Map;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.AssumeNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SymbolNode;
import tlc2.tool.BuiltInOPs;

public class ModuleOverrider
extends BuiltInOPs {
    private final ModuleNode moduleNode;
    private final ConfigfileEvaluator conEval;

    private ModuleOverrider(ModuleNode moduleNode, ConfigfileEvaluator conEval) {
        this.moduleNode = moduleNode;
        if (conEval == null) {
            throw new IllegalArgumentException("ConfigfileEvaluator cannot be null");
        }
        this.conEval = conEval;
    }

    public static void run(ModuleNode moduleNode, ConfigfileEvaluator conEval) {
        new ModuleOverrider(moduleNode, conEval).start();
    }

    private void start() {
        Map<OpDefNode, TLCValueNode> operatorAssignments = this.conEval.getOperatorAssignments();
        for (OpDefNode def : this.moduleNode.getOpDefs()) {
            if (operatorAssignments.containsKey(def)) {
                def.setBody(operatorAssignments.get(def));
                continue;
            }
            if (!operatorAssignments.containsKey(def.getSource())) continue;
            def.setBody(operatorAssignments.get(def.getSource()));
        }
        for (OpDefNode def : this.moduleNode.getOpDefs()) {
            OpApplNode res = this.visitExprNode(def.getBody());
            if (res == null) continue;
            def.setBody(res);
        }
        AssumeNode[] assumes = this.moduleNode.getAssumptions();
        for (int i = 0; i < assumes.length; ++i) {
            OpApplNode res = this.visitExprNode(assumes[i].getAssume());
            if (res == null) continue;
            assumes[i] = new AssumeNode(assumes[i].stn, res, null, null);
        }
    }

    private OpApplNode visitExprOrOpArgNode(ExprOrOpArgNode n) {
        if (n instanceof ExprNode) {
            return this.visitExprNode((ExprNode)n);
        }
        throw new RuntimeException("OpArgNode not implemented yet");
    }

    private OpApplNode visitExprNode(ExprNode n) {
        switch (n.getKind()) {
            case 9: {
                return this.visitOpApplNode((OpApplNode)n);
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return null;
            }
            case 10: {
                LetInNode l = (LetInNode)n;
                for (OpDefNode let : l.getLets()) {
                    this.visitExprNode(let.getBody());
                }
                OpApplNode res = this.visitExprNode(l.getBody());
                if (res != null) {
                    throw new RuntimeException();
                }
                return null;
            }
        }
        return null;
    }

    private OpApplNode visitOpApplNode(OpApplNode n) {
        SymbolNode s = n.getOperator();
        switch (s.getKind()) {
            case 2: {
                OpApplNode newNode;
                if (!this.conEval.getConstantOverrides().containsKey((OpDeclNode)s) || s.getArity() <= 0) break;
                SymbolNode newOperator = this.conEval.getConstantOverrides().get((OpDeclNode)s);
                try {
                    newNode = new OpApplNode(newOperator, n.getArgs(), n.getTreeNode(), null);
                }
                catch (AbortException e) {
                    throw new RuntimeException(e);
                }
                return newNode;
            }
            case 3: 
            case 11: {
                break;
            }
            case 7: {
                this.replaceArgs(n.getBdedQuantBounds());
                break;
            }
            case 5: {
                OpApplNode newNode;
                Map<OpDefNode, OpDefNode> operatorOverrides = this.conEval.getOperatorOverrides();
                OpDefNode operator = (OpDefNode)n.getOperator();
                if (!operatorOverrides.containsKey(operator.getSource()) && !operatorOverrides.containsKey(operator)) break;
                SymbolNode newOperator = operatorOverrides.containsKey(operator.getSource()) ? (SymbolNode)operatorOverrides.get(operator.getSource()) : (SymbolNode)operatorOverrides.get(operator);
                try {
                    newNode = new OpApplNode(newOperator, n.getArgs(), n.getTreeNode(), ((OpDefNode)n.getOperator()).getOriginallyDefinedInModuleNode());
                }
                catch (AbortException e) {
                    throw new RuntimeException(e);
                }
                return newNode;
            }
        }
        this.replaceArgs(n.getArgs());
        return null;
    }

    private void replaceArgs(ExprOrOpArgNode[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                OpApplNode res;
                if (args[i] == null || (res = this.visitExprOrOpArgNode(args[i])) == null) continue;
                args[i] = res;
            }
        }
    }
}

