/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.analysis;

import de.tla2b.analysis.SpecAnalyser;
import de.tla2b.config.ConfigfileEvaluator;
import de.tla2b.config.TLCValueNode;
import de.tla2b.exceptions.NotImplementedException;
import de.tla2b.exceptions.TLA2BException;
import de.tla2b.exceptions.TLA2BFrontEndException;
import de.tla2b.exceptions.TypeErrorException;
import de.tla2b.exceptions.UnificationException;
import de.tla2b.global.BBuildIns;
import de.tla2b.global.BBuiltInOPs;
import de.tla2b.global.TranslationGlobals;
import de.tla2b.types.AbstractHasFollowers;
import de.tla2b.types.BoolType;
import de.tla2b.types.FunctionType;
import de.tla2b.types.IDefaultableType;
import de.tla2b.types.IntType;
import de.tla2b.types.IntegerOrRealType;
import de.tla2b.types.RealType;
import de.tla2b.types.SetType;
import de.tla2b.types.StringType;
import de.tla2b.types.StructOrFunctionType;
import de.tla2b.types.StructType;
import de.tla2b.types.TLAType;
import de.tla2b.types.TupleOrFunction;
import de.tla2b.types.TupleType;
import de.tla2b.types.UntypedType;
import de.tla2b.util.DebugUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tla2sany.semantic.AssumeNode;
import tla2sany.semantic.AtNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.NumeralNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.StringNode;
import tla2sany.semantic.SymbolNode;
import tlc2.tool.BuiltInOPs;

public class TypeChecker
extends BuiltInOPs
implements BBuildIns,
TranslationGlobals {
    private static final int TEMP_TYPE_ID = 6;
    private int paramId = 5;
    private List<ExprNode> inits;
    private ExprNode nextExpr;
    private final Set<OpDefNode> usedDefinitions;
    private final Set<OpDefNode> bDefinitions;
    private final List<SymbolNode> symbolNodeList = new ArrayList<SymbolNode>();
    private final Map<WeakReference<IDefaultableType>, Void> possibleUnfinishedTypes = new HashMap<WeakReference<IDefaultableType>, Void>();
    private final ModuleNode moduleNode;
    private List<OpDeclNode> bConstList;
    private final SpecAnalyser specAnalyser;
    private Map<OpDeclNode, TLCValueNode> constantAssignments;
    private ConfigfileEvaluator conEval;

    public TypeChecker(ModuleNode moduleNode, ConfigfileEvaluator conEval, SpecAnalyser specAnalyser) {
        this.moduleNode = moduleNode;
        this.specAnalyser = specAnalyser;
        if (conEval != null) {
            this.bConstList = conEval.getbConstantList();
            this.constantAssignments = conEval.getConstantAssignments();
            this.conEval = conEval;
        }
        this.inits = specAnalyser.getInits();
        this.nextExpr = specAnalyser.getNext();
        this.usedDefinitions = specAnalyser.getUsedDefinitions();
        this.bDefinitions = specAnalyser.getBDefinitions();
    }

    public TypeChecker(ModuleNode moduleNode, SpecAnalyser specAnalyser) {
        this.moduleNode = moduleNode;
        this.specAnalyser = specAnalyser;
        OpDefNode[] defs = moduleNode.getOpDefs();
        this.usedDefinitions = Collections.singleton(defs[defs.length - 1]);
        this.bDefinitions = specAnalyser.getBDefinitions();
    }

    public void start() throws TLA2BException {
        for (OpDeclNode con : this.moduleNode.getConstantDecls()) {
            if (this.constantAssignments != null && this.constantAssignments.containsKey(con)) {
                this.setLocalTypeAndFollowers(con, this.constantAssignments.get(con).getType());
                continue;
            }
            if (this.getLocalType(con) != null) continue;
            this.setLocalTypeAndFollowers(con, new UntypedType());
        }
        for (OpDeclNode var : this.moduleNode.getVariableDecls()) {
            if (this.getLocalType(var) != null) continue;
            this.setLocalTypeAndFollowers(var, new UntypedType());
        }
        this.evalDefinitions(this.moduleNode.getOpDefs());
        if (this.conEval != null) {
            for (Map.Entry entry : this.conEval.getConstantOverrides().entrySet()) {
                OpDeclNode con = (OpDeclNode)entry.getKey();
                if (!this.bConstList.contains(con)) continue;
                TLAType defType = this.getLocalType((SemanticNode)entry.getValue());
                TLAType conType = this.getLocalType(con);
                try {
                    this.setLocalType(con, defType.unify(conType));
                }
                catch (UnificationException e) {
                    throw new TypeErrorException(String.format("Expected %s, found %s at constant '%s'.", defType, conType, con.getName()));
                }
            }
        }
        this.evalAssumptions(this.moduleNode.getAssumptions());
        if (this.inits != null) {
            for (ExprNode exprNode : this.inits) {
                this.visitExprNode(exprNode, BoolType.getInstance());
            }
        }
        if (this.nextExpr != null) {
            this.visitExprNode(this.nextExpr, BoolType.getInstance());
        }
        this.checkIfAllIdentifiersHaveAType();
    }

    private void checkIfAllIdentifiersHaveAType() throws TLA2BException {
        for (WeakReference<IDefaultableType> typeRef : this.possibleUnfinishedTypes.keySet()) {
            IDefaultableType type = (IDefaultableType)typeRef.get();
            if (type == null) continue;
            type.setToDefault();
        }
        for (OpDeclNode var : this.moduleNode.getVariableDecls()) {
            TLAType varType = this.getLocalType(var);
            if (varType != null && !varType.isUntyped()) continue;
            throw new TypeErrorException("The type of the variable '" + var.getName() + "' can not be inferred: " + varType);
        }
        for (OpDeclNode con : this.moduleNode.getConstantDecls()) {
            TLAType conType;
            if (this.bConstList != null && !this.bConstList.contains(con) || (conType = this.getLocalType(con)) != null && !conType.isUntyped()) continue;
            throw new TypeErrorException("The type of constant " + con.getName() + " is still untyped: " + conType);
        }
    }

    private void evalDefinitions(OpDefNode[] opDefs) throws TLA2BException {
        for (OpDefNode def : opDefs) {
            String moduleName = def.getOriginallyDefinedInModuleNode().getName().toString();
            if (STANDARD_MODULES.contains(moduleName) || BBuiltInOPs.isBBuiltInOp(def) || !this.usedDefinitions.contains(def) && !this.bDefinitions.contains(def)) continue;
            this.visitOpDefNode(def);
        }
    }

    public void visitOpDefNode(OpDefNode def) throws TLA2BException {
        for (FormalParamNode p : def.getParams()) {
            if (p.getArity() > 0) {
                throw new TLA2BFrontEndException(String.format("TLA2B does not support 2nd-order operators: '%s'%n %s ", def.getName(), def.getLocation()));
            }
            this.setLocalTypeAndFollowers(p, new UntypedType());
        }
        TLAType found = this.visitExprNode(def.getBody(), new UntypedType());
        this.setLocalTypeAndFollowers(def, found);
    }

    private void evalAssumptions(AssumeNode[] assumptions) throws TLA2BException {
        for (AssumeNode assumeNode : assumptions) {
            this.visitExprNode(assumeNode.getAssume(), BoolType.getInstance());
        }
    }

    private TLAType visitExprOrOpArgNode(ExprOrOpArgNode n, TLAType expected) throws TLA2BException {
        if (n instanceof ExprNode) {
            return this.visitExprNode((ExprNode)n, expected);
        }
        throw new NotImplementedException("OpArgNode not implemented yet");
    }

    private TLAType visitExprNode(ExprNode exprNode, TLAType expected) throws TLA2BException {
        switch (exprNode.getKind()) {
            case 100: {
                TLCValueNode valueNode = (TLCValueNode)exprNode;
                return TypeChecker.unify(valueNode.getType(), expected, valueNode.getValue().toString() + " (assigned in the configuration file)", exprNode);
            }
            case 9: {
                return this.visitOpApplNode((OpApplNode)exprNode, expected);
            }
            case 16: {
                return TypeChecker.unify(IntType.getInstance(), expected, exprNode.toString(), exprNode);
            }
            case 17: {
                return TypeChecker.unify(RealType.getInstance(), expected, exprNode.toString(), exprNode);
            }
            case 18: {
                return TypeChecker.unify(StringType.getInstance(), expected, ((StringNode)exprNode).getRep().toString(), exprNode);
            }
            case 19: {
                TLAType type = this.getLocalType(((AtNode)exprNode).getExceptComponentRef().getArgs()[1]);
                return this.unifyAndSetLocalTypeWithFollowers(type, expected, "@", exprNode);
            }
            case 10: {
                LetInNode l = (LetInNode)exprNode;
                for (OpDefNode let : l.getLets()) {
                    this.visitOpDefNode(let);
                }
                return this.visitExprNode(l.getBody(), expected);
            }
            case 13: {
                throw new RuntimeException("SubstInKind should never occur after InstanceTransformation");
            }
        }
        throw new NotImplementedException("ExprNode not yet supported: " + exprNode.toString(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private TLAType visitOpApplNode(OpApplNode n, TLAType expected) throws TLA2BException {
        switch (n.getOperator().getKind()) {
            case 2: {
                symbolNode = n.getOperator();
                vName = symbolNode.getName().toString();
                c = this.getLocalType(symbolNode);
                if (c == null) {
                    throw new TypeErrorException(vName + " has no type yet!");
                }
                return this.unifyAndSetLocalTypeWithFollowers(c, expected, vName, n);
            }
            case 3: {
                symbolNode = n.getOperator();
                vName = symbolNode.getName().toString();
                v = this.getLocalType(symbolNode);
                if (v == null) {
                    var = this.specAnalyser.getSymbolNodeByName(vName);
                    if (var != null) {
                        v = this.getLocalType(var);
                    } else {
                        throw new TypeErrorException(vName + " has no type yet!");
                    }
                }
                return this.unifyAndSetLocalTypeWithFollowers(v, expected, vName, n);
            }
            case 7: {
                return this.evalBuiltInKind(n, expected);
            }
            case 11: {
                symbolNode = n.getOperator();
                vName = symbolNode.getName().toString();
                t = this.getLocalType(symbolNode);
                if (t == null) {
                    t = new UntypedType();
                }
                return this.unifyAndSetLocalType(t, expected, vName, n);
            }
            case 5: {
                def = (OpDefNode)n.getOperator();
                args = n.getArgs();
                params = def.getParams();
                if (BBuiltInOPs.isBBuiltInOp(def)) {
                    return this.evalBBuiltIns(n, expected);
                }
                generic = def.getParams().length != 0;
                opType = TypeChecker.getType(def);
                if (opType != null) ** GOTO lbl47
                prevParamId = this.paramId;
                this.paramId = 5;
                try {
                    this.visitOpDefNode(def);
                }
                finally {
                    this.paramId = prevParamId;
                }
                opType = TypeChecker.getType(def);
lbl47:
                // 2 sources

                if (generic) {
                    opType = opType.cloneTLAType();
                }
                expected = TypeChecker.unify(opType, expected, def.getName().toString(), def);
                if (!TypeChecker.$assertionsDisabled && params.length != args.length) {
                    throw new AssertionError();
                }
                for (i = 0; i < args.length; ++i) {
                    param = params[i];
                    arg = args[i];
                    pType = TypeChecker.getType(param).cloneTLAType();
                    pType = this.visitExprOrOpArgNode(arg, pType);
                    prevParamId = this.paramId;
                    this.paramId = 6;
                    try {
                        this.setLocalType(param, pType);
                        continue;
                    }
                    finally {
                        this.paramId = prevParamId;
                    }
                }
                if (generic) {
                    prevParamId = this.paramId;
                    this.paramId = 6;
                    try {
                        found = this.visitExprNode(def.getBody(), expected);
                    }
                    finally {
                        this.paramId = prevParamId;
                    }
                } else {
                    found = expected;
                }
                this.setLocalTypeAndFollowers(n, found);
                return found;
            }
        }
        throw new NotImplementedException(n.getOperator().getName().toString());
    }

    private TLAType evalBuiltInKind(OpApplNode n, TLAType expected) throws TLA2BException {
        switch (TypeChecker.getOpCode(n.getOperator().getName())) {
            case 35: 
            case 40: {
                TLAType opType = TypeChecker.unify(BoolType.getInstance(), expected, n);
                TLAType left = this.visitExprOrOpArgNode(n.getArgs()[0], new UntypedType());
                this.visitExprOrOpArgNode(n.getArgs()[1], left);
                return opType;
            }
            case 6: 
            case 7: 
            case 27: 
            case 28: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                TLAType opType = TypeChecker.unify(BoolType.getInstance(), expected, n);
                for (int i = 0; i < n.getArgs().length; ++i) {
                    this.visitExprOrOpArgNode(n.getArgs()[i], BoolType.getInstance());
                }
                return opType;
            }
            case 2: 
            case 3: {
                TLAType opType = TypeChecker.unify(BoolType.getInstance(), expected, n);
                this.evalBoundedVariables(n);
                this.visitExprOrOpArgNode(n.getArgs()[0], BoolType.getInstance());
                return opType;
            }
            case 18: {
                SetType found = (SetType)TypeChecker.unify(new SetType(new UntypedType()), expected, n);
                TLAType current = found.getSubType();
                for (ExprOrOpArgNode arg : n.getArgs()) {
                    current = this.visitExprOrOpArgNode(arg, current);
                }
                return found;
            }
            case 42: 
            case 43: {
                TLAType boolType = TypeChecker.unify(BoolType.getInstance(), expected, n);
                TLAType element = this.visitExprOrOpArgNode(n.getArgs()[0], new UntypedType());
                this.visitExprOrOpArgNode(n.getArgs()[1], new SetType(element));
                return boolType;
            }
            case 44: 
            case 45: 
            case 47: {
                TLAType found = TypeChecker.unify(new SetType(new UntypedType()), expected, n);
                TLAType left = this.visitExprOrOpArgNode(n.getArgs()[0], found);
                return this.visitExprOrOpArgNode(n.getArgs()[1], left);
            }
            case 41: {
                TLAType boolType = TypeChecker.unify(BoolType.getInstance(), expected, n);
                TLAType left = this.visitExprOrOpArgNode(n.getArgs()[0], new SetType(new UntypedType()));
                this.visitExprOrOpArgNode(n.getArgs()[1], left);
                return boolType;
            }
            case 22: {
                SetType found = (SetType)TypeChecker.unify(new SetType(this.evalBoundedVariables(n)), expected, n);
                this.visitExprOrOpArgNode(n.getArgs()[0], BoolType.getInstance());
                return found;
            }
            case 19: {
                SetType found = (SetType)TypeChecker.unify(new SetType(new UntypedType()), expected, n);
                this.evalBoundedVariables(n);
                this.visitExprOrOpArgNode(n.getArgs()[0], found.getSubType());
                return found;
            }
            case 29: {
                SetType found = (SetType)TypeChecker.unify(new SetType(new UntypedType()), expected, n);
                this.visitExprOrOpArgNode(n.getArgs()[0], found.getSubType());
                return found;
            }
            case 30: {
                TLAType found = TypeChecker.unify(new SetType(new UntypedType()), expected, n);
                SetType setOfSet = (SetType)this.visitExprOrOpArgNode(n.getArgs()[0], new SetType(found));
                return setOfSet.getSubType();
            }
            case 48: {
                try {
                    OpApplNode node = (OpApplNode)n.getArgs()[0];
                    if (node.getOperator().getKind() != 3) {
                        throw new TypeErrorException("Expected variable at \"" + node.getOperator().getName() + "\":\n" + node.getLocation());
                    }
                    return this.visitExprOrOpArgNode(n.getArgs()[0], expected);
                }
                catch (ClassCastException e) {
                    throw new TypeErrorException("Expected variable as argument of prime operator:\n" + n.getArgs()[0].getLocation());
                }
            }
            case 23: {
                ArrayList<TLAType> list = new ArrayList<TLAType>();
                for (ExprOrOpArgNode arg : n.getArgs()) {
                    list.add(this.visitExprOrOpArgNode(arg, new UntypedType()));
                }
                TLAType found = TupleOrFunction.createTupleOrFunctionType(list);
                return this.unifyAndSetLocalTypeWithFollowers(found, expected, "tuple", n);
            }
            case 16: {
                FormalParamNode recFunc = n.getUnbdedQuantSymbols()[0];
                this.symbolNodeList.add(recFunc);
                this.setLocalTypeAndFollowers(recFunc, new FunctionType());
                TLAType domainType = this.evalBoundedVariables(n);
                FunctionType found = new FunctionType(domainType, new UntypedType());
                this.visitExprOrOpArgNode(n.getArgs()[0], found.getRange());
                found = (FunctionType)TypeChecker.unify(found, expected, n);
                return TypeChecker.unify(found, this.getLocalType(recFunc), n);
            }
            case 10: 
            case 12: {
                TLAType domainType = this.evalBoundedVariables(n);
                FunctionType found = new FunctionType(domainType, new UntypedType());
                this.visitExprOrOpArgNode(n.getArgs()[0], found.getRange());
                return TypeChecker.unify(found, expected, n);
            }
            case 9: {
                TLAType domType;
                ExprOrOpArgNode fun = n.getArgs()[0];
                ExprOrOpArgNode dom = n.getArgs()[1];
                if (dom instanceof OpApplNode && ((OpApplNode)dom).getOperator().getName().equals("$Tuple")) {
                    ArrayList<TLAType> domList = new ArrayList<TLAType>();
                    for (ExprOrOpArgNode arg : ((OpApplNode)dom).getArgs()) {
                        domList.add(this.visitExprOrOpArgNode(arg, new UntypedType()));
                    }
                    domType = domList.size() == 1 ? new FunctionType(IntType.getInstance(), (TLAType)domList.get(0)) : new TupleType(domList);
                } else {
                    if (dom instanceof NumeralNode && ((NumeralNode)dom).val() >= 1) {
                        NumeralNode num = (NumeralNode)dom;
                        UntypedType u = new UntypedType();
                        this.setLocalTypeAndFollowers(n, u);
                        TLAType res = this.visitExprOrOpArgNode(fun, new TupleOrFunction(num.val(), u));
                        this.setLocalTypeAndFollowers(fun, res);
                        return TypeChecker.unify(this.getLocalType(n), expected, fun.toString(), n);
                    }
                    domType = this.visitExprOrOpArgNode(dom, new UntypedType());
                }
                FunctionType func = new FunctionType(domType, expected);
                this.setLocalTypeAndFollowers(n, func);
                TLAType res = this.visitExprOrOpArgNode(n.getArgs()[0], func);
                this.setLocalTypeAndFollowers(n.getArgs()[0], res);
                return ((FunctionType)res).getRange();
            }
            case 31: {
                FunctionType func = new FunctionType();
                func = (FunctionType)this.visitExprOrOpArgNode(n.getArgs()[0], func);
                return TypeChecker.unify(new SetType(func.getDomain()), expected, n);
            }
            case 21: {
                SetType A = (SetType)this.visitExprOrOpArgNode(n.getArgs()[0], new SetType(new UntypedType()));
                SetType B = (SetType)this.visitExprOrOpArgNode(n.getArgs()[1], new SetType(new UntypedType()));
                TLAType found = new SetType(new FunctionType(A.getSubType(), B.getSubType()));
                found = TypeChecker.unify(found, expected, "set of functions", n);
                return found;
            }
            case 8: {
                return this.evalExcept(n, expected);
            }
            case 5: {
                ArrayList<TLAType> list = new ArrayList<TLAType>();
                for (int i = 0; i < n.getArgs().length; ++i) {
                    SetType t = (SetType)this.visitExprOrOpArgNode(n.getArgs()[i], new SetType(new UntypedType()));
                    list.add(t.getSubType());
                }
                TLAType found = new SetType(new TupleType(list));
                found = TypeChecker.unify(found, expected, "cartesian product", n);
                return found;
            }
            case 20: {
                StructType struct = new StructType();
                for (int i = 0; i < n.getArgs().length; ++i) {
                    OpApplNode pair2 = (OpApplNode)n.getArgs()[i];
                    StringNode field = (StringNode)pair2.getArgs()[0];
                    SetType fieldType = (SetType)this.visitExprOrOpArgNode(pair2.getArgs()[1], new SetType(new UntypedType()));
                    struct.add(field.getRep().toString(), fieldType.getSubType());
                }
                return this.unifyAndSetLocalTypeWithFollowers(new SetType(struct), expected, "set of records", n);
            }
            case 14: {
                StructType found = new StructType();
                for (int i = 0; i < n.getArgs().length; ++i) {
                    OpApplNode pair3 = (OpApplNode)n.getArgs()[i];
                    StringNode field = (StringNode)pair3.getArgs()[0];
                    TLAType fieldType = this.visitExprOrOpArgNode(pair3.getArgs()[1], new UntypedType());
                    found.add(field.getRep().toString(), fieldType);
                }
                return this.unifyAndSetLocalTypeWithFollowers(found, expected, "record constructor", n);
            }
            case 15: {
                String fieldName = ((StringNode)n.getArgs()[1]).getRep().toString();
                StructType r = (StructType)this.visitExprOrOpArgNode(n.getArgs()[0], StructType.getIncompleteStruct());
                StructType expectedStruct = StructType.getIncompleteStruct();
                expectedStruct.add(fieldName, expected);
                try {
                    r = r.unify(expectedStruct);
                }
                catch (UnificationException e) {
                    throw new TypeErrorException(String.format("Struct has no field %s with type %s: %s%n%s", fieldName, r.getType(fieldName), r, n.getLocation()));
                }
                this.setLocalTypeAndFollowers(n.getArgs()[0], r);
                return r.getType(fieldName);
            }
            case 11: {
                this.visitExprOrOpArgNode(n.getArgs()[0], BoolType.getInstance());
                TLAType then = this.visitExprOrOpArgNode(n.getArgs()[1], expected);
                TLAType eelse = this.visitExprOrOpArgNode(n.getArgs()[2], then);
                this.setLocalTypeAndFollowers(n, eelse);
                return eelse;
            }
            case 4: {
                TLAType found = expected;
                for (int i = 0; i < n.getArgs().length; ++i) {
                    OpApplNode pair4 = (OpApplNode)n.getArgs()[i];
                    if (pair4.getArgs()[0] != null) {
                        this.visitExprOrOpArgNode(pair4.getArgs()[0], BoolType.getInstance());
                    }
                    found = this.visitExprOrOpArgNode(pair4.getArgs()[1], found);
                }
                return found;
            }
            case 24: {
                ArrayList<TLAType> list = new ArrayList<TLAType>();
                for (FormalParamNode param : n.getUnbdedQuantSymbols()) {
                    UntypedType paramType = new UntypedType();
                    this.symbolNodeList.add(param);
                    this.setLocalTypeAndFollowers(param, paramType);
                    list.add(paramType);
                }
                TLAType found = list.size() == 1 ? (TLAType)list.get(0) : new TupleType(list);
                found = this.unifyAndSetLocalTypeWithFollowers(found, expected, n.getOperator().getName().toString(), n);
                this.visitExprOrOpArgNode(n.getArgs()[0], BoolType.getInstance());
                return found;
            }
            case 1: {
                TLAType found = this.evalBoundedVariables(n);
                found = TypeChecker.unify(found, expected, n);
                this.visitExprOrOpArgNode(n.getArgs()[0], BoolType.getInstance());
                return found;
            }
            case 49: {
                return BoolType.getInstance().unify(expected);
            }
            case 0: {
                return this.evalBBuiltIns(n, expected);
            }
        }
        throw new NotImplementedException("Not supported Operator: " + n.getOperator().getName() + "\n" + n.getLocation());
    }

    private TLAType evalBoundedVariables(OpApplNode n) throws TLA2BException {
        ArrayList<TLAType> domList = new ArrayList<TLAType>();
        FormalParamNode[][] params = n.getBdedQuantSymbolLists();
        ExprNode[] bounds = n.getBdedQuantBounds();
        for (int i = 0; i < bounds.length; ++i) {
            SetType boundType = (SetType)this.visitExprNode(bounds[i], new SetType(new UntypedType()));
            TLAType subType = boundType.getSubType();
            if (n.isBdedQuantATuple()[i]) {
                if (params[i].length == 1) {
                    FormalParamNode p = params[i][0];
                    FunctionType expected = new FunctionType(IntType.getInstance(), new UntypedType());
                    expected = (FunctionType)TypeChecker.unify(expected, subType, "parameter " + p.getName(), bounds[i]);
                    domList.add(expected);
                    this.symbolNodeList.add(p);
                    this.setLocalTypeAndFollowers(p, expected.getRange());
                    continue;
                }
                TupleType tuple = new TupleType(params[i].length);
                tuple = (TupleType)TypeChecker.unify(tuple, subType, "tuple", bounds[i]);
                domList.add(tuple);
                for (int j = 0; j < params[i].length; ++j) {
                    FormalParamNode p = params[i][j];
                    this.symbolNodeList.add(p);
                    this.setLocalTypeAndFollowers(p, tuple.getTypes().get(j));
                }
                continue;
            }
            for (int j = 0; j < params[i].length; ++j) {
                domList.add(subType);
                FormalParamNode p = params[i][j];
                this.symbolNodeList.add(p);
                this.setLocalTypeAndFollowers(p, subType);
            }
        }
        return domList.size() == 1 ? (TLAType)domList.get(0) : new TupleType(domList);
    }

    private TLAType evalExcept(OpApplNode n, TLAType expected) throws TLA2BException {
        TLAType t = this.visitExprOrOpArgNode(n.getArgs()[0], expected);
        this.setLocalTypeAndFollowers(n, t);
        for (int i = 1; i < n.getArgs().length; ++i) {
            TLAType domType;
            OpApplNode pair2 = (OpApplNode)n.getArgs()[i];
            UntypedType untyped = new UntypedType();
            this.setLocalTypeAndFollowers(pair2.getArgs()[1], untyped);
            TLAType valueType = this.visitExprOrOpArgNode(pair2.getArgs()[1], untyped);
            OpApplNode seq = (OpApplNode)pair2.getArgs()[0];
            LinkedList<ExprOrOpArgNode> list = new LinkedList<ExprOrOpArgNode>(Arrays.asList(seq.getArgs()));
            ExprOrOpArgNode domExpr = list.poll();
            if (domExpr instanceof StringNode) {
                String field = ((StringNode)domExpr).getRep().toString();
                TLAType res = this.evalType(list, valueType);
                t = TypeChecker.unify(t, new StructOrFunctionType(field, res), pair2);
                continue;
            }
            if (domExpr instanceof OpApplNode && ((OpApplNode)domExpr).getOperator().getName().equals("$Tuple")) {
                ArrayList<TLAType> domList = new ArrayList<TLAType>();
                for (ExprOrOpArgNode arg : ((OpApplNode)domExpr).getArgs()) {
                    domList.add(this.visitExprOrOpArgNode(arg, new UntypedType()));
                }
                domType = new TupleType(domList);
                this.setLocalType(domExpr, domType);
            } else {
                domType = this.visitExprOrOpArgNode(domExpr, new UntypedType());
            }
            TLAType rangeType = this.evalType(list, valueType);
            t = TypeChecker.unify(t, new FunctionType(domType, rangeType), pair2);
        }
        return t;
    }

    private TLAType evalType(LinkedList<ExprOrOpArgNode> list, TLAType valueType) throws TLA2BException {
        if (list.isEmpty()) {
            return valueType;
        }
        ExprOrOpArgNode head = list.poll();
        if (head instanceof StringNode) {
            String name = ((StringNode)head).getRep().toString();
            return new StructOrFunctionType(name, this.evalType(list, valueType));
        }
        TLAType t = this.visitExprOrOpArgNode(head, new UntypedType());
        return new FunctionType(t, this.evalType(list, valueType));
    }

    private TLAType evalBBuiltIns(OpApplNode n, TLAType expected) throws TLA2BException {
        switch (BBuiltInOPs.getOpcode(n.getOperator().getName())) {
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                TLAType boolType = TypeChecker.unify(BoolType.getInstance(), expected, n);
                TLAType numberType = new IntegerOrRealType();
                for (ExprOrOpArgNode arg : n.getArgs()) {
                    numberType = this.visitExprOrOpArgNode(arg, numberType);
                    this.setLocalTypeAndFollowers(arg, numberType);
                }
                return boolType;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                TLAType type = TypeChecker.unify(new IntegerOrRealType(), expected, n);
                for (ExprOrOpArgNode arg : n.getArgs()) {
                    type = this.visitExprOrOpArgNode(arg, type);
                    this.setLocalTypeAndFollowers(arg, type);
                }
                return type;
            }
            case 37: {
                TLAType realType = TypeChecker.unify(RealType.getInstance(), expected, n);
                for (ExprOrOpArgNode arg : n.getArgs()) {
                    this.visitExprOrOpArgNode(arg, realType);
                }
                return realType;
            }
            case 1: {
                TLAType type = TypeChecker.unify(new SetType(IntType.getInstance()), expected, n);
                for (ExprOrOpArgNode arg : n.getArgs()) {
                    this.visitExprOrOpArgNode(arg, IntType.getInstance());
                }
                return type;
            }
            case 13: {
                return TypeChecker.unify(new SetType(IntType.getInstance()), expected, n);
            }
            case 17: {
                return TypeChecker.unify(new SetType(IntType.getInstance()), expected, n);
            }
            case 36: {
                return TypeChecker.unify(new SetType(RealType.getInstance()), expected, n);
            }
            case 19: {
                TLAType boolType = TypeChecker.unify(BoolType.getInstance(), expected, n);
                this.visitExprOrOpArgNode(n.getArgs()[0], new SetType(new UntypedType()));
                return boolType;
            }
            case 20: {
                TLAType intType = TypeChecker.unify(IntType.getInstance(), expected, n);
                this.visitExprOrOpArgNode(n.getArgs()[0], new SetType(new UntypedType()));
                return intType;
            }
            case 23: {
                SetType S = (SetType)this.visitExprOrOpArgNode(n.getArgs()[0], new SetType(new UntypedType()));
                SetType set_of_seq = new SetType(new FunctionType(IntType.getInstance(), S.getSubType()));
                return TypeChecker.unify(set_of_seq, expected, n);
            }
            case 21: {
                TLAType intType = TypeChecker.unify(IntType.getInstance(), expected, n);
                this.visitExprOrOpArgNode(n.getArgs()[0], new FunctionType(intType, new UntypedType()));
                return intType;
            }
            case 27: {
                TLAType found = new FunctionType(IntType.getInstance(), new UntypedType());
                found = this.visitExprOrOpArgNode(n.getArgs()[0], found);
                found = this.visitExprOrOpArgNode(n.getArgs()[1], found);
                return TypeChecker.unify(found, expected, n);
            }
            case 22: {
                FunctionType found = new FunctionType(IntType.getInstance(), new UntypedType());
                found = (FunctionType)this.visitExprOrOpArgNode(n.getArgs()[0], found);
                this.visitExprOrOpArgNode(n.getArgs()[1], found.getRange());
                return TypeChecker.unify(found, expected, n);
            }
            case 24: {
                FunctionType func = new FunctionType(IntType.getInstance(), new UntypedType());
                func = (FunctionType)this.visitExprOrOpArgNode(n.getArgs()[0], func);
                return TypeChecker.unify(func.getRange(), expected, n);
            }
            case 25: {
                FunctionType found = new FunctionType(IntType.getInstance(), new UntypedType());
                found = (FunctionType)this.visitExprOrOpArgNode(n.getArgs()[0], found);
                return TypeChecker.unify(found, expected, n);
            }
            case 26: {
                TLAType found = new FunctionType(IntType.getInstance(), new UntypedType());
                found = this.visitExprOrOpArgNode(n.getArgs()[0], found);
                this.visitExprOrOpArgNode(n.getArgs()[1], IntType.getInstance());
                this.visitExprOrOpArgNode(n.getArgs()[2], IntType.getInstance());
                return TypeChecker.unify(found, expected, n);
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                TLAType intType = TypeChecker.unify(IntType.getInstance(), expected, n);
                this.visitExprOrOpArgNode(n.getArgs()[0], new SetType(intType));
                return intType;
            }
            case 32: {
                SetType argType = (SetType)this.visitExprOrOpArgNode(n.getArgs()[0], new SetType(new UntypedType()));
                SetType found = new SetType(new FunctionType(IntType.getInstance(), argType.getSubType()));
                return TypeChecker.unify(found, expected, n);
            }
            case 33: {
                SetType set = new SetType(new UntypedType());
                set = (SetType)this.visitExprOrOpArgNode(n.getArgs()[0], set);
                SetType found = new SetType(set);
                return TypeChecker.unify(found, expected, n);
            }
            case 34: {
                SetType set = new SetType(new TupleType(2));
                set = (SetType)this.visitExprOrOpArgNode(n.getArgs()[0], set);
                TupleType t = (TupleType)set.getSubType();
                List<TLAType> list = Arrays.asList(t.getTypes().get(1), t.getTypes().get(0));
                SetType found = new SetType(new TupleType(list));
                return TypeChecker.unify(found, expected, n);
            }
            case 14: {
                return TypeChecker.unify(new SetType(BoolType.getInstance()), expected, n);
            }
            case 18: {
                return TypeChecker.unify(new SetType(StringType.getInstance()), expected, n);
            }
            case 15: 
            case 16: 
            case 35: {
                return TypeChecker.unify(BoolType.getInstance(), expected, n);
            }
        }
        throw new NotImplementedException(n.getOperator().getName().toString());
    }

    private static boolean hasGlobalTyping(SemanticNode node) {
        SymbolNode symbol = null;
        if (node instanceof SymbolNode) {
            symbol = (SymbolNode)node;
        } else if (node instanceof OpApplNode) {
            symbol = ((OpApplNode)node).getOperator();
        }
        return symbol != null && (symbol.getKind() == 2 || symbol.getKind() == 3);
    }

    private void setLocalTypeAndFollowers(SemanticNode node, TLAType type) {
        this.setLocalType(node, type);
        if (type instanceof AbstractHasFollowers) {
            ((AbstractHasFollowers)type).addFollower(node);
        }
    }

    public static void updateTypeAndFollowers(SemanticNode node, TLAType oldType, TLAType newType) {
        if (TypeChecker.getType(node, 5) == oldType) {
            TypeChecker.setType(node, newType, 5);
            if (newType instanceof AbstractHasFollowers) {
                ((AbstractHasFollowers)newType).addFollower(node);
            }
        }
        if (TypeChecker.getType(node, 6) == oldType) {
            TypeChecker.setType(node, newType, 6);
            if (newType instanceof AbstractHasFollowers) {
                ((AbstractHasFollowers)newType).addFollower(node);
            }
        }
    }

    private static void setType(SemanticNode node, TLAType type, int paramId) {
        node.setToolObject(paramId, type);
    }

    private void setLocalType(SemanticNode node, TLAType type) {
        if (type instanceof IDefaultableType) {
            this.possibleUnfinishedTypes.put(new WeakReference<IDefaultableType>((IDefaultableType)((Object)type)), null);
        }
        if (this.paramId != 5 && TypeChecker.hasGlobalTyping(node)) {
            TypeChecker.setType(node, type, 5);
        } else {
            TypeChecker.setType(node, type, this.paramId);
        }
    }

    public static void setType(SemanticNode node, TLAType type) {
        TypeChecker.setType(node, type, 5);
    }

    private static TLAType getType(SemanticNode node, int paramId) {
        return (TLAType)node.getToolObject(paramId);
    }

    private TLAType getLocalType(SemanticNode node) {
        if (this.paramId != 5 && TypeChecker.hasGlobalTyping(node)) {
            return TypeChecker.getType(node, 5);
        }
        return TypeChecker.getType(node, this.paramId);
    }

    public static TLAType getType(SemanticNode node) {
        return TypeChecker.getType(node, 5);
    }

    private static TLAType unify(TLAType toUnify, TLAType expected, String opMsg, SemanticNode n) throws TypeErrorException {
        TLAType found = toUnify;
        DebugUtils.printDebugMsg("Unify " + found + " and " + expected + " at '" + opMsg + "' (" + n.getLocation() + ")");
        try {
            found = found.unify(expected);
        }
        catch (UnificationException e) {
            throw new TypeErrorException(String.format("Expected '%s', found '%s' at %s,%n%s", expected, found, "'" + opMsg + "'", n.getLocation()));
        }
        return found;
    }

    private static TLAType unify(TLAType toUnify, TLAType expected, OpApplNode n) throws TypeErrorException {
        return TypeChecker.unify(toUnify, expected, n.getOperator().getName().toString(), n);
    }

    private TLAType unifyAndSetLocalTypeWithFollowers(TLAType toUnify, TLAType expected, String opMsg, SemanticNode n) throws TypeErrorException {
        TLAType found = TypeChecker.unify(toUnify, expected, opMsg, n);
        this.setLocalTypeAndFollowers(n, found);
        return found;
    }

    private TLAType unifyAndSetLocalType(TLAType toUnify, TLAType expected, String opMsg, SemanticNode n) throws TypeErrorException {
        TLAType found = TypeChecker.unify(toUnify, expected, opMsg, n);
        this.setLocalType(n, found);
        return found;
    }
}

