/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.analysis;

import de.tla2b.global.BBuiltInOPs;
import de.tla2b.util.TlaUtils;
import java.util.Arrays;
import java.util.Map;
import tla2sany.semantic.ASTConstants;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.AtNode;
import tla2sany.semantic.Context;
import tla2sany.semantic.DecimalNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.NumeralNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.StringNode;
import tla2sany.semantic.Subst;
import tla2sany.semantic.SubstInNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.TreeNode;
import tlc2.tool.BuiltInOPs;
import util.UniqueString;

public class InstanceTransformation
extends BuiltInOPs
implements ASTConstants {
    private final Map<String, OpDefNode> defs;
    private final int substitutionId = 11;

    private InstanceTransformation(ModuleNode moduleNode) {
        this.defs = TlaUtils.getOpDefsMap(moduleNode.getOpDefs());
    }

    public static void run(ModuleNode moduleNode) {
        new InstanceTransformation(moduleNode).start();
    }

    private void start() {
        for (OpDefNode def : this.defs.values()) {
            if (def.getSource() == def || BBuiltInOPs.contains(def.getSource().getName()) || !(def.getBody() instanceof SubstInNode)) continue;
            String defName = def.getName().toString();
            String prefix = defName.substring(0, defName.lastIndexOf(33) + 1);
            def.setParams(this.copyParams(def.getParams()));
            def.setBody(this.copyExprNode(def.getBody(), prefix));
        }
    }

    private ExprNode copyExprNode(ExprNode n, String prefix) {
        switch (n.getKind()) {
            case 9: {
                return this.copyOpApplNode((OpApplNode)n, prefix);
            }
            case 16: {
                try {
                    return new NumeralNode(n.toString(), n.getTreeNode());
                }
                catch (AbortException e) {
                    throw new RuntimeException("Error while creating NumeralNode: " + e);
                }
            }
            case 17: {
                String[] image = n.toString().split("\\.");
                if (image.length != 2) {
                    throw new IllegalStateException("expected '.' in decimal number");
                }
                return new DecimalNode(image[0], image[1], n.getTreeNode());
            }
            case 18: {
                return new StringNode(n.getTreeNode(), false);
            }
            case 13: {
                SubstInNode substInNode = (SubstInNode)n;
                for (Subst sub : substInNode.getSubsts()) {
                    sub.getOp().setToolObject(11, sub.getExpr());
                }
                return this.copyExprNode(substInNode.getBody(), prefix);
            }
            case 19: {
                AtNode old = (AtNode)n;
                return new AtNode((OpApplNode)old.getExceptRef().getToolObject(11), (OpApplNode)old.getExceptComponentRef().getToolObject(11));
            }
            case 10: {
                LetInNode oldLetNode = (LetInNode)n;
                Context cc = oldLetNode.context;
                SymbolNode[] newLets = (OpDefNode[])Arrays.stream(oldLetNode.getLets()).map(let -> {
                    UniqueString newName = UniqueString.uniqueStringOf(prefix + let.getName().toString());
                    OpDefNode newLet = new OpDefNode(newName, let.getKind(), this.copyParams(let.getParams()), let.isLocal(), this.copyExprNode(let.getBody(), prefix), let.getOriginallyDefinedInModuleNode(), null, let.getTreeNode(), true, let.getSource());
                    let.setToolObject(11, newLet);
                    cc.addSymbolToContext(newName, newLet);
                    return newLet;
                }).toArray(OpDefNode[]::new);
                return new LetInNode(oldLetNode.getTreeNode(), newLets, null, this.copyExprNode(oldLetNode.getBody(), prefix), cc);
            }
        }
        throw new IllegalArgumentException("unknown ExprNode kind " + n.getKind());
    }

    private ExprNode copyOpApplNode(OpApplNode n, String prefix) {
        switch (n.getOperator().getKind()) {
            case 2: 
            case 3: {
                ExprOrOpArgNode e = (ExprOrOpArgNode)n.getOperator().getToolObject(11);
                if (e != null) {
                    if (e instanceof ExprNode) {
                        return this.copyExprNode((ExprNode)e, "");
                    }
                    OpArgNode opArg = (OpArgNode)e;
                    while (opArg.getOp().getToolObject(11) != null) {
                        opArg = (OpArgNode)opArg.getOp().getToolObject(11);
                    }
                    return InstanceTransformation.createOpApplNode(opArg.getOp(), this.copyArgs(n.getArgs(), prefix), n.getTreeNode());
                }
                return InstanceTransformation.createOpApplNode(n.getOperator(), this.copyArgs(n.getArgs(), prefix), n.getTreeNode());
            }
            case 11: {
                FormalParamNode f = (FormalParamNode)n.getOperator().getToolObject(11);
                if (f == null) {
                    throw new RuntimeException();
                }
                return InstanceTransformation.createOpApplNode(f, this.copyArgs(n.getArgs(), prefix), n.getTreeNode());
            }
            case 7: {
                return this.copyBuiltInNode(n, prefix);
            }
            case 5: {
                OpDefNode letOp = (OpDefNode)n.getOperator().getToolObject(11);
                if (letOp != null) {
                    return InstanceTransformation.createOpApplNode(letOp, this.copyArgs(n.getArgs(), prefix), n.getTreeNode());
                }
                if (BBuiltInOPs.contains(n.getOperator().getName())) {
                    return InstanceTransformation.createOpApplNode(n.getOperator(), this.copyArgs(n.getArgs(), prefix), n.stn);
                }
                String opName = prefix + n.getOperator().getName().toString();
                OpDefNode op = this.defs.get(opName);
                if (op == null) {
                    throw new RuntimeException("user-defined operator " + opName + " not found");
                }
                return InstanceTransformation.createOpApplNode(op, this.copyArgs(n.getArgs(), prefix), n.getTreeNode());
            }
        }
        throw new RuntimeException("OpApplkind not implemented yet");
    }

    private ExprNode copyBuiltInNode(OpApplNode n, String prefix) {
        switch (InstanceTransformation.getOpCode(n.getOperator().getName())) {
            case 8: {
                OpApplNode newNode = new OpApplNode(n.getOperator().getName(), null, n.getTreeNode(), null);
                n.setToolObject(11, newNode);
                ExprOrOpArgNode[] newArgs = new ExprOrOpArgNode[n.getArgs().length];
                newArgs[0] = this.copyExprOrOpArgNode(n.getArgs()[0], prefix);
                for (int i = 1; i < n.getArgs().length; ++i) {
                    OpApplNode pair2 = (OpApplNode)n.getArgs()[i];
                    OpApplNode newPair = new OpApplNode(pair2.getOperator().getName(), null, pair2.getTreeNode(), null);
                    pair2.setToolObject(11, newPair);
                    newPair.setArgs(this.copyArgs(pair2.getArgs(), prefix));
                    newArgs[i] = newPair;
                }
                newNode.setArgs(newArgs);
                return newNode;
            }
            case 24: {
                return new OpApplNode(n.getOperator().getName(), this.copyParams(n.getUnbdedQuantSymbols()), this.copyArgs(n.getArgs(), prefix), null, null, null, n.getTreeNode(), null);
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 22: {
                FormalParamNode[][] newParams = (FormalParamNode[][])Arrays.stream(n.getBdedQuantSymbolLists()).map(this::copyParams).toArray(x$0 -> new FormalParamNode[x$0][]);
                ExprNode[] ranges = (ExprNode[])Arrays.stream(n.getBdedQuantBounds()).map(b -> this.copyExprNode((ExprNode)b, prefix)).toArray(ExprNode[]::new);
                return new OpApplNode(n.getOperator().getName(), null, this.copyArgs(n.getArgs(), prefix), newParams, n.isBdedQuantATuple(), ranges, n.getTreeNode(), null);
            }
        }
        return InstanceTransformation.createOpApplNode(n.getOperator(), this.copyArgs(n.getArgs(), prefix), n.getTreeNode());
    }

    private ExprOrOpArgNode copyExprOrOpArgNode(ExprOrOpArgNode n, String prefix) {
        if (n instanceof ExprNode) {
            return this.copyExprNode((ExprNode)n, prefix);
        }
        throw new RuntimeException("OpArgNode not implemented yet");
    }

    private ExprOrOpArgNode[] copyArgs(ExprOrOpArgNode[] args, String prefix) {
        return (ExprOrOpArgNode[])Arrays.stream(args).map(arg -> this.copyExprOrOpArgNode((ExprOrOpArgNode)arg, prefix)).toArray(ExprOrOpArgNode[]::new);
    }

    private FormalParamNode[] copyParams(FormalParamNode[] oldParams) {
        return (FormalParamNode[])Arrays.stream(oldParams).map(oldParam -> {
            FormalParamNode newParam = new FormalParamNode(oldParam.getName(), oldParam.getArity(), oldParam.getTreeNode(), null, null);
            oldParam.setToolObject(11, newParam);
            return newParam;
        }).toArray(FormalParamNode[]::new);
    }

    private static OpApplNode createOpApplNode(SymbolNode operator, ExprOrOpArgNode[] args, TreeNode treeNode) {
        try {
            return new OpApplNode(operator, args, treeNode, null);
        }
        catch (AbortException e) {
            throw new RuntimeException("Error while creating OpApplNode: " + e);
        }
    }
}

