/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.analysis;

import de.be4.classicalb.core.parser.node.AAnySubstitution;
import de.be4.classicalb.core.parser.node.AAssignSubstitution;
import de.be4.classicalb.core.parser.node.ABlockSubstitution;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AMemberPredicate;
import de.be4.classicalb.core.parser.node.AOperation;
import de.be4.classicalb.core.parser.node.ASelectSubstitution;
import de.be4.classicalb.core.parser.node.ASkipSubstitution;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.PSubstitution;
import de.be4.classicalb.core.parser.util.ASTBuilder;
import de.tla2b.analysis.PrimedVariablesFinder;
import de.tla2b.analysis.SpecAnalyser;
import de.tla2b.analysis.TypeChecker;
import de.tla2b.global.BBuiltInOPs;
import de.tla2bAst.BAstCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SubstInNode;
import tla2sany.semantic.SymbolNode;
import tlc2.tool.BuiltInOPs;

public class BOperation
extends BuiltInOPs {
    private final String name;
    private final OpApplNode node;
    private final List<OpApplNode> existQuans;
    private final List<FormalParamNode> formalParams = new ArrayList<FormalParamNode>();
    private final List<OpDeclNode> unchangedVariables = new ArrayList<OpDeclNode>();
    private final List<ExprOrOpArgNode> guards = new ArrayList<ExprOrOpArgNode>();
    private final List<ExprOrOpArgNode> beforeAfterPredicates = new ArrayList<ExprOrOpArgNode>();
    private final Map<OpDeclNode, ExprOrOpArgNode> assignments = new LinkedHashMap<OpDeclNode, ExprOrOpArgNode>();
    private final List<OpDeclNode> anyVariables = new ArrayList<OpDeclNode>();

    public BOperation(String name, OpApplNode n, List<OpApplNode> existQuans, SpecAnalyser specAnalyser) {
        this.name = name;
        this.node = n;
        this.existQuans = existQuans;
        OpDeclNode[] variableDecls = specAnalyser.getModuleNode().getVariableDecls();
        this.anyVariables.addAll(Arrays.asList(variableDecls));
        for (OpApplNode ex : existQuans) {
            for (FormalParamNode[] param : ex.getBdedQuantSymbolLists()) {
                this.formalParams.addAll(Arrays.asList(param));
            }
        }
        this.findUnchangedVariablesInSemanticNode(this.node);
        this.separateGuardsAndBeforeAfterPredicates(this.node);
        this.findAssignments(variableDecls);
    }

    public AOperation getBOperation(BAstCreator bASTCreator) {
        PSubstitution operationBody;
        bASTCreator.setUnchangedVariablesNames(this.getUnchangedVariables());
        ArrayList<PPredicate> whereList = new ArrayList<PPredicate>();
        for (OpApplNode o : this.getExistQuans()) {
            whereList.add(bASTCreator.visitBoundsOfLocalVariables(o));
        }
        for (ExprOrOpArgNode g : this.guards) {
            whereList.add(bASTCreator.visitExprOrOpArgNodePredicate(g));
        }
        ArrayList<PExpression> lhsAssignment = new ArrayList<PExpression>();
        ArrayList<PExpression> rhsAssignment = new ArrayList<PExpression>();
        this.assignments.forEach((id, assignExpr) -> {
            lhsAssignment.add(bASTCreator.createIdentifierFromNode((SymbolNode)id));
            rhsAssignment.add(bASTCreator.visitExprOrOpArgNodeExpression((ExprOrOpArgNode)assignExpr));
        });
        AAssignSubstitution assign = new AAssignSubstitution();
        if (!this.anyVariables.isEmpty()) {
            ArrayList<PExpression> anyParams = new ArrayList<PExpression>();
            for (OpDeclNode var : this.anyVariables) {
                AIdentifierExpression nextName = ASTBuilder.createIdentifier(var.getName().toString() + "_n");
                anyParams.add(nextName);
                whereList.add(new AMemberPredicate(nextName.clone(), TypeChecker.getType(var).getBNode()));
                lhsAssignment.add(bASTCreator.createIdentifierFromNode(var));
                rhsAssignment.add(nextName.clone());
            }
            whereList.addAll(this.createBeforeAfterPredicates(bASTCreator));
            operationBody = new AAnySubstitution(anyParams, ASTBuilder.createConjunction(whereList), assign);
        } else if (!whereList.isEmpty()) {
            whereList.addAll(this.createBeforeAfterPredicates(bASTCreator));
            for (ExprOrOpArgNode e : this.beforeAfterPredicates) {
                whereList.add(bASTCreator.visitExprOrOpArgNodePredicate(e));
            }
            operationBody = new ASelectSubstitution(ASTBuilder.createConjunction(whereList), assign, new ArrayList<PSubstitution>(), null);
        } else {
            operationBody = new ABlockSubstitution(assign);
        }
        if (!lhsAssignment.isEmpty()) {
            assign.setLhsExpression(lhsAssignment);
            assign.setRhsExpressions(rhsAssignment);
        } else {
            assign.replaceBy(new ASkipSubstitution());
        }
        return new AOperation(new LinkedList<PExpression>(), bASTCreator.createPositionedTIdentifierLiteral(this.name, this.getNode()), this.getFormalParams().stream().map(bASTCreator::createIdentifierFromNode).collect(Collectors.toList()), operationBody);
    }

    private List<PPredicate> createBeforeAfterPredicates(BAstCreator bAstCreator) {
        ArrayList<PPredicate> predicates = new ArrayList<PPredicate>();
        for (ExprOrOpArgNode e : this.beforeAfterPredicates) {
            OpApplNode opApplNode;
            PPredicate body = null;
            if (e instanceof OpApplNode && (opApplNode = (OpApplNode)e).getOperator().getKind() == 5 && !BBuiltInOPs.contains(opApplNode.getOperator().getName())) {
                OpDefNode def = (OpDefNode)opApplNode.getOperator();
                FormalParamNode[] params = def.getParams();
                for (int j = 0; j < params.length; ++j) {
                    params[j].setToolObject(29, opApplNode.getArgs()[j]);
                }
                body = bAstCreator.visitExprNodePredicate(def.getBody());
            }
            if (body == null) {
                body = bAstCreator.visitExprOrOpArgNodePredicate(e);
            }
            predicates.add(body);
        }
        return predicates;
    }

    private void findAssignments(OpDeclNode[] variableDecls) {
        PrimedVariablesFinder primedVariablesFinder = new PrimedVariablesFinder(this.beforeAfterPredicates);
        for (ExprOrOpArgNode node : new ArrayList<ExprOrOpArgNode>(this.beforeAfterPredicates)) {
            OpApplNode opApplNode;
            if (!(node instanceof OpApplNode) || (opApplNode = (OpApplNode)node).getOperator().getKind() != 7 || BOperation.getOpCode(opApplNode.getOperator().getName()) != 35) continue;
            ExprOrOpArgNode arg1 = opApplNode.getArgs()[0];
            try {
                OpApplNode primeAppl = (OpApplNode)arg1;
                if (BOperation.getOpCode(primeAppl.getOperator().getName()) != 48) continue;
                OpDeclNode var = (OpDeclNode)((OpApplNode)primeAppl.getArgs()[0]).getOperator();
                if (primedVariablesFinder.getTwiceUsedVariables().contains(var)) continue;
                this.assignments.put(var, opApplNode.getArgs()[1]);
                this.beforeAfterPredicates.remove(node);
            }
            catch (ClassCastException classCastException) {}
        }
        this.anyVariables.clear();
        Collections.addAll(this.anyVariables, variableDecls);
        this.anyVariables.removeAll(this.assignments.keySet());
        this.anyVariables.removeAll(this.unchangedVariables);
    }

    private void separateGuardsAndBeforeAfterPredicates(ExprOrOpArgNode node) {
        OpApplNode opApplNode;
        if (node instanceof OpApplNode && (opApplNode = (OpApplNode)node).getOperator().getKind() == 7) {
            switch (BOperation.getOpCode(opApplNode.getOperator().getName())) {
                case 6: 
                case 36: {
                    Arrays.stream(opApplNode.getArgs()).forEach(this::separateGuardsAndBeforeAfterPredicates);
                    return;
                }
            }
            (opApplNode.level < 2 ? this.guards : this.beforeAfterPredicates).add(node);
            return;
        }
        (node.level < 2 ? this.guards : this.beforeAfterPredicates).add(node);
    }

    private void findUnchangedVariablesInSemanticNode(SemanticNode node) {
        switch (node.getKind()) {
            case 9: {
                this.findUnchangedVariablesInOpApplNode((OpApplNode)node);
                return;
            }
            case 10: {
                this.findUnchangedVariablesInSemanticNode(((LetInNode)node).getBody());
                return;
            }
            case 13: {
                this.findUnchangedVariablesInSemanticNode(((SubstInNode)node).getBody());
            }
        }
    }

    private void findUnchangedVariablesInOpApplNode(OpApplNode n) {
        int kind = n.getOperator().getKind();
        if (kind == 5 && !BBuiltInOPs.contains(n.getOperator().getName())) {
            this.findUnchangedVariablesInSemanticNode(((OpDefNode)n.getOperator()).getBody());
        } else if (kind == 7) {
            switch (BuiltInOPs.getOpCode(n.getOperator().getName())) {
                case 6: 
                case 36: {
                    Arrays.stream(n.getArgs()).forEach(this::findUnchangedVariablesInSemanticNode);
                    return;
                }
                case 49: {
                    OpApplNode k = (OpApplNode)n.getArgs()[0];
                    if (k.getOperator().getKind() == 3) {
                        this.unchangedVariables.add((OpDeclNode)k.getOperator());
                        break;
                    }
                    for (int i = 0; i < k.getArgs().length; ++i) {
                        OpApplNode var = (OpApplNode)k.getArgs()[i];
                        if (var.getOperator() instanceof OpDefNode) {
                            OpDefNode def = (OpDefNode)var.getOperator();
                            if (def.getParams().length > 0) {
                                throw new RuntimeException("Declaration with parameters not supported for UNCHANGED: " + var.getOperator().getName() + " " + var.getLocation());
                            }
                            ExprNode body = def.getBody();
                            if (!(body instanceof OpApplNode)) continue;
                            OpApplNode obody = (OpApplNode)body;
                            this.findUnchangedVariablesInOpApplNode(obody);
                            continue;
                        }
                        if (!(var.getOperator() instanceof OpDeclNode)) {
                            throw new RuntimeException("Cannot convert to list of UNCHANGED variables: " + var.getOperator().getName() + " " + var.getLocation());
                        }
                        this.unchangedVariables.add((OpDeclNode)var.getOperator());
                    }
                    break;
                }
            }
        }
    }

    public SymbolNode getSymbolNode() {
        if (this.node != null && this.node.getOperator().getKind() == 5) {
            return this.node.getOperator();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public ExprNode getNode() {
        return this.node;
    }

    public List<OpApplNode> getExistQuans() {
        return new ArrayList<OpApplNode>(this.existQuans);
    }

    public List<String> getOpParams() {
        return this.formalParams.stream().map(f -> f.getName().toString()).collect(Collectors.toList());
    }

    public List<FormalParamNode> getFormalParams() {
        return this.formalParams;
    }

    public List<String> getUnchangedVariables() {
        return this.unchangedVariables.stream().map(u -> u.getName().toString()).collect(Collectors.toList());
    }
}

