/*
 * Decompiled with CFR 0.152.
 */
package de.prob.prolog.term;

import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.output.PrologTermStringOutput;
import java.util.ArrayList;
import java.util.List;

public abstract class PrologTerm {
    public static List<String> atomsToStrings(Iterable<? extends PrologTerm> terms) {
        ArrayList<String> result = new ArrayList<String>();
        for (PrologTerm prologTerm : terms) {
            result.add(prologTerm.atomToString());
        }
        return result;
    }

    public static List<String> atomicsToStrings(Iterable<? extends PrologTerm> terms) {
        ArrayList<String> result = new ArrayList<String>();
        for (PrologTerm prologTerm : terms) {
            result.add(prologTerm.atomicToString());
        }
        return result;
    }

    @Deprecated
    public static String atomicString(PrologTerm term) {
        return term.atomToString();
    }

    @Deprecated
    public static List<String> atomicStrings(Iterable<PrologTerm> terms) {
        return PrologTerm.atomsToStrings(terms);
    }

    @Deprecated
    public boolean isTerm() {
        return false;
    }

    public boolean isCompound() {
        return false;
    }

    public boolean isAtom() {
        return false;
    }

    public boolean isList() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isVariable() {
        return false;
    }

    public boolean isAtomic() {
        return !this.isVariable() && !this.isCompound();
    }

    public boolean hasFunctor(String functor) {
        return false;
    }

    public boolean hasFunctor(String functor, int arity) {
        return this.hasFunctor(functor) && this.getArity() == arity;
    }

    public abstract void toTermOutput(IPrologTermOutput var1);

    public String toString() {
        PrologTermStringOutput pto = new PrologTermStringOutput();
        this.toTermOutput(pto);
        return pto.toString();
    }

    public abstract String getFunctor();

    public int getArity() {
        return 0;
    }

    public PrologTerm getArgument(int index) {
        throw new IndexOutOfBoundsException("Atom has no arguments");
    }

    public String atomToString() {
        if (this.isAtom()) {
            return this.getFunctor();
        }
        throw new IllegalArgumentException("Expected a Prolog atom, but was " + this + " (" + this.getClass() + ")");
    }

    public String atomicToString() {
        if (this.isAtomic()) {
            return this.getFunctor();
        }
        throw new IllegalArgumentException("Expected an atomic Prolog term, but was " + this + " (" + this.getClass() + ")");
    }
}

