/*
 * Decompiled with CFR 0.152.
 */
package de.prob.prolog.match;

import de.prob.prolog.match.PrologMatch;
import de.prob.prolog.term.AIntegerPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.math.BigInteger;
import java.util.Map;

public final class PrologIntegerMatch
extends PrologMatch {
    private final BigInteger number;

    private PrologIntegerMatch(String name, BigInteger number) {
        super(name);
        this.number = number;
    }

    public static PrologIntegerMatch anonInt() {
        return PrologIntegerMatch.namedInt(null, null);
    }

    public static PrologIntegerMatch anonInt(long number) {
        return PrologIntegerMatch.namedInt(null, BigInteger.valueOf(number));
    }

    public static PrologIntegerMatch anonInt(BigInteger number) {
        return PrologIntegerMatch.namedInt(null, number);
    }

    public static PrologIntegerMatch namedInt(String name) {
        return PrologIntegerMatch.namedInt(name, null);
    }

    public static PrologIntegerMatch namedInt(String name, long number) {
        return PrologIntegerMatch.namedInt(name, BigInteger.valueOf(number));
    }

    public static PrologIntegerMatch namedInt(String name, BigInteger number) {
        return new PrologIntegerMatch(name, number);
    }

    @Override
    protected boolean isMatch(PrologTerm term, Map<String, PrologTerm> hits) {
        boolean match = term instanceof AIntegerPrologTerm;
        if (match && this.number != null) {
            match = this.number.equals(((AIntegerPrologTerm)term).getValue());
        }
        return match;
    }
}

