/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.preparser.parser;

import de.be4.classicalb.core.preparser.lexer.Lexer;
import de.be4.classicalb.core.preparser.lexer.LexerException;
import de.be4.classicalb.core.preparser.node.AFilePreParserDefinition;
import de.be4.classicalb.core.preparser.node.APreParseUnit;
import de.be4.classicalb.core.preparser.node.APreParserDefinition;
import de.be4.classicalb.core.preparser.node.EOF;
import de.be4.classicalb.core.preparser.node.PPreParseUnit;
import de.be4.classicalb.core.preparser.node.PPreParserDefinition;
import de.be4.classicalb.core.preparser.node.Start;
import de.be4.classicalb.core.preparser.node.Switchable;
import de.be4.classicalb.core.preparser.node.TPreParserIdentifier;
import de.be4.classicalb.core.preparser.node.TPreParserString;
import de.be4.classicalb.core.preparser.node.TRhsBody;
import de.be4.classicalb.core.preparser.node.Token;
import de.be4.classicalb.core.preparser.parser.ParserException;
import de.be4.classicalb.core.preparser.parser.State;
import de.be4.classicalb.core.preparser.parser.TokenIndex;
import de.hhu.stups.sablecc.patch.IParser;
import de.hhu.stups.sablecc.patch.PositionedNode;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Parser
implements IParser {
    private final Lexer lexer;
    private final ListIterator<State> stack = new LinkedList().listIterator();
    private final TokenIndex converter = new TokenIndex();
    private static final int SHIFT = 0;
    private static final int REDUCE = 1;
    private static final int ACCEPT = 2;
    private static final int ERROR = 3;
    private static final int[][][] actionTable;
    private static final int[][][] gotoTable;
    private static final String[] errorMessages;
    private static final int[] errors;

    public Parser(Lexer lexer) {
        this.lexer = lexer;
    }

    private static void computePositions(PositionedNode node, List<?> beginNodeList, List<?> endNodeList) {
        assert (!(node instanceof Token));
        assert (node.getStartPos() == null);
        assert (node.getEndPos() == null);
        PositionedNode beginNode = Parser.findBeginNode(beginNodeList);
        node.setStartPos(beginNode.getStartPos());
        PositionedNode endNode = Parser.findEndNode(endNodeList);
        node.setEndPos(endNode.getEndPos());
    }

    private static PositionedNode findBeginNode(List<?> list) {
        Object first = list.get(0);
        if (first instanceof List) {
            List list2 = (List)first;
            return (PositionedNode)list2.get(0);
        }
        return (PositionedNode)first;
    }

    private static PositionedNode findEndNode(List<?> list) {
        Object last = list.get(list.size() - 1);
        if (last instanceof List) {
            List list2 = (List)last;
            return (PositionedNode)list2.get(list2.size() - 1);
        }
        return (PositionedNode)last;
    }

    private void push(int numstate, List<?> listNode) {
        if (!this.stack.hasNext()) {
            this.stack.add(new State(numstate, listNode));
            return;
        }
        State s = this.stack.next();
        s.state = numstate;
        s.nodes = listNode;
    }

    private int goTo(int index) {
        int state = this.state();
        int[][] table = gotoTable[index];
        int low = 1;
        int high = table.length - 1;
        int value = table[0][1];
        while (low <= high) {
            int middle = low + high >>> 1;
            if (state < table[middle][0]) {
                high = middle - 1;
                continue;
            }
            if (state > table[middle][0]) {
                low = middle + 1;
                continue;
            }
            value = table[middle][1];
            break;
        }
        return value;
    }

    private int state() {
        State s = this.stack.previous();
        this.stack.next();
        return s.state;
    }

    private List<?> pop() {
        return this.stack.previous().nodes;
    }

    private int index(Switchable token) {
        this.converter.index = -1;
        token.apply(this.converter);
        return this.converter.index;
    }

    public Start parse() throws ParserException, LexerException, IOException {
        int destination;
        int action;
        Token lastToken;
        this.push(0, null);
        block21: while (true) {
            lastToken = this.lexer.peek();
            int index = this.index(lastToken);
            while (index == -1) {
                this.lexer.next();
                lastToken = this.lexer.peek();
                index = this.index(lastToken);
            }
            int state = this.state();
            int[][] table = actionTable[state];
            action = table[0][1];
            destination = table[0][2];
            int low = 1;
            int high = table.length - 1;
            while (low <= high) {
                int middle = low + high >>> 1;
                if (index < table[middle][0]) {
                    high = middle - 1;
                    continue;
                }
                if (index > table[middle][0]) {
                    low = middle + 1;
                    continue;
                }
                action = table[middle][1];
                destination = table[middle][2];
                break;
            }
            switch (action) {
                case 0: {
                    this.push(destination, Collections.singletonList(this.lexer.next()));
                    continue block21;
                }
                case 1: {
                    switch (destination) {
                        case 0: {
                            List<?> list = this.new0();
                            this.push(this.goTo(0), list);
                            continue block21;
                        }
                        case 1: {
                            List<?> list = this.new1();
                            this.push(this.goTo(0), list);
                            continue block21;
                        }
                        case 2: {
                            List<?> list = this.new2();
                            this.push(this.goTo(0), list);
                            continue block21;
                        }
                        case 3: {
                            List<?> list = this.new3();
                            this.push(this.goTo(1), list);
                            continue block21;
                        }
                        case 4: {
                            List<?> list = this.new4();
                            this.push(this.goTo(1), list);
                            continue block21;
                        }
                        case 5: {
                            List<?> list = this.new5();
                            this.push(this.goTo(2), list);
                            continue block21;
                        }
                        case 6: {
                            List<?> list = this.new6();
                            this.push(this.goTo(2), list);
                            continue block21;
                        }
                        case 7: {
                            List<?> list = this.new7();
                            this.push(this.goTo(3), list);
                            continue block21;
                        }
                        case 8: {
                            List<?> list = this.new8();
                            this.push(this.goTo(3), list);
                            continue block21;
                        }
                        case 9: {
                            List<?> list = this.new9();
                            this.push(this.goTo(3), list);
                            continue block21;
                        }
                        case 10: {
                            List<?> list = this.new10();
                            this.push(this.goTo(4), list);
                            continue block21;
                        }
                        case 11: {
                            List<?> list = this.new11();
                            this.push(this.goTo(5), list);
                            continue block21;
                        }
                        case 12: {
                            List<?> list = this.new12();
                            this.push(this.goTo(5), list);
                            continue block21;
                        }
                    }
                    throw new ParserException(lastToken, "Internal parser error: invalid action table REDUCE destination " + destination + ", current state " + this.state());
                }
                case 2: {
                    EOF eof = (EOF)this.lexer.next();
                    PPreParseUnit top = (PPreParseUnit)this.pop().get(0);
                    return new Start(top, eof);
                }
                case 3: {
                    throw new ParserException(lastToken, errorMessages[errors[destination]]);
                }
            }
            break;
        }
        throw new ParserException(lastToken, "Internal parser error: invalid action table entry " + action + ", destination " + destination + ", current state " + this.state());
    }

    private List<?> new0() {
        List listNode2;
        List<?> popped1 = this.pop();
        List listNode3 = listNode2 = (List)popped1.get(0);
        APreParseUnit pPreParseUnitNode1 = new APreParseUnit(listNode3);
        Parser.computePositions(pPreParseUnitNode1, popped1, popped1);
        return Collections.singletonList(pPreParseUnitNode1);
    }

    private List<?> new1() {
        List<?> popped2 = this.pop();
        List<?> popped1 = this.pop();
        APreParseUnit pPreParseUnitNode1 = new APreParseUnit(Collections.emptyList());
        Parser.computePositions(pPreParseUnitNode1, popped1, popped2);
        return Collections.singletonList(pPreParseUnitNode1);
    }

    private List<?> new2() {
        APreParseUnit pPreParseUnitNode1 = new APreParseUnit(Collections.emptyList());
        return Collections.singletonList(pPreParseUnitNode1);
    }

    private List<?> new3() {
        List listNode1;
        List<?> popped2 = this.pop();
        List<?> popped1 = this.pop();
        List listNode2 = listNode1 = (List)popped2.get(0);
        return Collections.singletonList(listNode2);
    }

    private List<?> new4() {
        List listNode1;
        List<?> popped3 = this.pop();
        List<?> popped2 = this.pop();
        List<?> popped1 = this.pop();
        List listNode2 = listNode1 = (List)popped2.get(0);
        return Collections.singletonList(listNode2);
    }

    private List<?> new5() {
        List<?> popped1 = this.pop();
        PPreParserDefinition pPreParserDefinitionNode1 = (PPreParserDefinition)popped1.get(0);
        List<Object> listNode2 = pPreParserDefinitionNode1 != null ? Collections.singletonList(pPreParserDefinitionNode1) : Collections.emptyList();
        return Collections.singletonList(listNode2);
    }

    private List<?> new6() {
        List<?> popped3 = this.pop();
        List<?> popped2 = this.pop();
        List<?> popped1 = this.pop();
        LinkedList<PPreParserDefinition> listNode1 = (LinkedList<PPreParserDefinition>)popped1.get(0);
        PPreParserDefinition pPreParserDefinitionNode2 = (PPreParserDefinition)popped3.get(0);
        LinkedList<PPreParserDefinition> listNode3 = listNode1 instanceof LinkedList ? listNode1 : new LinkedList<PPreParserDefinition>(listNode1);
        if (pPreParserDefinitionNode2 != null) {
            listNode3.add(pPreParserDefinitionNode2);
        }
        return Collections.singletonList(listNode3);
    }

    private List<?> new7() {
        List<?> popped3 = this.pop();
        List<?> popped2 = this.pop();
        List<?> popped1 = this.pop();
        TPreParserIdentifier tPreParserIdentifierNode2 = (TPreParserIdentifier)popped1.get(0);
        TRhsBody tRhsBodyNode4 = (TRhsBody)popped3.get(0);
        APreParserDefinition pPreParserDefinitionNode1 = new APreParserDefinition(tPreParserIdentifierNode2, Collections.emptyList(), tRhsBodyNode4);
        Parser.computePositions(pPreParserDefinitionNode1, popped1, popped3);
        return Collections.singletonList(pPreParserDefinitionNode1);
    }

    private List<?> new8() {
        List listNode3;
        List<?> popped4 = this.pop();
        List<?> popped3 = this.pop();
        List<?> popped2 = this.pop();
        List<?> popped1 = this.pop();
        TPreParserIdentifier tPreParserIdentifierNode2 = (TPreParserIdentifier)popped1.get(0);
        List listNode4 = listNode3 = (List)popped2.get(0);
        TRhsBody tRhsBodyNode5 = (TRhsBody)popped4.get(0);
        APreParserDefinition pPreParserDefinitionNode1 = new APreParserDefinition(tPreParserIdentifierNode2, listNode4, tRhsBodyNode5);
        Parser.computePositions(pPreParserDefinitionNode1, popped1, popped4);
        return Collections.singletonList(pPreParserDefinitionNode1);
    }

    private List<?> new9() {
        List<?> popped1 = this.pop();
        TPreParserString tPreParserStringNode2 = (TPreParserString)popped1.get(0);
        AFilePreParserDefinition pPreParserDefinitionNode1 = new AFilePreParserDefinition(tPreParserStringNode2);
        Parser.computePositions(pPreParserDefinitionNode1, popped1, popped1);
        return Collections.singletonList(pPreParserDefinitionNode1);
    }

    private List<?> new10() {
        List listNode1;
        List<?> popped3 = this.pop();
        List<?> popped2 = this.pop();
        List<?> popped1 = this.pop();
        List listNode2 = listNode1 = (List)popped2.get(0);
        return Collections.singletonList(listNode2);
    }

    private List<?> new11() {
        List<?> popped1 = this.pop();
        TPreParserIdentifier tPreParserIdentifierNode1 = (TPreParserIdentifier)popped1.get(0);
        List<Object> listNode2 = tPreParserIdentifierNode1 != null ? Collections.singletonList(tPreParserIdentifierNode1) : Collections.emptyList();
        return Collections.singletonList(listNode2);
    }

    private List<?> new12() {
        List<?> popped3 = this.pop();
        List<?> popped2 = this.pop();
        List<?> popped1 = this.pop();
        LinkedList<TPreParserIdentifier> listNode1 = (LinkedList<TPreParserIdentifier>)popped1.get(0);
        TPreParserIdentifier tPreParserIdentifierNode2 = (TPreParserIdentifier)popped3.get(0);
        LinkedList<TPreParserIdentifier> listNode3 = listNode1 instanceof LinkedList ? listNode1 : new LinkedList<TPreParserIdentifier>(listNode1);
        if (tPreParserIdentifierNode2 != null) {
            listNode3.add(tPreParserIdentifierNode2);
        }
        return Collections.singletonList(listNode3);
    }

    static {
        try {
            InputStream resStream = Parser.class.getResourceAsStream("parser.dat");
            if (resStream == null) {
                throw new RuntimeException("The file \"parser.dat\" is missing.");
            }
            DataInputStream s = new DataInputStream(new BufferedInputStream(resStream));
            int actionTableLength1 = s.readInt();
            actionTable = new int[actionTableLength1][][];
            for (int i = 0; i < actionTableLength1; ++i) {
                int actionTableLength2 = s.readInt();
                Parser.actionTable[i] = new int[actionTableLength2][3];
                for (int j = 0; j < actionTableLength2; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        Parser.actionTable[i][j][k] = s.readInt();
                    }
                }
            }
            int gotoTableLength1 = s.readInt();
            gotoTable = new int[gotoTableLength1][][];
            for (int i = 0; i < gotoTableLength1; ++i) {
                int gotoTableLength2 = s.readInt();
                Parser.gotoTable[i] = new int[gotoTableLength2][2];
                for (int j = 0; j < gotoTableLength2; ++j) {
                    for (int k = 0; k < 2; ++k) {
                        Parser.gotoTable[i][j][k] = s.readInt();
                    }
                }
            }
            int errorMessagesLength = s.readInt();
            errorMessages = new String[errorMessagesLength];
            for (int i = 0; i < errorMessagesLength; ++i) {
                int errorMessageLength = s.readInt();
                StringBuilder buffer = new StringBuilder();
                for (int j = 0; j < errorMessageLength; ++j) {
                    buffer.append(s.readChar());
                }
                Parser.errorMessages[i] = buffer.toString();
            }
            int errorsLength = s.readInt();
            errors = new int[errorsLength];
            for (int i = 0; i < errorsLength; ++i) {
                Parser.errors[i] = s.readInt();
            }
            s.close();
        }
        catch (IOException e) {
            throw new RuntimeException("The file \"parser.dat\" is either missing or corrupted.", e);
        }
    }
}

