/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.tlc;

import de.be4.classicalb.core.parser.node.Node;
import de.tlc4b.analysis.MachineContext;
import de.tlc4b.analysis.Renamer;
import de.tlc4b.analysis.Typechecker;
import de.tlc4b.btypes.BType;
import de.tlc4b.tla.ConfigFile;
import de.tlc4b.tla.TLAModule;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Set;

public class TLCOutputInfo {
    public final Hashtable<String, String> namesMapping = new Hashtable();
    final Hashtable<String, BType> typesTable = new Hashtable();
    final Set<String> constants;
    boolean constantSetup = false;
    private final boolean hasInit;

    public boolean hasInitialisation() {
        return this.hasInit;
    }

    public String getBName(String tlaName) {
        return this.namesMapping.get(tlaName);
    }

    public BType getBType(String tlaName) {
        return this.typesTable.get(tlaName);
    }

    public void setConstantSetup() {
        this.constantSetup = true;
    }

    public boolean isAConstant(String tlaName) {
        return this.constants.contains(this.getBName(tlaName));
    }

    public boolean hasConstants() {
        return !this.constants.isEmpty() || this.constantSetup;
    }

    public TLCOutputInfo(MachineContext machineContext, Renamer renamer, Typechecker typechecker, TLAModule tlaModule, ConfigFile configFile) {
        this.constants = machineContext.getConstants().keySet();
        boolean bl = this.hasInit = !tlaModule.getInitPredicates().isEmpty();
        if (machineContext.hasConstants()) {
            this.constantSetup = true;
        }
        LinkedHashMap<String, Node> identifiers = new LinkedHashMap<String, Node>();
        identifiers.putAll(machineContext.getConstants());
        identifiers.putAll(machineContext.getVariables());
        identifiers.putAll(machineContext.getEnumValues());
        identifiers.forEach((name, node) -> {
            String newName = renamer.getNameOfRef((Node)node);
            this.namesMapping.put(newName, (String)name);
            this.typesTable.put(newName, typechecker.getType((Node)node));
        });
    }
}

