/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.btypes;

import de.be4.classicalb.core.parser.node.APartialFunctionExpression;
import de.be4.classicalb.core.parser.node.PExpression;
import de.tlc4b.analysis.Typechecker;
import de.tlc4b.btypes.AbstractHasFollowers;
import de.tlc4b.btypes.BType;
import de.tlc4b.btypes.ITypechecker;
import de.tlc4b.btypes.IntegerOrSetOfPairType;
import de.tlc4b.btypes.IntegerOrSetType;
import de.tlc4b.btypes.PairType;
import de.tlc4b.btypes.SetType;
import de.tlc4b.btypes.UntypedType;
import de.tlc4b.exceptions.UnificationException;

public class FunctionType
extends AbstractHasFollowers {
    private BType domain;
    private BType range;

    public FunctionType(BType domain, BType range) {
        this.setDomain(domain);
        this.setRange(range);
    }

    public BType getDomain() {
        return this.domain;
    }

    public void setDomain(BType domain) {
        this.domain = domain;
        if (domain instanceof AbstractHasFollowers) {
            ((AbstractHasFollowers)domain).addFollower(this);
        }
    }

    public BType getRange() {
        return this.range;
    }

    public void setRange(BType range) {
        this.range = range;
        if (range instanceof AbstractHasFollowers) {
            ((AbstractHasFollowers)range).addFollower(this);
        }
    }

    @Override
    public BType unify(BType other, ITypechecker typechecker) {
        if (!this.compare(other)) {
            throw new UnificationException();
        }
        if (other instanceof UntypedType) {
            ((UntypedType)other).setFollowersTo(this, typechecker);
            return this;
        }
        if (other instanceof FunctionType) {
            ((FunctionType)other).setFollowersTo(this, typechecker);
            this.setDomain(this.domain.unify(((FunctionType)other).domain, typechecker));
            this.setRange(this.range.unify(((FunctionType)other).range, typechecker));
            return this;
        }
        if (other instanceof SetType || other instanceof IntegerOrSetType || other instanceof IntegerOrSetOfPairType) {
            if (this.domain instanceof AbstractHasFollowers) {
                ((AbstractHasFollowers)this.domain).deleteFollower(this);
            }
            if (this.range instanceof AbstractHasFollowers) {
                ((AbstractHasFollowers)this.range).deleteFollower(this);
            }
            SetType s = new SetType(new PairType(this.domain, this.range));
            this.setFollowersTo(s, typechecker);
            return s.unify(other, typechecker);
        }
        throw new RuntimeException();
    }

    @Override
    public boolean isUntyped() {
        return this.domain.isUntyped() || this.range.isUntyped();
    }

    public String toString() {
        return "FUNC(" + this.domain + "," + this.range + ")";
    }

    public void update(BType oldType, BType newType) {
        if (this.domain == oldType) {
            this.setDomain(newType);
        }
        if (this.range == oldType) {
            this.setRange(newType);
        }
    }

    @Override
    public boolean compare(BType other) {
        if (other instanceof UntypedType) {
            return true;
        }
        if (other instanceof FunctionType) {
            return this.domain.compare(((FunctionType)other).domain) && this.range.compare(((FunctionType)other).range);
        }
        if (other instanceof IntegerOrSetOfPairType || other instanceof IntegerOrSetType) {
            return true;
        }
        if (other instanceof SetType) {
            BType t = ((SetType)other).getSubtype();
            if (t instanceof PairType) {
                return ((PairType)t).getFirst().compare(this.domain) && ((PairType)t).getSecond().compare(this.range);
            }
            return t instanceof UntypedType;
        }
        return false;
    }

    @Override
    public boolean contains(BType other) {
        if (this.domain.equals(other) || this.range.equals(other)) {
            return true;
        }
        if (this.domain instanceof AbstractHasFollowers && ((AbstractHasFollowers)this.domain).contains(other)) {
            return true;
        }
        if (this.range instanceof AbstractHasFollowers) {
            return ((AbstractHasFollowers)this.range).contains(other);
        }
        return false;
    }

    @Override
    public boolean containsInfiniteType() {
        return this.domain.containsInfiniteType() || this.range.containsInfiniteType();
    }

    @Override
    public PExpression createASTNode(Typechecker typechecker) {
        APartialFunctionExpression node = new APartialFunctionExpression(this.domain.createASTNode(typechecker), this.range.createASTNode(typechecker));
        typechecker.setType(node, new SetType(this));
        return node;
    }
}

