/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis.transformation;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.AConjunctPredicate;
import de.be4.classicalb.core.parser.node.ACoupleExpression;
import de.be4.classicalb.core.parser.node.ADomainExpression;
import de.be4.classicalb.core.parser.node.AEqualPredicate;
import de.be4.classicalb.core.parser.node.AEventBComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AMemberPredicate;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.util.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;

public class SetComprehensionOptimizer
extends DepthFirstAdapter {
    public static void optimizeSetComprehensions(Start start) {
        SetComprehensionOptimizer optimizer = new SetComprehensionOptimizer();
        start.apply(optimizer);
    }

    @Override
    public void caseAComprehensionSetExpression(AComprehensionSetExpression node) {
        LinkedList<PExpression> identifiers = node.getIdentifiers();
        ArrayList<String> list = new ArrayList<String>();
        Hashtable<String, AIdentifierExpression> identifierTable = new Hashtable<String, AIdentifierExpression>();
        for (PExpression identifier : identifiers) {
            AIdentifierExpression id = (AIdentifierExpression)identifier;
            String name = Utils.getTIdentifierListAsString(id.getIdentifier());
            list.add(name);
            identifierTable.put(name, id);
        }
        Hashtable<String, PExpression> values = new Hashtable<String, PExpression>();
        ArrayList<AEqualPredicate> equalList = new ArrayList<AEqualPredicate>();
        this.analysePredicate(node.getPredicates(), list, values, equalList);
        ArrayList<ADomainExpression> parentDomainExprsList = this.collectParentDomainExpression(node.parent());
        if (!(values.isEmpty() && parentDomainExprsList.isEmpty() || values.size() >= list.size() || list.size() - values.size() > 2)) {
            new NodesRemover(node.getPredicates(), equalList, values);
            int max = Math.min(list.size() - 1, parentDomainExprsList.size());
            int exprCount = list.size() - max;
            ArrayList<PExpression> ids = new ArrayList<PExpression>();
            ArrayList<PExpression> ids2 = new ArrayList<PExpression>();
            ArrayList<PExpression> ids3 = new ArrayList<PExpression>();
            ArrayList<PExpression> exprs = new ArrayList<PExpression>();
            for (int i = 0; i < list.size(); ++i) {
                AIdentifierExpression clone;
                String name = list.get(i);
                if (i < exprCount) {
                    if (values.containsKey(name)) {
                        exprs.add(values.get(name));
                    } else {
                        clone = ((AIdentifierExpression)identifierTable.get(name)).clone();
                        exprs.add(clone);
                    }
                }
                if (values.containsKey(name)) continue;
                clone = ((AIdentifierExpression)identifierTable.get(name)).clone();
                ids.add(clone);
                AIdentifierExpression clone2 = ((AIdentifierExpression)identifierTable.get(name)).clone();
                ids2.add(clone2);
                AIdentifierExpression clone3 = ((AIdentifierExpression)identifierTable.get(name)).clone();
                ids3.add(clone3);
            }
            AEventBComprehensionSetExpression eventBcomprehension = new AEventBComprehensionSetExpression();
            ACoupleExpression couple = new ACoupleExpression();
            couple.setList(exprs);
            eventBcomprehension.setExpression(couple);
            AMemberPredicate member = new AMemberPredicate();
            AComprehensionSetExpression compre = new AComprehensionSetExpression();
            eventBcomprehension.setIdentifiers(ids);
            if (ids.size() == 1) {
                member.setLeft((PExpression)ids2.get(0));
            } else {
                ACoupleExpression couple2 = new ACoupleExpression(ids2);
                member.setLeft(couple2);
            }
            compre.setIdentifiers(ids3);
            compre.setPredicates(node.getPredicates());
            member.setRight(compre);
            eventBcomprehension.setPredicates(member);
            this.setSourcePosition(node, eventBcomprehension);
            if (!parentDomainExprsList.isEmpty()) {
                ADomainExpression aDomainExpression = parentDomainExprsList.get(max - 1);
                aDomainExpression.replaceBy(eventBcomprehension);
            } else {
                node.replaceBy(eventBcomprehension);
            }
            eventBcomprehension.apply(this);
        } else {
            node.getPredicates().apply(this);
        }
    }

    private ArrayList<ADomainExpression> collectParentDomainExpression(Node node) {
        if (node instanceof ADomainExpression) {
            ArrayList<ADomainExpression> domExprList = this.collectParentDomainExpression(node.parent());
            domExprList.add(0, (ADomainExpression)node);
            return domExprList;
        }
        return new ArrayList<ADomainExpression>();
    }

    private void setSourcePosition(AComprehensionSetExpression from, AEventBComprehensionSetExpression to) {
        to.setStartPos(from.getStartPos());
        to.setEndPos(from.getEndPos());
    }

    private void analysePredicate(PPredicate predicate, ArrayList<String> list, Hashtable<String, PExpression> values, ArrayList<AEqualPredicate> equalList) {
        if (predicate instanceof AConjunctPredicate) {
            AConjunctPredicate con = (AConjunctPredicate)predicate;
            this.analysePredicate(con.getLeft(), list, values, equalList);
            this.analysePredicate(con.getRight(), list, values, equalList);
        } else if (predicate instanceof AEqualPredicate) {
            AEqualPredicate equal = (AEqualPredicate)predicate;
            if (equal.getLeft() instanceof AIdentifierExpression) {
                AIdentifierExpression id = (AIdentifierExpression)equal.getLeft();
                String name = Utils.getTIdentifierListAsString(id.getIdentifier());
                HashSet<String> names = new HashSet<String>(values.keySet());
                names.add(name);
                if (list.contains(name) && !DependenciesDetector.expressionContainsIdentifier(equal.getRight(), names)) {
                    equalList.add(equal);
                    values.put(name, equal.getRight());
                }
            } else if (!equalList.contains(equal) && equal.getRight() instanceof AIdentifierExpression) {
                AIdentifierExpression id = (AIdentifierExpression)equal.getRight();
                String name = Utils.getTIdentifierListAsString(id.getIdentifier());
                HashSet<String> names = new HashSet<String>(values.keySet());
                names.add(name);
                if (list.contains(name) && !DependenciesDetector.expressionContainsIdentifier(equal.getLeft(), names)) {
                    equalList.add(equal);
                    values.put(name, equal.getLeft());
                }
            }
        }
    }

    static class NodesRemover
    extends DepthFirstAdapter {
        final ArrayList<AEqualPredicate> removeList;
        final Hashtable<String, PExpression> values;

        public NodesRemover(PPredicate predicate, ArrayList<AEqualPredicate> equalList, Hashtable<String, PExpression> values) {
            this.removeList = equalList;
            this.values = values;
            for (AEqualPredicate pred : this.removeList) {
                pred.replaceBy(null);
            }
            predicate.apply(this);
        }

        @Override
        public void caseAConjunctPredicate(AConjunctPredicate node) {
            if (node.getLeft() != null) {
                node.getLeft().apply(this);
            }
            if (node.getRight() != null) {
                node.getRight().apply(this);
            }
            this.outAConjunctPredicate(node);
        }

        @Override
        public void outAConjunctPredicate(AConjunctPredicate node) {
            if (node.parent() != null) {
                if (node.getLeft() == null && node.getRight() == null) {
                    node.replaceBy(null);
                } else if (node.getLeft() == null) {
                    PPredicate right = node.getRight();
                    node.replaceBy(right);
                } else if (node.getRight() == null) {
                    node.replaceBy(node.getLeft());
                }
            }
        }

        @Override
        public void caseAIdentifierExpression(AIdentifierExpression node) {
            String name = Utils.getTIdentifierListAsString(node.getIdentifier());
            PExpression value = this.values.get(name);
            if (value != null) {
                node.replaceBy(value.clone());
            }
        }
    }

    static class DependenciesDetector
    extends DepthFirstAdapter {
        private final Set<String> names;
        private boolean hasDependency = false;

        private DependenciesDetector(Set<String> names) {
            this.names = names;
        }

        @Override
        public void caseAIdentifierExpression(AIdentifierExpression node) {
            String name = Utils.getTIdentifierListAsString(node.getIdentifier());
            if (this.names.contains(name)) {
                this.hasDependency = true;
            }
        }

        static boolean expressionContainsIdentifier(PExpression node, Set<String> names) {
            DependenciesDetector dependenciesDetector = new DependenciesDetector(names);
            node.apply(dependenciesDetector);
            return dependenciesDetector.hasDependency;
        }
    }
}

