/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis.transformation;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.ADefinitionExpression;
import de.be4.classicalb.core.parser.node.ADefinitionPredicate;
import de.be4.classicalb.core.parser.node.ADefinitionSubstitution;
import de.be4.classicalb.core.parser.node.ADefinitionsMachineClause;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.APredicateDefinitionDefinition;
import de.be4.classicalb.core.parser.node.ASubstitutionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.PDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;

public class DefinitionsSorter
extends DepthFirstAdapter {
    final LinkedHashMap<String, HashSet<String>> dependencies = new LinkedHashMap();
    final LinkedHashMap<String, HashSet<String>> allDependencies = new LinkedHashMap();
    final LinkedHashMap<String, PDefinition> definitionsTable = new LinkedHashMap();
    final ArrayList<PDefinition> res = new ArrayList();
    String current = null;

    public DefinitionsSorter(ADefinitionsMachineClause clause) {
        clause.apply(this);
        for (String defName : this.dependencies.keySet()) {
            this.resolveDependencies(defName);
        }
        ArrayList<String> defs = new ArrayList<String>(this.allDependencies.keySet());
        while (!this.res.containsAll(this.definitionsTable.values())) {
            for (String next : new ArrayList<String>(defs)) {
                HashSet<String> deps = this.allDependencies.get(next);
                deps.retainAll(defs);
                if (!deps.isEmpty()) continue;
                PDefinition pDefinition = this.definitionsTable.get(next);
                pDefinition.replaceBy(null);
                this.res.add(pDefinition);
                defs.remove(next);
            }
        }
        clause.setDefinitions(this.res);
    }

    private void resolveDependencies(String defName) {
        if (this.allDependencies.containsKey(defName)) {
            return;
        }
        HashSet<String> allDeps = new HashSet<String>();
        HashSet<String> deps = this.dependencies.get(defName);
        for (String def : deps) {
            this.resolveDependencies(def);
            allDeps.add(def);
            allDeps.addAll((Collection)this.allDependencies.get(def));
        }
        this.allDependencies.put(defName, allDeps);
    }

    public static void sortDefinitions(ADefinitionsMachineClause clause) {
        new DefinitionsSorter(clause);
    }

    @Override
    public void inAPredicateDefinitionDefinition(APredicateDefinitionDefinition node) {
        String name = node.getName().getText();
        this.addDefinition(name);
        this.definitionsTable.put(name, node);
        this.current = name;
    }

    @Override
    public void inASubstitutionDefinitionDefinition(ASubstitutionDefinitionDefinition node) {
        String name = node.getName().getText();
        this.addDefinition(name);
        this.definitionsTable.put(name, node);
        this.current = name;
    }

    @Override
    public void inAExpressionDefinitionDefinition(AExpressionDefinitionDefinition node) {
        String name = node.getName().getText();
        this.addDefinition(name);
        this.definitionsTable.put(name, node);
        this.current = name;
    }

    @Override
    public void inADefinitionExpression(ADefinitionExpression node) {
        String name = node.getDefLiteral().getText();
        this.addDefinitionCall(name);
    }

    @Override
    public void inADefinitionPredicate(ADefinitionPredicate node) {
        String name = node.getDefLiteral().getText();
        this.addDefinitionCall(name);
    }

    @Override
    public void inADefinitionSubstitution(ADefinitionSubstitution node) {
        String name = node.getDefLiteral().getText();
        this.addDefinitionCall(name);
    }

    private void addDefinition(String name) {
        if (!this.dependencies.containsKey(name)) {
            this.dependencies.put(name, new HashSet());
        }
    }

    private void addDefinitionCall(String name) {
        this.dependencies.get(this.current).add(name);
    }
}

