/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AAnySubstitution;
import de.be4.classicalb.core.parser.node.AComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.ADefinitionsMachineClause;
import de.be4.classicalb.core.parser.node.AExistsPredicate;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AForallPredicate;
import de.be4.classicalb.core.parser.node.AGeneralProductExpression;
import de.be4.classicalb.core.parser.node.AGeneralSumExpression;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.ALambdaExpression;
import de.be4.classicalb.core.parser.node.ALetExpressionExpression;
import de.be4.classicalb.core.parser.node.ALetPredicatePredicate;
import de.be4.classicalb.core.parser.node.ALetSubstitution;
import de.be4.classicalb.core.parser.node.AOperation;
import de.be4.classicalb.core.parser.node.APredicateDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AQuantifiedIntersectionExpression;
import de.be4.classicalb.core.parser.node.AQuantifiedUnionExpression;
import de.be4.classicalb.core.parser.node.ASubstitutionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AVarSubstitution;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PDefinition;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.util.Utils;
import de.tlc4b.analysis.MachineContext;
import de.tlc4b.analysis.StandardModules;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Renamer
extends DepthFirstAdapter {
    private final MachineContext machineContext;
    private final Hashtable<Node, String> namesTable;
    private final HashSet<String> globalNames;
    private static final Set<String> KEYWORDS = new HashSet<String>();
    private static final Set<String> RelationsKeywords;
    private final ArrayList<HashSet<String>> localContexts = new ArrayList();

    public Renamer(MachineContext machineContext) {
        this.machineContext = machineContext;
        this.namesTable = new Hashtable();
        this.globalNames = new HashSet();
        this.start();
    }

    public void start() {
        this.evalGlobalNames(this.machineContext.getDeferredSets());
        this.evalGlobalNames(this.machineContext.getEnumeratedSets());
        this.evalEnumValues();
        this.evalGlobalNames(this.machineContext.getConstants());
        this.evalGlobalNames(this.machineContext.getVariables());
        this.evalGlobalNames(this.machineContext.getOperations());
        this.evalDefinitions();
        this.machineContext.getStartNode().apply(this);
    }

    private void evalEnumValues() {
        for (Map.Entry<String, Node> entry : this.machineContext.getEnumValues().entrySet()) {
            String name = entry.getKey();
            Node node = entry.getValue();
            if (name.indexOf(95) == 1) {
                name = name.replaceFirst("_", "1_");
            }
            String newName = this.incName(name);
            this.namesTable.put(node, newName);
            this.globalNames.add(newName);
        }
    }

    public void evalGlobalNames(LinkedHashMap<String, Node> map) {
        for (Map.Entry<String, Node> entry : map.entrySet()) {
            String name = entry.getKey();
            String newName = this.incName(name);
            this.namesTable.put(map.get(name), newName);
            this.globalNames.add(newName);
        }
    }

    private void evalDefinitions() {
        ADefinitionsMachineClause node = this.machineContext.getDefinitionMachineClause();
        if (null == node) {
            return;
        }
        ArrayList<PDefinition> copy = new ArrayList<PDefinition>(node.getDefinitions());
        for (PDefinition e : copy) {
            String name = null;
            if (e instanceof AExpressionDefinitionDefinition) {
                name = ((AExpressionDefinitionDefinition)e).getName().getText();
            } else if (e instanceof APredicateDefinitionDefinition) {
                name = ((APredicateDefinitionDefinition)e).getName().getText();
            } else if (e instanceof ASubstitutionDefinitionDefinition) {
                name = ((ASubstitutionDefinitionDefinition)e).getName().getText();
            }
            String newName = this.incName(name);
            this.namesTable.put(e, newName);
            this.globalNames.add(newName);
        }
        for (PDefinition e : copy) {
            e.apply(this);
        }
    }

    public String getNameOfRef(Node node) {
        Node refNode = this.machineContext.getReferences().get(node);
        if (refNode == null) {
            refNode = node;
        }
        return this.namesTable.get(refNode);
    }

    public String getName(Node node) {
        return this.namesTable.get(node);
    }

    private String incName(String name) {
        String res = name;
        int i = 1;
        while (this.exist(res)) {
            res = name + "_" + i;
            ++i;
        }
        return res;
    }

    private boolean exist(String name) {
        if (KEYWORDS.contains(name)) {
            return true;
        }
        if (this.globalNames.contains(name)) {
            return true;
        }
        if (StandardModules.isKeywordInModuleFunctions(name)) {
            return true;
        }
        if (StandardModules.isKeywordInModuleSequences(name)) {
            return true;
        }
        if (StandardModules.isKeywordInModuleSequencesExtended(name)) {
            return true;
        }
        for (HashSet<String> localContext : this.localContexts) {
            if (!localContext.contains(name)) continue;
            return true;
        }
        return false;
    }

    private String renameIdentifier(Node node) {
        AIdentifierExpression id = (AIdentifierExpression)node;
        String name = Utils.getTIdentifierListAsString(id.getIdentifier());
        String newName = this.incName(name);
        this.namesTable.put(id, newName);
        return newName;
    }

    private void evalDefinition(List<PExpression> params) {
        for (PExpression e : params) {
            this.renameIdentifier(e);
        }
    }

    @Override
    public void inAExpressionDefinitionDefinition(AExpressionDefinitionDefinition node) {
        this.evalDefinition(node.getParameters());
    }

    @Override
    public void inAPredicateDefinitionDefinition(APredicateDefinitionDefinition node) {
        this.evalDefinition(node.getParameters());
    }

    @Override
    public void inASubstitutionDefinitionDefinition(ASubstitutionDefinitionDefinition node) {
        this.evalDefinition(node.getParameters());
    }

    @Override
    public void caseAForallPredicate(AForallPredicate node) {
        this.evalBoundedVariables(node, node.getIdentifiers());
        node.getImplication().apply(this);
        this.removeLastContext();
    }

    @Override
    public void caseAExistsPredicate(AExistsPredicate node) {
        this.evalBoundedVariables(node, node.getIdentifiers());
        node.getPredicate().apply(this);
        this.removeLastContext();
    }

    @Override
    public void caseALambdaExpression(ALambdaExpression node) {
        this.evalBoundedVariables(node, node.getIdentifiers());
        node.getPredicate().apply(this);
        node.getExpression().apply(this);
        this.removeLastContext();
    }

    @Override
    public void caseAComprehensionSetExpression(AComprehensionSetExpression node) {
        this.evalBoundedVariables(node, node.getIdentifiers());
        node.getPredicates().apply(this);
        this.removeLastContext();
    }

    @Override
    public void caseAQuantifiedUnionExpression(AQuantifiedUnionExpression node) {
        this.evalBoundedVariables(node, node.getIdentifiers());
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            e.apply(this);
        }
        node.getPredicates().apply(this);
        node.getExpression().apply(this);
        this.removeLastContext();
    }

    @Override
    public void caseAQuantifiedIntersectionExpression(AQuantifiedIntersectionExpression node) {
        this.evalBoundedVariables(node, node.getIdentifiers());
        node.getPredicates().apply(this);
        node.getExpression().apply(this);
        this.removeLastContext();
    }

    @Override
    public void caseAGeneralSumExpression(AGeneralSumExpression node) {
        this.evalBoundedVariables(node, node.getIdentifiers());
        node.getPredicates().apply(this);
        node.getExpression().apply(this);
        this.removeLastContext();
    }

    @Override
    public void caseAGeneralProductExpression(AGeneralProductExpression node) {
        this.evalBoundedVariables(node, node.getIdentifiers());
        node.getPredicates().apply(this);
        node.getExpression().apply(this);
        this.removeLastContext();
    }

    @Override
    public void caseAOperation(AOperation node) {
        ArrayList<PExpression> list = new ArrayList<PExpression>();
        list.addAll(node.getParameters());
        list.addAll(node.getReturnValues());
        this.evalBoundedVariables(node, list);
        node.getOperationBody().apply(this);
        this.removeLastContext();
    }

    private void evalBoundedVariables(Node node, List<PExpression> params) {
        HashSet<String> context = new HashSet<String>();
        for (PExpression e : params) {
            String newName = this.renameIdentifier(e);
            context.add(newName);
        }
        this.localContexts.add(context);
    }

    @Override
    public void caseAAnySubstitution(AAnySubstitution node) {
        ArrayList<PExpression> list = new ArrayList<PExpression>(node.getIdentifiers());
        this.evalBoundedVariables(node, list);
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            e.apply(this);
        }
        node.getWhere().apply(this);
        node.getThen().apply(this);
        this.removeLastContext();
    }

    @Override
    public void caseALetSubstitution(ALetSubstitution node) {
        ArrayList<PExpression> list = new ArrayList<PExpression>(node.getIdentifiers());
        this.evalBoundedVariables(node, list);
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            e.apply(this);
        }
        node.getPredicate().apply(this);
        node.getSubstitution().apply(this);
        this.removeLastContext();
    }

    @Override
    public void caseALetExpressionExpression(ALetExpressionExpression node) {
        ArrayList<PExpression> list = new ArrayList<PExpression>(node.getIdentifiers());
        this.evalBoundedVariables(node, list);
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            e.apply(this);
        }
        node.getAssignment().apply(this);
        node.getExpr().apply(this);
        this.removeLastContext();
    }

    @Override
    public void caseALetPredicatePredicate(ALetPredicatePredicate node) {
        ArrayList<PExpression> list = new ArrayList<PExpression>(node.getIdentifiers());
        this.evalBoundedVariables(node, list);
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            e.apply(this);
        }
        node.getAssignment().apply(this);
        node.getPred().apply(this);
        this.removeLastContext();
    }

    @Override
    public void caseAVarSubstitution(AVarSubstitution node) {
        ArrayList<PExpression> list = new ArrayList<PExpression>(node.getIdentifiers());
        this.evalBoundedVariables(node, list);
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            e.apply(this);
        }
        node.getSubstitution().apply(this);
        this.removeLastContext();
    }

    public void removeLastContext() {
        this.localContexts.remove(this.localContexts.size() - 1);
    }

    static {
        KEYWORDS.add("ACTION");
        KEYWORDS.add("ASSUME");
        KEYWORDS.add("ASSUMPTION");
        KEYWORDS.add("AXIOM");
        KEYWORDS.add("CASE");
        KEYWORDS.add("CHOOSE");
        KEYWORDS.add("CONSTANT");
        KEYWORDS.add("CONSTANTS");
        KEYWORDS.add("DOMAIN");
        KEYWORDS.add("ELSE");
        KEYWORDS.add("ENABLED");
        KEYWORDS.add("EXCEPT");
        KEYWORDS.add("EXTENDS");
        KEYWORDS.add("IF");
        KEYWORDS.add("IN");
        KEYWORDS.add("INSTANCE");
        KEYWORDS.add("LET");
        KEYWORDS.add("LOCAL");
        KEYWORDS.add("MODULE");
        KEYWORDS.add("OTHER");
        KEYWORDS.add("SF_");
        KEYWORDS.add("SUBSET");
        KEYWORDS.add("THEN");
        KEYWORDS.add("THEOREM");
        KEYWORDS.add("UNCHANGED");
        KEYWORDS.add("UNION");
        KEYWORDS.add("VARIABLE");
        KEYWORDS.add("VARIABLES");
        KEYWORDS.add("WF_");
        KEYWORDS.add("WITH");
        KEYWORDS.add("STATE");
        KEYWORDS.add("DEF");
        KEYWORDS.add("Init");
        KEYWORDS.add("Next");
        KEYWORDS.add("INVARIANT");
        KEYWORDS.add("Nat");
        KEYWORDS.add("Int");
        KEYWORDS.add("Seq");
        RelationsKeywords = new HashSet<String>();
        RelationsKeywords.add("domain");
        RelationsKeywords.add("range");
        RelationsKeywords.add("id");
        RelationsKeywords.add("set_of_relations");
        RelationsKeywords.add("domain_restriction");
        RelationsKeywords.add("domain_subtraction");
        RelationsKeywords.add("rel_inverse");
        RelationsKeywords.add("relational_image");
        RelationsKeywords.add("relational_overriding");
        RelationsKeywords.add("direct");
        RelationsKeywords.add("Seq");
    }
}

