/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AAssignSubstitution;
import de.be4.classicalb.core.parser.node.ABecomesElementOfSubstitution;
import de.be4.classicalb.core.parser.node.ABecomesSuchSubstitution;
import de.be4.classicalb.core.parser.node.AFunctionExpression;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.APrimedIdentifierExpression;
import de.be4.classicalb.core.parser.node.ARecordFieldExpression;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.POperation;
import de.be4.classicalb.core.parser.util.Utils;
import de.tlc4b.analysis.MachineContext;
import de.tlc4b.exceptions.NotSupportedException;
import de.tlc4b.exceptions.ScopeException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class PrimedNodesMarker
extends DepthFirstAdapter {
    private final ArrayList<POperation> operations;
    private final MachineContext machineContext;
    private final HashSet<Node> primedNodes;
    private HashSet<Node> nodesToPrime;

    public PrimedNodesMarker(ArrayList<POperation> operations, MachineContext machineContext, Set<Node> primedNodes) {
        this.primedNodes = new HashSet<Node>(primedNodes);
        this.operations = operations;
        this.machineContext = machineContext;
    }

    public void start() {
        for (Node def : this.machineContext.getDefinitions().values()) {
            def.apply(this);
        }
        for (POperation pOperation : this.operations) {
            pOperation.apply(this);
        }
    }

    private void primeIfVariable(Node node) {
        Node ref = this.machineContext.getReferences().get(node);
        if (this.machineContext.getVariables().containsValue(ref)) {
            this.primedNodes.add(node);
        }
    }

    @Override
    public void caseAAssignSubstitution(AAssignSubstitution node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getLhsExpression());
        for (PExpression e : copy) {
            this.primeWrittenVariable(e);
        }
    }

    private void primeWrittenVariable(PExpression e) {
        if (e instanceof AIdentifierExpression) {
            this.primeIfVariable(e);
        } else if (e instanceof AFunctionExpression) {
            this.primeWrittenVariable(((AFunctionExpression)e).getIdentifier());
        } else if (e instanceof ARecordFieldExpression) {
            this.primeWrittenVariable(((ARecordFieldExpression)e).getRecord());
        } else {
            throw new NotSupportedException("Unsupported assignment lhs: " + e);
        }
    }

    @Override
    public void caseABecomesElementOfSubstitution(ABecomesElementOfSubstitution node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            Node ref = this.machineContext.getReferences().get(e);
            if (!this.machineContext.getVariables().containsValue(ref)) continue;
            this.primedNodes.add(e);
        }
    }

    @Override
    public void caseABecomesSuchSubstitution(ABecomesSuchSubstitution node) {
        this.nodesToPrime = new HashSet();
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            Node ref = this.machineContext.getReferences().get(e);
            this.nodesToPrime.add(ref);
            this.primedNodes.add(e);
        }
        node.getPredicate().apply(this);
        this.nodesToPrime = null;
    }

    @Override
    public void caseAIdentifierExpression(AIdentifierExpression node) {
        Node ref;
        if (this.nodesToPrime != null && this.nodesToPrime.contains(ref = this.machineContext.getReferences().get(node))) {
            this.primedNodes.add(node);
        }
    }

    @Override
    public void caseAPrimedIdentifierExpression(APrimedIdentifierExpression node) {
        Node ref;
        if (this.nodesToPrime != null && this.nodesToPrime.contains(ref = this.machineContext.getReferences().get(node))) {
            return;
        }
        String name = Utils.getTIdentifierListAsString(node.getIdentifier());
        throw new ScopeException("Unknown identifier: '" + name + "$0'");
    }

    public boolean isPrimed(Node node) {
        return this.primedNodes.contains(node);
    }
}

