/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b;

import de.tlc4b.MP;
import de.tlc4b.StreamGobbler;
import de.tlc4b.TLC4BGlobals;
import de.tlc4b.tlc.TLCMessageListener;
import de.tlc4b.util.StopWatch;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import tlc2.TLC;
import tlc2.TLCGlobals;
import tlc2.tool.fp.FPSetFactory;
import util.SimpleFilenameToStream;
import util.ToolIO;

public class TLCRunner {
    public static TLCMessageListener listener = null;

    public static void addTLCMessageListener(TLCMessageListener listener) {
        TLCRunner.listener = listener;
    }

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        System.out.println("Starting TLC...");
        String path = args[0];
        ToolIO.setUserDir(path);
        String[] parameters = new String[args.length - 1];
        System.arraycopy(args, 1, parameters, 0, parameters.length);
        try {
            TLC.main(parameters);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Process startJVM(String mainClass, List<String> arguments) throws IOException {
        boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ROOT).startsWith("windows");
        String jvm = System.getProperty("java.home") + File.separator + "bin" + File.separator + (isWindows ? "java.exe" : "java");
        String classpath = System.getProperty("java.class.path");
        ArrayList<String> command = new ArrayList<String>();
        command.add(jvm);
        command.addAll(Arrays.asList("-XX:+UseParallelGC", "-Dfile.encoding=UTF-8", "-Dtlc2.tool.fp.FPSet.impl=" + FPSetFactory.getImplementationDefault()));
        command.add(mainClass);
        command.addAll(arguments);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.environment().put("CLASSPATH", classpath);
        return processBuilder.start();
    }

    public static ArrayList<String> runTLCInANewJVM(String machineName, String path) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(path);
        list.add(machineName);
        if (!TLC4BGlobals.isDeadlockCheck()) {
            list.add("-deadlock");
        }
        if (TLC4BGlobals.isCheckLTL()) {
            list.add("-cleanup");
        }
        Process p = TLCRunner.startJVM(TLCRunner.class.getCanonicalName(), list);
        StreamGobbler stdOut = new StreamGobbler(p.getInputStream());
        stdOut.start();
        StreamGobbler errOut = new StreamGobbler(p.getErrorStream());
        errOut.start();
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return stdOut.getLog();
    }

    public static void runTLC(String machineName, File path) {
        StopWatch.start(StopWatch.Watches.MODEL_CHECKING_TIME);
        MP.printlnSilent("--------------------------------");
        MP.TLCOutputStream.changeOutputStream();
        ToolIO.setMode(0);
        ArrayList<String> list = new ArrayList<String>();
        if (!TLC4BGlobals.isDeadlockCheck()) {
            list.add("-deadlock");
        }
        if (TLC4BGlobals.getWorkers() > 1) {
            list.add("-workers");
            list.add("" + TLC4BGlobals.getWorkers());
        } else {
            TLCGlobals.setNumWorkers(1);
        }
        if (TLC4BGlobals.getDfidInitialDepth() >= 0) {
            list.add("-dfid");
            list.add("" + TLC4BGlobals.getDfidInitialDepth());
        } else {
            TLCGlobals.DFIDMax = -1;
        }
        if (TLC4BGlobals.isPrintCoverage()) {
            list.add("-nowarning");
            list.add("-coverage");
            list.add("60");
        }
        list.add("-maxSetSize");
        list.add("100000000");
        list.add(machineName);
        ToolIO.setUserDir(path.getPath());
        String[] args = list.toArray(new String[0]);
        TLC tlc = new TLC();
        if (tlc.handleParameters(args)) {
            tlc.setResolver(new SimpleFilenameToStream());
            try {
                if (listener != null) {
                    listener.start();
                }
                tlc.process();
                if (listener != null) {
                    listener.finish();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        TLCRunner.closeThreads();
        MP.TLCOutputStream.resetOutputStream();
        MP.println("--------------------------------");
        StopWatch.stop(StopWatch.Watches.MODEL_CHECKING_TIME);
    }

    private static void closeThreads() {
        Thread[] threadArray;
        HashSet<Thread> threadSet = new HashSet<Thread>(Thread.getAllStackTraces().keySet());
        for (Thread t : threadArray = threadSet.toArray(new Thread[0])) {
            if (!t.getName().equals("RMI Reaper")) continue;
            t.interrupt();
        }
    }
}

