/*
 * Decompiled with CFR 0.152.
 */
package de.prob.prolog.term;

import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.output.PrologTermOutput;
import de.prob.prolog.term.PrologTerm;
import java.util.Objects;

public final class VariablePrologTerm
extends PrologTerm {
    private final String name;

    public VariablePrologTerm(String name) {
        Objects.requireNonNull(name, "name");
        if (!PrologTermOutput.isValidPrologVariable(name)) {
            throw new IllegalArgumentException("name");
        }
        this.name = name;
    }

    @Override
    public String getFunctor() {
        return this.name;
    }

    @Override
    public boolean isVariable() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void toTermOutput(IPrologTermOutput pto) {
        pto.printVariable(this.name);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VariablePrologTerm)) {
            return false;
        }
        return this.name.equals(((VariablePrologTerm)other).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

