/*
 * Decompiled with CFR 0.152.
 */
package de.prob.parserbase;

import de.prob.parserbase.ProBParseException;
import de.prob.parserbase.ProBParserBase;
import de.prob.prolog.output.StructuredPrologOutput;
import de.prob.prolog.term.PrologTerm;
import java.util.List;

public class ProBParserBaseAdapter {
    private final ProBParserBase base;

    public ProBParserBaseAdapter(ProBParserBase base) {
        this.base = base;
    }

    public PrologTerm parseExpression(String expression, boolean wrap) throws ProBParseException {
        StructuredPrologOutput pto = new StructuredPrologOutput();
        this.base.parseExpression(pto, expression, wrap);
        return this.getSingleTerm(pto);
    }

    public PrologTerm parsePredicate(String predicate, boolean wrap) throws ProBParseException {
        StructuredPrologOutput pto = new StructuredPrologOutput();
        this.base.parsePredicate(pto, predicate, wrap);
        return this.getSingleTerm(pto);
    }

    public PrologTerm parseTransitionPredicate(String transPredicate, boolean wrap) throws ProBParseException {
        StructuredPrologOutput pto = new StructuredPrologOutput();
        this.base.parseTransitionPredicate(pto, transPredicate, wrap);
        return this.getSingleTerm(pto);
    }

    private PrologTerm getSingleTerm(StructuredPrologOutput pto) {
        pto.fullstop();
        List<PrologTerm> sentences = pto.getSentences();
        int size = sentences.size();
        if (size == 1) {
            return (PrologTerm)sentences.iterator().next();
        }
        throw new IllegalStateException("ProBParserBase should create a single term, but returned " + size + " terms");
    }
}

