/*
 * Decompiled with CFR 0.152.
 */
package de.be4.ltl.core.parser.internal;

import de.hhu.stups.sablecc.patch.IToken;

abstract class LexerHelper<TOKEN extends IToken, STATE> {
    private int count;
    private TOKEN externalFormula;
    private StringBuilder text;
    private STATE state;
    private STATE lastState;
    private boolean inQuote;

    protected abstract boolean isInActionOrAtomic(STATE var1);

    protected abstract boolean isOpening(TOKEN var1);

    protected abstract boolean isClosing(TOKEN var1);

    protected abstract boolean correctBalancedParenthesis(int var1, TOKEN var2);

    protected abstract boolean isInActions(STATE var1);

    protected abstract boolean isOpeningActionArg(TOKEN var1);

    protected abstract boolean isClosingActionArg(TOKEN var1);

    protected abstract boolean isBeginningActionsToken(TOKEN var1);

    protected abstract boolean isArgumentClosing(TOKEN var1);

    protected abstract boolean isArgumentSplittingToken(TOKEN var1);

    protected abstract boolean isQuote(TOKEN var1);

    public LexerHelper(STATE initialState) {
        this.lastState = initialState;
    }

    public TOKEN filter(STATE newState, TOKEN token) {
        if (this.isQuote(token)) {
            this.inQuote = !this.inQuote;
        }
        this.state = newState;
        if (this.isInActionOrAtomic(this.state)) {
            if (this.externalFormula == null) {
                this.initialiseActionToken(token);
                return null;
            }
            this.text.append(token.getText());
            if (this.isOpening(token) && !this.inQuote) {
                ++this.count;
            } else if (this.isClosing(token) && !this.inQuote) {
                --this.count;
            }
            if (!this.correctBalancedParenthesis(this.count, token)) {
                return token;
            }
            if (this.count != 0) {
                return null;
            }
            this.state = this.lastState;
            this.text.deleteCharAt(this.text.length() - 1);
            this.externalFormula.setText(this.text.toString());
            TOKEN tok = this.externalFormula;
            this.externalFormula = null;
            return tok;
        }
        if (this.isInActions(this.state)) {
            if (this.isBeginningActionsToken(token)) {
                return token;
            }
            if (this.externalFormula == null) {
                this.initialiseActionToken(token);
                this.text.append(token.getText());
                return null;
            }
            if (this.isOpeningActionArg(token)) {
                ++this.count;
            } else if (this.isClosingActionArg(token)) {
                --this.count;
            }
            if (!this.correctBalancedParenthesis(this.count, token)) {
                return token;
            }
            if (this.count == 1 && !this.isArgumentClosing(token) || this.count > 1) {
                this.text.append(token.getText());
            }
            if (this.count == 1 && this.isArgumentSplittingToken(token)) {
                return this.updateTokenText();
            }
            if (this.count == 0) {
                this.state = this.lastState;
                return this.updateTokenText();
            }
            return null;
        }
        this.lastState = this.state;
        return token;
    }

    public void initialiseActionToken(TOKEN token) {
        this.externalFormula = token;
        this.text = new StringBuilder();
        this.count = 1;
        this.inQuote = false;
    }

    public TOKEN updateTokenText() {
        this.externalFormula.setText(this.text.toString().trim());
        TOKEN tok = this.externalFormula;
        this.externalFormula = null;
        return tok;
    }

    public TOKEN getIdentifier(TOKEN token, TOKEN ident) {
        String str = token.getText();
        String identifier = str.substring(1, str.length() - 1).trim();
        ident.setText(identifier);
        return ident;
    }

    public STATE getState() {
        return this.state;
    }
}

