/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.rules;

import de.be4.classicalb.core.parser.analysis.prolog.MachineReference;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.rules.ComputationOperation;
import de.be4.classicalb.core.parser.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractOperation {
    private final TIdentifierLiteral originalName;
    private final String fileName;
    private final String machineName;
    private final List<MachineReference> machineReferences;
    private final List<AIdentifierExpression> dependsOnRuleList = new ArrayList<AIdentifierExpression>();
    private final List<AIdentifierExpression> dependsOnComputationList = new ArrayList<AIdentifierExpression>();
    private final List<String> tags = new ArrayList<String>();
    private PPredicate activationPredicate;
    private PPredicate postconditionPredicate;
    private Set<AbstractOperation> transitiveDependencies;
    private List<ComputationOperation> implicitDependenciesToComputations;
    private AIdentifierExpression replacesIdentifier;
    protected final Map<String, AIdentifierExpression> readMap = new HashMap<String, AIdentifierExpression>();
    protected final Map<String, TIdentifierLiteral> functionCallMap = new HashMap<String, TIdentifierLiteral>();
    private Set<AbstractOperation> requiredDependencies;

    public AbstractOperation(TIdentifierLiteral name, String fileName, String machineName, List<MachineReference> machineReferences2) {
        this.originalName = name;
        this.fileName = fileName;
        this.machineName = machineName;
        this.machineReferences = machineReferences2;
    }

    public String getFileName() {
        return this.fileName;
    }

    public List<AIdentifierExpression> getDependsOnRulesList() {
        return this.dependsOnRuleList;
    }

    public List<AIdentifierExpression> getDependsOnComputationList() {
        return this.dependsOnComputationList;
    }

    public List<TIdentifierLiteral> getFunctionCalls() {
        return new ArrayList<TIdentifierLiteral>(this.functionCallMap.values());
    }

    public void addAllRuleDependencies(List<AIdentifierExpression> list) {
        this.dependsOnRuleList.addAll(list);
    }

    public void addAllComputationDependencies(List<AIdentifierExpression> list) {
        this.dependsOnComputationList.addAll(list);
    }

    public void setActivationPredicate(PPredicate predicate) {
        this.activationPredicate = predicate;
    }

    public PPredicate getActivationPredicate() {
        return this.activationPredicate;
    }

    public void setPostcondition(PPredicate predicate) {
        this.postconditionPredicate = predicate;
    }

    public PPredicate getPostconditionPredicate() {
        return this.postconditionPredicate;
    }

    protected String getOriginalName() {
        return this.originalName.getText();
    }

    public String getName() {
        if (this.replacesOperation()) {
            return this.getReplacedOperationName();
        }
        return this.originalName.getText();
    }

    public void addTags(List<String> list) {
        this.tags.addAll(list);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public TIdentifierLiteral getNameLiteral() {
        return this.originalName;
    }

    public void setTransitiveDependencies(Set<AbstractOperation> dependencies) {
        this.transitiveDependencies = dependencies;
    }

    public Set<AbstractOperation> getTransitiveDependencies() {
        if (this.transitiveDependencies == null) {
            return null;
        }
        return new HashSet<AbstractOperation>(this.transitiveDependencies);
    }

    public Set<AbstractOperation> getRequiredDependencies() {
        if (this.requiredDependencies == null) {
            this.requiredDependencies = new HashSet<AbstractOperation>();
            HashSet<AIdentifierExpression> aIdentifierSet = new HashSet<AIdentifierExpression>();
            aIdentifierSet.addAll(this.dependsOnComputationList);
            aIdentifierSet.addAll(this.dependsOnRuleList);
            HashSet<String> directDependencies = new HashSet<String>();
            for (AIdentifierExpression aIdentifier : aIdentifierSet) {
                directDependencies.add(aIdentifier.getIdentifier().get(0).getText());
            }
            if (this.transitiveDependencies != null) {
                for (AbstractOperation abstractOperation : this.transitiveDependencies) {
                    String opName = abstractOperation.getOriginalName();
                    if (this.implicitDependenciesToComputations.contains(abstractOperation) || directDependencies.contains(opName)) {
                        this.requiredDependencies.add(abstractOperation);
                        continue;
                    }
                    if (!this.functionCallMap.containsKey(opName)) continue;
                    this.requiredDependencies.addAll(abstractOperation.getRequiredDependencies());
                }
            }
        }
        return new HashSet<AbstractOperation>(this.requiredDependencies);
    }

    public String toString() {
        return this.getOriginalName();
    }

    public void addReadVariable(AIdentifierExpression identifier) {
        String varName = identifier.getIdentifier().get(0).getText();
        if (!this.readMap.containsKey(varName)) {
            this.readMap.put(varName, identifier);
        }
    }

    public void addFunctionCall(TIdentifierLiteral identifier) {
        String name = identifier.getText();
        if (!this.functionCallMap.containsKey(name)) {
            this.functionCallMap.put(name, identifier);
        }
    }

    public AIdentifierExpression getVariableReadByName(String name) {
        return this.readMap.get(name);
    }

    public Set<String> getReadVariables() {
        return new HashSet<String>(this.readMap.keySet());
    }

    public List<String> getMachineReferencesAsString() {
        ArrayList<String> list = new ArrayList<String>();
        for (MachineReference reference : this.machineReferences) {
            list.add(reference.getName());
        }
        return list;
    }

    public boolean replacesOperation() {
        return this.replacesIdentifier != null;
    }

    public AIdentifierExpression getReplacesIdentifier() {
        return this.replacesIdentifier;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public void addReplacesIdentifier(AIdentifierExpression idExpr) {
        this.replacesIdentifier = idExpr;
    }

    public void setImplicitComputationDependencies(List<ComputationOperation> inferredDependenciesToComputations) {
        this.implicitDependenciesToComputations = inferredDependenciesToComputations;
    }

    public List<TIdentifierLiteral> getImplicitDependenciesToComputations() {
        ArrayList<TIdentifierLiteral> result = new ArrayList<TIdentifierLiteral>();
        for (ComputationOperation comp : this.implicitDependenciesToComputations) {
            TIdentifierLiteral nameLiteral = comp.getNameLiteral();
            result.add(nameLiteral);
        }
        return result;
    }

    public static <T extends AbstractOperation> Set<T> filterOperations(Collection<AbstractOperation> in, Class<T> clazz) {
        HashSet<AbstractOperation> set = new HashSet<AbstractOperation>();
        for (AbstractOperation abstractOperation : in) {
            if (abstractOperation.getClass() != clazz) continue;
            set.add(abstractOperation);
        }
        return set;
    }

    public List<AbstractOperation> getSortedListOfTransitiveDependencies() {
        return AbstractOperation.sortList(this.getTransitiveDependencies());
    }

    public static List<AbstractOperation> sortList(Collection<AbstractOperation> operations) {
        ArrayList<AbstractOperation> result = new ArrayList<AbstractOperation>();
        ArrayList<AbstractOperation> todo = new ArrayList<AbstractOperation>(operations);
        boolean change = true;
        while (change) {
            change = false;
            for (AbstractOperation abstractOperation : new ArrayList<AbstractOperation>(todo)) {
                Set<AbstractOperation> transitiveDependencies = abstractOperation.getTransitiveDependencies();
                result.forEach(transitiveDependencies::remove);
                if (!transitiveDependencies.isEmpty()) continue;
                result.add(abstractOperation);
                todo.remove(abstractOperation);
                change = true;
            }
        }
        if (!todo.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public String getReplacedOperationName() {
        if (this.replacesOperation()) {
            return Utils.getAIdentifierAsString(this.replacesIdentifier);
        }
        return null;
    }
}

