/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.exceptions;

import de.be4.classicalb.core.parser.exceptions.BLexerException;
import de.be4.classicalb.core.parser.exceptions.BParseException;
import de.be4.classicalb.core.parser.exceptions.CheckException;
import de.be4.classicalb.core.parser.exceptions.PreParseException;
import de.be4.classicalb.core.parser.lexer.LexerException;
import de.hhu.stups.sablecc.patch.PositionedNode;
import de.hhu.stups.sablecc.patch.SourcePosition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class BException
extends Exception {
    private final String filename;
    private final List<Location> locations = new ArrayList<Location>();

    public BException(String filename, List<Location> locations, String message, Throwable cause) {
        super(message, cause);
        this.filename = filename;
        this.locations.addAll(locations);
    }

    public BException(String filename, String message, Throwable cause) {
        this(filename, Collections.emptyList(), message, cause);
    }

    public BException(String filename, LexerException e) {
        this(filename, e.getRealMsg(), e);
        if (e.getLine() != 0 && e.getPos() != 0) {
            this.locations.add(new Location(filename, e.getLine(), e.getPos(), e.getLine(), e.getPos()));
        }
    }

    public BException(String filename, BLexerException e) {
        this(filename, e.getRealMsg(), e);
        this.locations.add(new Location(filename, e.getLastLine(), e.getLastPos(), e.getLastLine(), e.getLastPos() + e.getLastText().length()));
    }

    public BException(String filename, BParseException e) {
        this(filename, e.getRealMsg(), e);
        Location location;
        if (e.getToken() != null && (location = Location.fromNode(filename, e.getToken())) != null) {
            this.locations.add(location);
        }
    }

    public BException(String filename, PreParseException e) {
        this(filename, e.getMessage(), e);
        if (e.getTokensList().isEmpty()) {
            if (e.getLine() != 0 && e.getPos() != 0) {
                this.locations.add(new Location(filename, e.getLine(), e.getPos(), e.getLine(), e.getPos()));
            }
        } else {
            this.locations.addAll(Location.locationsFromNodes(filename, e.getTokensList()));
        }
    }

    public BException(String filename, CheckException e) {
        this(filename, e.getMessage(), e);
        this.locations.addAll(Location.locationsFromNodes(filename, e.getNodesList()));
    }

    public BException(String filename, IOException e) {
        this(filename, "File cannot be read: " + e.getMessage(), e);
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public String getFilename() {
        return this.filename;
    }

    public static final class Location {
        private final String filename;
        private final int startLine;
        private final int startColumn;
        private final int endLine;
        private final int endColumn;

        public Location(String filename, int startLine, int startColumn, int endLine, int endColumn) {
            this.filename = filename;
            this.startLine = startLine;
            this.startColumn = startColumn;
            this.endLine = endLine;
            this.endColumn = endColumn;
        }

        public static Location fromNode(String filename, PositionedNode node) {
            SourcePosition startPos = node.getStartPos();
            if (startPos == null) {
                return null;
            }
            SourcePosition endPos = node.getEndPos();
            if (endPos == null) {
                endPos = startPos;
            }
            return new Location(filename, startPos.getLine(), startPos.getPos(), endPos.getLine(), endPos.getPos());
        }

        public static List<Location> locationsFromNodes(String filename, Collection<? extends PositionedNode> nodes) {
            return nodes.stream().map(node -> Location.fromNode(filename, node)).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public String getFilename() {
            return this.filename;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getStartColumn() {
            return this.startColumn;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public int getEndColumn() {
            return this.endColumn;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Location)) {
                return false;
            }
            Location other = (Location)obj;
            return Objects.equals(this.getFilename(), other.getFilename()) && this.getStartLine() == other.getStartLine() && this.getStartColumn() == other.getStartColumn() && this.getEndLine() == other.getEndLine() && this.getEndColumn() == other.getEndColumn();
        }

        public int hashCode() {
            return Objects.hash(this.getFilename(), this.getStartLine(), this.getStartColumn(), this.getEndLine(), this.getEndColumn());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getFilename());
            sb.append(':');
            sb.append(this.getStartLine());
            sb.append(':');
            sb.append(this.getStartColumn());
            if (this.getStartLine() != this.getEndLine() || this.getStartColumn() != this.getEndColumn()) {
                sb.append(" to ");
                sb.append(this.getEndLine());
                sb.append(':');
                sb.append(this.getEndColumn());
            }
            return sb.toString();
        }
    }
}

