/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.analysis.transforming;

import de.be4.classicalb.core.parser.IDefinitions;
import de.be4.classicalb.core.parser.analysis.OptimizedTraversingAdapter;
import de.be4.classicalb.core.parser.exceptions.CheckException;
import de.be4.classicalb.core.parser.exceptions.VisitorException;
import de.be4.classicalb.core.parser.node.ADefinitionExpression;
import de.be4.classicalb.core.parser.node.ADefinitionSubstitution;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AFunctionExpression;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AOperationCallSubstitution;
import de.be4.classicalb.core.parser.node.AOperationOrDefinitionCallSubstitution;
import de.be4.classicalb.core.parser.node.ASubstitutionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.node.TDefLiteralSubstitution;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class OpSubstitutions
extends OptimizedTraversingAdapter {
    private final IDefinitions definitions;

    private OpSubstitutions(IDefinitions definitions) {
        this.definitions = definitions;
    }

    public static void transform(Start start, IDefinitions definitions) throws CheckException {
        try {
            start.apply(new OpSubstitutions(definitions));
        }
        catch (VisitorException e) {
            throw e.getException();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void caseAOperationOrDefinitionCallSubstitution(AOperationOrDefinitionCallSubstitution node) {
        void var4_11;
        IDefinitions.Type type;
        PExpression idExpr;
        PExpression expression = node.getExpression();
        TIdentifierLiteral idToken = null;
        String idString = null;
        if (expression instanceof AFunctionExpression) {
            AFunctionExpression function = (AFunctionExpression)expression;
            idExpr = function.getIdentifier();
            if (idExpr instanceof AIdentifierExpression) {
                AIdentifierExpression identifier = (AIdentifierExpression)idExpr;
                idString = Utils.getTIdentifierListAsString(identifier.getIdentifier());
                idToken = identifier.getIdentifier().get(0);
                type = this.definitions.getType(idString);
            } else {
                type = IDefinitions.Type.NoDefinition;
            }
            ArrayList<PExpression> arrayList = new ArrayList<PExpression>(function.getParameters());
        } else {
            if (!(expression instanceof AIdentifierExpression)) throw new VisitorException(new CheckException("Expecting operation", expression));
            AIdentifierExpression identifier = (AIdentifierExpression)expression;
            idString = Utils.getTIdentifierListAsString(identifier.getIdentifier());
            idToken = identifier.getIdentifier().get(0);
            type = this.definitions.getType(idString);
            idExpr = expression;
            List list = Collections.emptyList();
        }
        if (type != IDefinitions.Type.NoDefinition && idToken != null) {
            if (type != IDefinitions.Type.Substitution && type != IDefinitions.Type.ExprOrSubst) throw new VisitorException(new CheckException("Expecting substitution here but found definition with type '" + (Object)((Object)type) + "'", node));
            ADefinitionSubstitution defSubst = new ADefinitionSubstitution(new TDefLiteralSubstitution(idToken.getText(), idToken.getLine(), idToken.getPos()), (List<PExpression>)var4_11);
            if (type == IDefinitions.Type.ExprOrSubst) {
                this.setTypeSubstDef(node, idString);
            }
            defSubst.setStartPos(node.getStartPos());
            defSubst.setEndPos(node.getEndPos());
            node.replaceBy(defSubst);
            defSubst.apply(this);
            return;
        } else {
            if (!(idExpr instanceof AIdentifierExpression)) {
                throw new VisitorException(new CheckException("Operation name in operation call must be an identifier", idExpr));
            }
            LinkedList<TIdentifierLiteral> operationName = ((AIdentifierExpression)idExpr).getIdentifier();
            AOperationCallSubstitution opSubst = new AOperationCallSubstitution(Collections.emptyList(), new ArrayList<TIdentifierLiteral>(operationName), (List<PExpression>)var4_11);
            opSubst.setStartPos(idExpr.getStartPos());
            opSubst.setEndPos(idExpr.getEndPos());
            node.replaceBy(opSubst);
            opSubst.apply(this);
        }
    }

    @Override
    public void caseAIdentifierExpression(AIdentifierExpression node) {
        if (node.getIdentifier().size() != 1) {
            return;
        }
        TIdentifierLiteral identifier = node.getIdentifier().get(0);
        String identifierString = identifier.getText();
        IDefinitions.Type type = this.definitions.getType(identifierString);
        if (type != IDefinitions.Type.NoDefinition) {
            if (type == IDefinitions.Type.Expression || type == IDefinitions.Type.ExprOrSubst) {
                this.replaceWithDefExpression(node, identifier, null);
                if (type == IDefinitions.Type.ExprOrSubst) {
                    this.definitions.setDefinitionType(identifierString, IDefinitions.Type.Expression);
                }
            } else {
                throw new VisitorException(new CheckException("Expecting expression here but found definition with type '" + (Object)((Object)type) + "'", node));
            }
        }
    }

    @Override
    public void caseAFunctionExpression(AFunctionExpression node) {
        if (node.getIdentifier() != null) {
            node.getIdentifier().apply(this);
        }
        if (node.getIdentifier() instanceof ADefinitionExpression && ((ADefinitionExpression)node.getIdentifier()).getParameters().isEmpty()) {
            ArrayList<PExpression> paramList = new ArrayList<PExpression>(node.getParameters());
            TIdentifierLiteral identifier = ((ADefinitionExpression)node.getIdentifier()).getDefLiteral();
            if (this.definitions.getParameterCount(identifier.getText()) != 0) {
                ADefinitionExpression newNode = this.replaceWithDefExpression(node, identifier, paramList);
                for (PExpression e : newNode.getParameters()) {
                    e.apply(this);
                }
                return;
            }
        }
        for (PExpression e : node.getParameters()) {
            e.apply(this);
        }
    }

    private ADefinitionExpression replaceWithDefExpression(Node node, TIdentifierLiteral identifier, List<PExpression> paramList) {
        ADefinitionExpression newNode = new ADefinitionExpression();
        newNode.setDefLiteral(identifier);
        if (paramList != null) {
            newNode.setParameters(paramList);
        }
        newNode.setStartPos(node.getStartPos());
        newNode.setEndPos(node.getEndPos());
        node.replaceBy(newNode);
        return newNode;
    }

    private void setTypeSubstDef(AOperationOrDefinitionCallSubstitution node, String idString) {
        AOperationCallSubstitution rhsSubst;
        AExpressionDefinitionDefinition oldDefinition = (AExpressionDefinitionDefinition)this.definitions.getDefinition(idString);
        PExpression defRhs = oldDefinition.getRhs();
        if (defRhs instanceof AFunctionExpression) {
            AFunctionExpression rhsFunction = (AFunctionExpression)defRhs;
            PExpression idExpr = rhsFunction.getIdentifier();
            if (!(idExpr instanceof AIdentifierExpression)) {
                throw new VisitorException(new CheckException("Operation name in operation call must be an identifier", idExpr));
            }
            LinkedList<TIdentifierLiteral> operationName = ((AIdentifierExpression)idExpr).getIdentifier();
            rhsSubst = new AOperationCallSubstitution(Collections.emptyList(), new ArrayList<TIdentifierLiteral>(operationName), new ArrayList<PExpression>(rhsFunction.getParameters()));
        } else if (defRhs instanceof AIdentifierExpression) {
            AIdentifierExpression rhsIdent = (AIdentifierExpression)defRhs;
            rhsSubst = new AOperationCallSubstitution(Collections.emptyList(), new ArrayList<TIdentifierLiteral>(rhsIdent.getIdentifier()), Collections.emptyList());
        } else {
            throw new VisitorException(new CheckException("Expecting operation", node));
        }
        rhsSubst.setStartPos(defRhs.getStartPos());
        rhsSubst.setEndPos(defRhs.getEndPos());
        TIdentifierLiteral oldDefId = oldDefinition.getName();
        TDefLiteralSubstitution defId = new TDefLiteralSubstitution(oldDefId.getText(), oldDefId.getLine(), oldDefId.getPos());
        ASubstitutionDefinitionDefinition substDef = new ASubstitutionDefinitionDefinition(defId, new ArrayList<PExpression>(oldDefinition.getParameters()), rhsSubst);
        substDef.setStartPos(oldDefinition.getStartPos());
        substDef.setEndPos(oldDefinition.getEndPos());
        this.definitions.replaceDefinition(idString, IDefinitions.Type.Substitution, substDef);
        oldDefinition.replaceBy(substDef);
    }
}

