/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.analysis.prolog;

import de.be4.classicalb.core.parser.analysis.prolog.MachineReference;
import de.be4.classicalb.core.parser.analysis.prolog.MachineType;
import de.be4.classicalb.core.parser.analysis.prolog.PackageName;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ReferencedMachines {
    private final String machineName;
    private final MachineType type;
    private final List<MachineReference> references;
    private final PackageName packageName;
    private final Path rootPackageDirectory;
    private final Map<PackageName, Path> importedPackages;

    public ReferencedMachines(String machineName, MachineType type, List<MachineReference> references, PackageName packageName, Path rootPackageDirectory, Map<PackageName, Path> importedPackages) {
        this.machineName = machineName;
        this.type = type;
        this.references = references;
        this.packageName = packageName;
        this.rootPackageDirectory = rootPackageDirectory;
        this.importedPackages = importedPackages;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public MachineType getType() {
        return this.type;
    }

    public List<MachineReference> getReferences() {
        return Collections.unmodifiableList(this.references);
    }

    public PackageName getPackageName() {
        return this.packageName;
    }

    public Path getRootPackageDirectory() {
        return this.rootPackageDirectory;
    }

    public Map<PackageName, Path> getImportedPackages() {
        return Collections.unmodifiableMap(this.importedPackages);
    }
}

