/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import util.FileUtil;
import util.FilenameToStream;
import util.ToolIO;

public class SimpleFilenameToStream
implements FilenameToStream {
    public static final String TLA_LIBRARY = "TLA-Library";
    public static final String STANDARD_MODULES_FOLDER = "StandardModules";
    private static final ClassLoader cl = SimpleFilenameToStream.class.getClassLoader();
    private static final String STANDARD_MODULES = "tla2sany/StandardModules/";
    private String[] libraryPaths;

    public SimpleFilenameToStream() {
        this.libraryPaths = this.getLibraryPaths(this.getInstallationBasePath(), null);
    }

    public SimpleFilenameToStream(String libraryPath) {
        this(new String[]{libraryPath});
    }

    public SimpleFilenameToStream(String[] anLibraryPaths) {
        this.libraryPaths = this.getLibraryPaths(this.getInstallationBasePath(), anLibraryPaths);
    }

    private String getInstallationBasePath() {
        URL url = cl.getResource("tla2sany");
        String path = url.toString();
        try {
            if (!FilenameToStream.isInJar(path)) {
                URI uri = new URI(path);
                return new File(uri).getAbsolutePath();
            }
        }
        catch (URISyntaxException e) {
            System.err.println(path);
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            System.err.println(path);
            e.printStackTrace();
        }
        return path;
    }

    @Override
    public String getFullPath() {
        StringBuffer buf = new StringBuffer();
        String[] ar = this.libraryPaths;
        for (int i = 0; i < ar.length; ++i) {
            buf.append(ar[i]);
            if (i >= ar.length - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    private String[] getLibraryPaths(String installationBasePath, String[] libraries) {
        String[] res;
        int i;
        String path = null;
        if (libraries == null) {
            path = System.getProperty(TLA_LIBRARY);
        } else {
            StringBuffer buf = new StringBuffer();
            for (i = 0; i < libraries.length; ++i) {
                buf.append(libraries[i]);
                if (i >= libraries.length - 1) continue;
                buf.append(FileUtil.pathSeparator);
            }
            path = buf.toString();
        }
        if (path == null) {
            res = new String[]{installationBasePath + FileUtil.separator + STANDARD_MODULES_FOLDER + FileUtil.separator};
        } else {
            String[] paths = path.split(FileUtil.pathSeparator);
            res = new String[paths.length + 1];
            for (i = 0; i < paths.length; ++i) {
                res[i] = paths[i];
                if (res[i].endsWith(FileUtil.separator)) continue;
                res[i] = res[i] + FileUtil.separator;
            }
            res[paths.length] = installationBasePath + FileUtil.separator + STANDARD_MODULES_FOLDER + FileUtil.separator;
        }
        return res;
    }

    private final File locate(String name) {
        String prefix = "";
        File sourceFile = null;
        int idx = 0;
        while (true) {
            InputStream is;
            if (idx == 0 && ToolIO.getUserDir() != null) {
                sourceFile = new FilenameToStream.TLAFile(ToolIO.getUserDir(), name, (FilenameToStream)this);
            } else if (FilenameToStream.isInJar(prefix)) {
                is = cl.getResourceAsStream(STANDARD_MODULES + name);
                if (is != null) {
                    sourceFile = this.read(name, is);
                }
            } else {
                sourceFile = new FilenameToStream.TLAFile(prefix + name, true, (FilenameToStream)this);
            }
            if (sourceFile.exists()) break;
            if (idx >= this.libraryPaths.length) {
                is = cl.getResourceAsStream(name);
                if (is == null) break;
                return this.read(name, is);
            }
            prefix = this.libraryPaths[idx++];
        }
        return sourceFile;
    }

    private File read(String name, InputStream is) {
        FilenameToStream.TLAFile sourceFile = new FilenameToStream.TLAFile(TMPDIR + File.separator + name, true, (FilenameToStream)this);
        sourceFile.deleteOnExit();
        try {
            int len;
            FileOutputStream fos = new FileOutputStream(sourceFile);
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) > 0) {
                fos.write(buf, 0, len);
            }
            fos.close();
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sourceFile;
    }

    @Override
    public File resolve(String name, boolean isModule) {
        int n = name.indexOf(10);
        if (n >= 0) {
            ToolIO.out.println("*** Warning: module name '" + name + "' contained NEWLINE; Only the part before NEWLINE is considered.");
            name = name.substring(0, n);
        }
        String sourceFileName = null;
        if (isModule) {
            if (name.toLowerCase().endsWith(".tla")) {
                name = name.substring(0, name.length() - ".tla".length());
            }
            sourceFileName = name + ".tla";
        } else {
            sourceFileName = name;
        }
        return this.locate(sourceFileName);
    }

    public File resolve(String name) {
        return this.resolve(name, false);
    }

    @Override
    public boolean isStandardModule(String moduleName) {
        File file = this.resolve(moduleName, true);
        if (file == null) {
            return false;
        }
        String path = file.getAbsolutePath();
        if (path == null) {
            return false;
        }
        return path.startsWith(this.libraryPaths[this.libraryPaths.length - 1]);
    }
}

