/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.tlc;

import de.tlc4b.btypes.BType;
import de.tlc4b.btypes.FunctionType;
import de.tlc4b.btypes.PairType;
import de.tlc4b.btypes.SetType;
import de.tlc4b.btypes.StructType;
import de.tlc4b.exceptions.NotSupportedException;
import de.tlc4b.tlc.TLCOutputInfo;
import java.util.ArrayList;
import java.util.List;
import tla2sany.semantic.OpDeclNode;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.value.impl.FcnLambdaValue;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.IntervalValue;
import tlc2.value.impl.LazyValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.SetCapValue;
import tlc2.value.impl.SetCupValue;
import tlc2.value.impl.SetDiffValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.SetOfFcnsValue;
import tlc2.value.impl.SetOfRcdsValue;
import tlc2.value.impl.SetOfTuplesValue;
import tlc2.value.impl.SetPredValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.SubsetValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.UnionValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import tlc2.value.impl.ValueVec;
import util.UniqueString;

public class TracePrinter {
    List<TLCStateInfo> trace;
    TLCState initialState;
    final TLCOutputInfo tlcOutputInfo;
    List<OpDeclNode> constants;
    List<OpDeclNode> variables;
    StringBuilder traceBuilder;

    public TracePrinter(List<TLCStateInfo> trace, TLCOutputInfo tlcOutputInfo) {
        this.trace = trace;
        this.tlcOutputInfo = tlcOutputInfo;
        this.constants = new ArrayList<OpDeclNode>();
        this.variables = new ArrayList<OpDeclNode>();
        for (int i = 0; i < TLCState.vars.length; ++i) {
            String tlaName = TLCState.vars[i].getName().toString();
            String bName = tlcOutputInfo.getBName(tlaName);
            if (tlcOutputInfo.constants.contains(bName)) {
                this.constants.add(TLCState.vars[i]);
                continue;
            }
            this.variables.add(TLCState.vars[i]);
        }
        this.evalTrace();
    }

    public StringBuilder getTrace() {
        return this.traceBuilder;
    }

    private void evalTrace() {
        this.traceBuilder = new StringBuilder();
        if (this.trace != null) {
            this.traceBuilder.append((CharSequence)this.setupConstants(this.trace.get((int)0).state));
            for (int i = 0; i < this.trace.size(); ++i) {
                if (i > 0) {
                    this.traceBuilder.append("\n");
                }
                this.traceBuilder.append((CharSequence)this.evalExpression(this.trace.get((int)i).state));
            }
        } else {
            this.traceBuilder.append((CharSequence)this.setupConstants(this.initialState));
            this.traceBuilder.append((CharSequence)this.evalExpression(this.initialState));
        }
    }

    private StringBuilder setupConstants(TLCState state) {
        StringBuilder expression = new StringBuilder();
        if (this.tlcOutputInfo.constantSetup) {
            if (this.constants.isEmpty()) {
                expression.append("1 = 1");
            } else {
                for (int i = 0; i < this.constants.size(); ++i) {
                    if (i > 0) {
                        expression.append(" & ");
                    }
                    UniqueString var = this.constants.get(i).getName();
                    String bName = this.tlcOutputInfo.getBName(var.toString());
                    BType type = this.tlcOutputInfo.getBType(var.toString());
                    String value = this.parseValue((Value)state.lookup(var), type).toString();
                    expression.append(bName).append(" = ").append(value);
                }
            }
            expression.append("\n");
        }
        return expression;
    }

    private StringBuilder evalExpression(TLCState state) {
        StringBuilder expression = new StringBuilder();
        for (int i = 0; i < this.variables.size(); ++i) {
            if (i > 0) {
                expression.append(" & ");
            }
            UniqueString var = this.variables.get(i).getName();
            String bName = this.tlcOutputInfo.getBName(var.toString());
            BType type = this.tlcOutputInfo.getBType(var.toString());
            String value = this.parseValue((Value)state.lookup(var), type).toString();
            expression.append(bName).append(" = ").append(value);
        }
        return expression;
    }

    private StringBuilder parseValue(Value val, BType type) {
        StringBuilder res = new StringBuilder();
        byte valueType = val.getKind();
        switch (valueType) {
            case 0: 
            case 1: {
                return res.append(val);
            }
            case 23: {
                IntervalValue i = (IntervalValue)val;
                res.append("(");
                res.append(i.low).append("..").append(i.high);
                res.append(")");
                return res;
            }
            case 5: {
                SetType set = (SetType)type;
                res.append("{");
                res.append((CharSequence)this.parseValueVec(((SetEnumValue)val).elems, set.getSubtype()));
                res.append("}");
                return res;
            }
            case 7: {
                if (type instanceof PairType) {
                    BType first = ((PairType)type).getFirst();
                    BType second = ((PairType)type).getSecond();
                    res.append("(");
                    res.append((CharSequence)this.parseValue(((TupleValue)val).elems[0], first));
                    res.append(", ");
                    res.append((CharSequence)this.parseValue(((TupleValue)val).elems[1], second));
                    res.append(")");
                    return res;
                }
                if (type instanceof FunctionType) {
                    if (((TupleValue)val).elems.length == 0) {
                        res.append("{}");
                    } else {
                        BType subtype = ((FunctionType)type).getRange();
                        res.append("[");
                        res.append((CharSequence)this.parseEnumerationValue(((TupleValue)val).elems, subtype));
                        res.append("]");
                    }
                    return res;
                }
                throw new NotSupportedException("Unknown type of tuple.");
            }
            case 4: {
                RecordValue rec = (RecordValue)val;
                StructType struct = (StructType)type;
                res.append("rec(");
                for (int i = 0; i < rec.names.length; ++i) {
                    if (i > 0) {
                        res.append(", ");
                    }
                    String name = rec.names[i].toString();
                    BType t = struct.getType(name);
                    res.append(name).append(" : ");
                    res.append((CharSequence)this.parseValue(rec.values[i], t));
                }
                res.append(")");
                return res;
            }
            case 9: {
                FcnRcdValue function = (FcnRcdValue)val;
                FunctionType funcType = (FunctionType)type;
                res.append("{");
                for (int i = 0; i < function.domain.length; ++i) {
                    if (i > 0) {
                        res.append(", ");
                    }
                    res.append("(");
                    res.append((CharSequence)this.parseValue(function.domain[i], funcType.getDomain()));
                    res.append(", ");
                    res.append((CharSequence)this.parseValue(function.values[i], funcType.getRange()));
                    res.append(")");
                }
                res.append("}");
                return res;
            }
            case 21: {
                ModelValue modelValue = (ModelValue)val;
                String bName = this.tlcOutputInfo.getBName(modelValue.toString());
                if (bName == null) {
                    bName = modelValue.toString();
                }
                res.append(bName);
                return res;
            }
            case 15: {
                SetOfTuplesValue s = (SetOfTuplesValue)val;
                ValueEnumeration e = s.elements();
                return this.parseSetValue(res, s.size(), type, e);
            }
            case 19: {
                SetCupValue s = (SetCupValue)val;
                ValueEnumeration e = s.elements();
                return this.parseSetValue(res, s.size(), type, e);
            }
            case 18: {
                SetCapValue s = (SetCapValue)val;
                ValueEnumeration e = s.elements();
                return this.parseSetValue(res, s.size(), type, e);
            }
            case 17: {
                SetDiffValue s = (SetDiffValue)val;
                ValueEnumeration e = s.elements();
                return this.parseSetValue(res, s.size(), type, e);
            }
            case 16: {
                SubsetValue s = (SubsetValue)val;
                SetType t = (SetType)type;
                res.append("POW(").append((CharSequence)this.parseValue(s.set, t.getSubtype())).append(")");
                return res;
            }
            case 20: {
                UnionValue s = (UnionValue)val;
                SetType t = (SetType)type;
                res.append("union(");
                res.append((CharSequence)this.parseValue(s.set, new SetType(t)));
                res.append(")");
                return res;
            }
            case 14: {
                SetOfRcdsValue s = (SetOfRcdsValue)val;
                SetType t = (SetType)type;
                StructType struct = (StructType)t.getSubtype();
                res.append("struct(");
                for (int i = 0; i < s.names.length; ++i) {
                    if (i > 0) {
                        res.append(", ");
                    }
                    res.append(s.names[i]);
                    res.append(":");
                    BType fieldType = struct.getType(s.names[i].toString());
                    res.append((CharSequence)this.parseValue(s.values[i], new SetType(fieldType)));
                }
                res.append(")");
                return res;
            }
            case 13: {
                SetOfFcnsValue s = (SetOfFcnsValue)val;
                SetType t = (SetType)type;
                FunctionType func = (FunctionType)t.getSubtype();
                res.append("(");
                res.append((CharSequence)this.parseValue(s.domain, new SetType(func.getDomain())));
                res.append(" --> ");
                res.append((CharSequence)this.parseValue(s.range, new SetType(func.getRange())));
                res.append(")");
                return res;
            }
            case 3: {
                StringValue s = (StringValue)val;
                res.append("\"").append(s.getVal()).append("\"");
                return res;
            }
            case 8: {
                FcnLambdaValue s = (FcnLambdaValue)val;
                res.append((CharSequence)this.parseValue(s.fcnRcd, type));
                return res;
            }
            case 6: {
                SetPredValue s = (SetPredValue)val;
                res.append((CharSequence)this.parseValue(s.inVal, type));
                return res;
            }
            case 25: {
                LazyValue s = (LazyValue)val;
                res.append((CharSequence)this.parseValue(s.getValue(), type));
                return res;
            }
        }
        System.err.println("Type: " + val.getKind());
        throw new RuntimeException("not supported construct: " + val);
    }

    private StringBuilder parseSetValue(StringBuilder res, int size, BType type, ValueEnumeration e) {
        SetType t = (SetType)type;
        res.append("{");
        for (int i = 0; i < size; ++i) {
            Value v = e.nextElement();
            if (i != 0) {
                res.append(", ");
            }
            if (v == null) continue;
            res.append((CharSequence)this.parseValue(v, t.getSubtype()));
        }
        res.append("}");
        return res;
    }

    private StringBuilder parseValueVec(ValueVec elems, BType bType) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < elems.size(); ++i) {
            if (i > 0) {
                res.append(", ");
            }
            Value val = elems.elementAt(i);
            res.append((CharSequence)this.parseValue(val, bType));
        }
        return res;
    }

    private StringBuilder parseEnumerationValue(Value[] a, BType bType) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                res.append(",");
            }
            res.append((CharSequence)this.parseValue(a[i], bType));
        }
        return res;
    }
}

