/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis.unchangedvariables;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AAnySubstitution;
import de.be4.classicalb.core.parser.node.AAssertionSubstitution;
import de.be4.classicalb.core.parser.node.AAssignSubstitution;
import de.be4.classicalb.core.parser.node.ABecomesElementOfSubstitution;
import de.be4.classicalb.core.parser.node.ABecomesSuchSubstitution;
import de.be4.classicalb.core.parser.node.ABlockSubstitution;
import de.be4.classicalb.core.parser.node.AChoiceOrSubstitution;
import de.be4.classicalb.core.parser.node.AChoiceSubstitution;
import de.be4.classicalb.core.parser.node.ADefinitionsMachineClause;
import de.be4.classicalb.core.parser.node.AIfElsifSubstitution;
import de.be4.classicalb.core.parser.node.AIfSubstitution;
import de.be4.classicalb.core.parser.node.AInitialisationMachineClause;
import de.be4.classicalb.core.parser.node.ALetSubstitution;
import de.be4.classicalb.core.parser.node.AOperation;
import de.be4.classicalb.core.parser.node.AParallelSubstitution;
import de.be4.classicalb.core.parser.node.APreconditionSubstitution;
import de.be4.classicalb.core.parser.node.ASelectSubstitution;
import de.be4.classicalb.core.parser.node.ASelectWhenSubstitution;
import de.be4.classicalb.core.parser.node.ASkipSubstitution;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PSubstitution;
import de.tlc4b.analysis.MachineContext;
import de.tlc4b.analysis.unchangedvariables.AssignedVariablesFinder;
import de.tlc4b.exceptions.SubstitutionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;

public class UnchangedVariablesFinder
extends DepthFirstAdapter {
    private final MachineContext machineContext;
    private final Hashtable<Node, HashSet<Node>> assignedIdentifiersTable;
    private final Hashtable<Node, HashSet<Node>> expectedVariablesTable;
    private final Hashtable<Node, HashSet<Node>> expectedOutputParametersTable;
    private final Hashtable<Node, HashSet<Node>> unchangedVariablesTable;
    private final Hashtable<Node, HashSet<Node>> unchangedVariablesNull;

    public HashSet<Node> getUnchangedVariables(Node node) {
        return this.unchangedVariablesTable.get(node);
    }

    public HashSet<Node> getAssignedVariables(Node node) {
        return this.assignedIdentifiersTable.get(node);
    }

    public boolean hasUnchangedVariables(Node node) {
        HashSet<Node> set = this.unchangedVariablesTable.get(node);
        if (set == null) {
            return false;
        }
        return !set.isEmpty();
    }

    public HashSet<Node> getUnchangedVariablesNull(Node node) {
        return this.unchangedVariablesNull.get(node);
    }

    public UnchangedVariablesFinder(MachineContext c) {
        this.machineContext = c;
        AssignedVariablesFinder aVF = new AssignedVariablesFinder(c);
        this.assignedIdentifiersTable = aVF.getAssignedVariablesTable();
        this.expectedVariablesTable = new Hashtable();
        this.expectedOutputParametersTable = new Hashtable();
        this.unchangedVariablesTable = new Hashtable();
        this.unchangedVariablesNull = new Hashtable();
        c.getStartNode().apply(this);
    }

    @Override
    public void caseAInitialisationMachineClause(AInitialisationMachineClause node) {
    }

    @Override
    public void caseADefinitionsMachineClause(ADefinitionsMachineClause node) {
    }

    @Override
    public void caseAOperation(AOperation node) {
        ArrayList<PExpression> returnValues = new ArrayList<PExpression>(node.getReturnValues());
        HashSet<PExpression> expectedOutputParameter = new HashSet<PExpression>(returnValues);
        PSubstitution body = node.getOperationBody();
        this.expectedOutputParametersTable.put(body, expectedOutputParameter);
        this.expectedVariablesTable.put(body, new HashSet<Node>(this.machineContext.getVariables().values()));
        body.apply(this);
    }

    private void check(Node node) {
        HashSet<Node> found = this.assignedIdentifiersTable.get(node);
        HashSet missingVariables = new HashSet(this.expectedVariablesTable.get(node));
        missingVariables.removeAll(found);
        this.unchangedVariablesTable.put(node, missingVariables);
        HashSet missingOutputParameter = new HashSet(this.expectedOutputParametersTable.get(node));
        missingOutputParameter.removeAll(found);
        if (!missingOutputParameter.isEmpty()) {
            throw new SubstitutionException("To the following output parameters no values are assigned: " + missingOutputParameter);
        }
    }

    @Override
    public void caseAAssignSubstitution(AAssignSubstitution node) {
        this.check(node);
    }

    @Override
    public void caseABecomesSuchSubstitution(ABecomesSuchSubstitution node) {
        this.check(node);
    }

    @Override
    public void caseABecomesElementOfSubstitution(ABecomesElementOfSubstitution node) {
        this.check(node);
    }

    @Override
    public void caseAParallelSubstitution(AParallelSubstitution node) {
        this.check(node);
        ArrayList<PSubstitution> copy = new ArrayList<PSubstitution>(node.getSubstitutions());
        for (PSubstitution e : copy) {
            this.expectedOutputParametersTable.put(e, new HashSet());
            this.expectedVariablesTable.put(e, new HashSet());
            e.apply(this);
        }
    }

    @Override
    public void caseAAnySubstitution(AAnySubstitution node) {
        this.check(node);
        this.expectedOutputParametersTable.put(node.getThen(), new HashSet());
        this.expectedVariablesTable.put(node.getThen(), new HashSet());
        node.getThen().apply(this);
    }

    @Override
    public void caseALetSubstitution(ALetSubstitution node) {
        this.check(node);
        this.expectedOutputParametersTable.put(node.getSubstitution(), new HashSet());
        this.expectedVariablesTable.put(node.getSubstitution(), new HashSet());
        node.getSubstitution().apply(this);
    }

    @Override
    public void caseAChoiceSubstitution(AChoiceSubstitution node) {
        this.check(node);
        HashSet<Node> foundIdentifiers = this.assignedIdentifiersTable.get(node);
        HashSet<Node> variables = new HashSet<Node>(foundIdentifiers);
        variables.removeAll((Collection)this.expectedOutputParametersTable.get(node));
        ArrayList<PSubstitution> copy = new ArrayList<PSubstitution>(node.getSubstitutions());
        for (PSubstitution e : copy) {
            this.expectedOutputParametersTable.put(e, this.expectedOutputParametersTable.get(node));
            this.expectedVariablesTable.put(e, variables);
            e.apply(this);
        }
    }

    @Override
    public void caseAChoiceOrSubstitution(AChoiceOrSubstitution node) {
        PSubstitution sub = node.getSubstitution();
        this.expectedOutputParametersTable.put(sub, this.expectedOutputParametersTable.get(node));
        this.expectedVariablesTable.put(sub, this.expectedVariablesTable.get(node));
        sub.apply(this);
        this.unchangedVariablesTable.put(node, this.unchangedVariablesTable.get(sub));
    }

    @Override
    public void caseAIfSubstitution(AIfSubstitution node) {
        this.check(node);
        HashSet<Node> foundIdentifiers = this.assignedIdentifiersTable.get(node);
        HashSet<Node> foundVariables = new HashSet<Node>(foundIdentifiers);
        foundVariables.removeAll((Collection)this.expectedOutputParametersTable.get(node));
        this.expectedOutputParametersTable.put(node.getThen(), this.expectedOutputParametersTable.get(node));
        this.expectedVariablesTable.put(node.getThen(), foundVariables);
        node.getThen().apply(this);
        ArrayList<PSubstitution> copy = new ArrayList<PSubstitution>(node.getElsifSubstitutions());
        for (PSubstitution e : copy) {
            this.expectedOutputParametersTable.put(e, this.expectedOutputParametersTable.get(node));
            this.expectedVariablesTable.put(e, foundVariables);
            e.apply(this);
        }
        if (node.getElse() != null) {
            this.expectedOutputParametersTable.put(node.getElse(), this.expectedOutputParametersTable.get(node));
            this.expectedVariablesTable.put(node.getElse(), foundVariables);
            node.getElse().apply(this);
        } else {
            this.unchangedVariablesNull.put(node, this.assignedIdentifiersTable.get(node.getThen()));
        }
    }

    @Override
    public void caseAIfElsifSubstitution(AIfElsifSubstitution node) {
        this.expectedOutputParametersTable.put(node.getThenSubstitution(), this.expectedOutputParametersTable.get(node));
        this.expectedVariablesTable.put(node.getThenSubstitution(), this.expectedVariablesTable.get(node));
        node.getThenSubstitution().apply(this);
    }

    @Override
    public void caseAPreconditionSubstitution(APreconditionSubstitution node) {
        this.expectedOutputParametersTable.put(node.getSubstitution(), this.expectedOutputParametersTable.get(node));
        this.expectedVariablesTable.put(node.getSubstitution(), this.expectedVariablesTable.get(node));
        node.getSubstitution().apply(this);
    }

    @Override
    public void caseAAssertionSubstitution(AAssertionSubstitution node) {
        this.expectedOutputParametersTable.put(node.getSubstitution(), this.expectedOutputParametersTable.get(node));
        this.expectedVariablesTable.put(node.getSubstitution(), this.expectedVariablesTable.get(node));
        node.getSubstitution().apply(this);
    }

    @Override
    public void caseABlockSubstitution(ABlockSubstitution node) {
        this.expectedOutputParametersTable.put(node.getSubstitution(), this.expectedOutputParametersTable.get(node));
        this.expectedVariablesTable.put(node.getSubstitution(), this.expectedVariablesTable.get(node));
        node.getSubstitution().apply(this);
    }

    @Override
    public void caseASelectSubstitution(ASelectSubstitution node) {
        this.check(node);
        HashSet<Node> foundIdentifiers = this.assignedIdentifiersTable.get(node);
        HashSet<Node> variables = new HashSet<Node>(foundIdentifiers);
        variables.removeAll((Collection)this.expectedOutputParametersTable.get(node));
        this.expectedOutputParametersTable.put(node.getThen(), this.expectedOutputParametersTable.get(node));
        this.expectedVariablesTable.put(node.getThen(), variables);
        node.getThen().apply(this);
        ArrayList<PSubstitution> copy = new ArrayList<PSubstitution>(node.getWhenSubstitutions());
        for (PSubstitution e : copy) {
            this.expectedOutputParametersTable.put(e, this.expectedOutputParametersTable.get(node));
            this.expectedVariablesTable.put(e, variables);
            e.apply(this);
        }
        if (node.getElse() != null) {
            this.expectedOutputParametersTable.put(node.getElse(), this.expectedOutputParametersTable.get(node));
            this.expectedVariablesTable.put(node.getElse(), variables);
            node.getElse().apply(this);
        }
    }

    @Override
    public void caseASelectWhenSubstitution(ASelectWhenSubstitution node) {
        this.check(node);
        this.expectedOutputParametersTable.put(node.getSubstitution(), this.expectedOutputParametersTable.get(node));
        this.expectedVariablesTable.put(node.getSubstitution(), this.expectedVariablesTable.get(node));
        node.getSubstitution().apply(this);
    }

    @Override
    public void caseASkipSubstitution(ASkipSubstitution node) {
        this.check(node);
    }
}

