/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis.unchangedvariables;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.Node;
import de.tlc4b.analysis.MachineContext;
import de.tlc4b.analysis.unchangedvariables.UnchangedVariablesFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;

public class InvariantPreservationAnalysis
extends DepthFirstAdapter {
    protected final Hashtable<Node, HashSet<Node>> foundVariablesTable = new Hashtable();
    private final MachineContext machineContext;
    private final Hashtable<Node, HashSet<Node>> preservingOperationsTable;
    private HashSet<Node> foundVariables;

    public ArrayList<Node> getPreservingOperations(Node invariant) {
        return new ArrayList<Node>((Collection)this.preservingOperationsTable.get(invariant));
    }

    public InvariantPreservationAnalysis(MachineContext machineContext, ArrayList<Node> invariants, UnchangedVariablesFinder unchangedFinder) {
        this.machineContext = machineContext;
        this.preservingOperationsTable = new Hashtable();
        for (Node inv : invariants) {
            this.foundVariables = new HashSet();
            inv.apply(this);
            this.foundVariablesTable.put(inv, this.foundVariables);
        }
        for (Node inv : invariants) {
            HashSet<Node> preservingOperations = new HashSet<Node>();
            HashSet<Node> usedVariables = this.foundVariablesTable.get(inv);
            for (Node op : machineContext.getOperations().values()) {
                HashSet<Node> assignedVariables = unchangedFinder.getAssignedVariables(op);
                HashSet<Node> temp = new HashSet<Node>(usedVariables);
                temp.retainAll(assignedVariables);
                if (!temp.isEmpty()) continue;
                preservingOperations.add(op);
            }
            this.preservingOperationsTable.put(inv, preservingOperations);
        }
    }

    @Override
    public void inAIdentifierExpression(AIdentifierExpression node) {
        Node identifier = this.machineContext.getReferenceNode(node);
        if (this.machineContext.getVariables().containsValue(identifier)) {
            this.foundVariables.add(identifier);
        }
    }
}

