/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AAddExpression;
import de.be4.classicalb.core.parser.node.AAssignSubstitution;
import de.be4.classicalb.core.parser.node.ACardExpression;
import de.be4.classicalb.core.parser.node.AClosureExpression;
import de.be4.classicalb.core.parser.node.ACompositionExpression;
import de.be4.classicalb.core.parser.node.AConcatExpression;
import de.be4.classicalb.core.parser.node.ADefinitionPredicate;
import de.be4.classicalb.core.parser.node.ADirectProductExpression;
import de.be4.classicalb.core.parser.node.ADivExpression;
import de.be4.classicalb.core.parser.node.ADomainExpression;
import de.be4.classicalb.core.parser.node.ADomainRestrictionExpression;
import de.be4.classicalb.core.parser.node.ADomainSubtractionExpression;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AFin1SubsetExpression;
import de.be4.classicalb.core.parser.node.AFinSubsetExpression;
import de.be4.classicalb.core.parser.node.AFirstExpression;
import de.be4.classicalb.core.parser.node.AFirstProjectionExpression;
import de.be4.classicalb.core.parser.node.AFrontExpression;
import de.be4.classicalb.core.parser.node.AFunctionExpression;
import de.be4.classicalb.core.parser.node.AGeneralConcatExpression;
import de.be4.classicalb.core.parser.node.AGeneralIntersectionExpression;
import de.be4.classicalb.core.parser.node.AGeneralProductExpression;
import de.be4.classicalb.core.parser.node.AGeneralSumExpression;
import de.be4.classicalb.core.parser.node.AGreaterEqualPredicate;
import de.be4.classicalb.core.parser.node.AGreaterPredicate;
import de.be4.classicalb.core.parser.node.AIdentityExpression;
import de.be4.classicalb.core.parser.node.AImageExpression;
import de.be4.classicalb.core.parser.node.AInsertFrontExpression;
import de.be4.classicalb.core.parser.node.AIntSetExpression;
import de.be4.classicalb.core.parser.node.AIntegerSetExpression;
import de.be4.classicalb.core.parser.node.AIntervalExpression;
import de.be4.classicalb.core.parser.node.AIseq1Expression;
import de.be4.classicalb.core.parser.node.AIseqExpression;
import de.be4.classicalb.core.parser.node.AIterationExpression;
import de.be4.classicalb.core.parser.node.ALastExpression;
import de.be4.classicalb.core.parser.node.ALessEqualPredicate;
import de.be4.classicalb.core.parser.node.ALessPredicate;
import de.be4.classicalb.core.parser.node.AMaxExpression;
import de.be4.classicalb.core.parser.node.AMinExpression;
import de.be4.classicalb.core.parser.node.AMinIntExpression;
import de.be4.classicalb.core.parser.node.AMinusOrSetSubtractExpression;
import de.be4.classicalb.core.parser.node.AModuloExpression;
import de.be4.classicalb.core.parser.node.AMultOrCartExpression;
import de.be4.classicalb.core.parser.node.ANat1SetExpression;
import de.be4.classicalb.core.parser.node.ANatSetExpression;
import de.be4.classicalb.core.parser.node.ANatural1SetExpression;
import de.be4.classicalb.core.parser.node.ANaturalSetExpression;
import de.be4.classicalb.core.parser.node.ANotSubsetPredicate;
import de.be4.classicalb.core.parser.node.ANotSubsetStrictPredicate;
import de.be4.classicalb.core.parser.node.AOverwriteExpression;
import de.be4.classicalb.core.parser.node.AParallelProductExpression;
import de.be4.classicalb.core.parser.node.APartialBijectionExpression;
import de.be4.classicalb.core.parser.node.APartialFunctionExpression;
import de.be4.classicalb.core.parser.node.APartialInjectionExpression;
import de.be4.classicalb.core.parser.node.APartialSurjectionExpression;
import de.be4.classicalb.core.parser.node.APermExpression;
import de.be4.classicalb.core.parser.node.APow1SubsetExpression;
import de.be4.classicalb.core.parser.node.APowerOfExpression;
import de.be4.classicalb.core.parser.node.APredecessorExpression;
import de.be4.classicalb.core.parser.node.AQuantifiedIntersectionExpression;
import de.be4.classicalb.core.parser.node.AQuantifiedUnionExpression;
import de.be4.classicalb.core.parser.node.ARangeExpression;
import de.be4.classicalb.core.parser.node.ARangeRestrictionExpression;
import de.be4.classicalb.core.parser.node.ARangeSubtractionExpression;
import de.be4.classicalb.core.parser.node.AReflexiveClosureExpression;
import de.be4.classicalb.core.parser.node.ARelationsExpression;
import de.be4.classicalb.core.parser.node.ARestrictFrontExpression;
import de.be4.classicalb.core.parser.node.ARestrictTailExpression;
import de.be4.classicalb.core.parser.node.ARevExpression;
import de.be4.classicalb.core.parser.node.AReverseExpression;
import de.be4.classicalb.core.parser.node.ASecondProjectionExpression;
import de.be4.classicalb.core.parser.node.ASeq1Expression;
import de.be4.classicalb.core.parser.node.ASeqExpression;
import de.be4.classicalb.core.parser.node.ASetExtensionExpression;
import de.be4.classicalb.core.parser.node.ASizeExpression;
import de.be4.classicalb.core.parser.node.ASuccessorExpression;
import de.be4.classicalb.core.parser.node.ATailExpression;
import de.be4.classicalb.core.parser.node.ATotalBijectionExpression;
import de.be4.classicalb.core.parser.node.ATotalFunctionExpression;
import de.be4.classicalb.core.parser.node.ATotalInjectionExpression;
import de.be4.classicalb.core.parser.node.ATotalSurjectionExpression;
import de.be4.classicalb.core.parser.node.ATransFunctionExpression;
import de.be4.classicalb.core.parser.node.ATransRelationExpression;
import de.be4.classicalb.core.parser.node.AUnaryMinusExpression;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PDefinition;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.Start;
import de.tlc4b.TLC4BGlobals;
import de.tlc4b.analysis.StandardModules;
import de.tlc4b.analysis.Typechecker;
import de.tlc4b.analysis.typerestriction.TypeRestrictor;
import de.tlc4b.btypes.BType;
import de.tlc4b.btypes.FunctionType;
import de.tlc4b.btypes.IntegerType;
import de.tlc4b.btypes.SetType;
import de.tlc4b.tla.TLAModule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class UsedStandardModules
extends DepthFirstAdapter {
    private static final ArrayList<StandardModule> modules = new ArrayList();
    private final Set<StandardModule> extendedStandardModules = new HashSet<StandardModule>();
    private final Typechecker typechecker;
    private boolean inAssignment = false;

    public UsedStandardModules(Start start, Typechecker typechecker, TypeRestrictor typeRestrictor, TLAModule tlaModule) {
        ArrayList<PDefinition> definitions;
        this.typechecker = typechecker;
        if (TLC4BGlobals.useSymmetry()) {
            this.extendedStandardModules.add(StandardModule.TLC);
        }
        if ((definitions = tlaModule.getAllDefinitions()) != null) {
            for (PDefinition pDefinition : definitions) {
                pDefinition.apply(this);
            }
        }
        for (Node node : typeRestrictor.getAllRestrictedNodes()) {
            node.apply(this);
        }
        start.apply(this);
    }

    public List<String> getExtendedModules() {
        ArrayList<StandardModule> list = new ArrayList<StandardModule>(this.extendedStandardModules);
        if (list.contains((Object)StandardModule.Integers)) {
            list.remove((Object)StandardModule.Naturals);
        }
        list.sort((s1, s2) -> {
            Integer i1 = modules.indexOf(s1);
            Integer i2 = modules.indexOf(s2);
            return i1.compareTo(i2);
        });
        return list.stream().map(Enum::name).collect(Collectors.toList());
    }

    public Set<String> getStandardModulesToBeCreated() {
        HashSet<StandardModule> res = new HashSet<StandardModule>();
        for (StandardModule module : this.extendedStandardModules) {
            switch (module) {
                case ExternalFunctions: {
                    res.add(StandardModule.ExternalFunctions);
                    break;
                }
                case FunctionsAsRelations: {
                    res.add(StandardModule.FunctionsAsRelations);
                    res.add(StandardModule.Functions);
                    break;
                }
                case SequencesAsRelations: {
                    res.add(StandardModule.SequencesAsRelations);
                    res.add(StandardModule.Relations);
                    res.add(StandardModule.FunctionsAsRelations);
                    res.add(StandardModule.Functions);
                    break;
                }
                case BBuiltIns: {
                    res.add(StandardModule.BBuiltIns);
                    break;
                }
                case Functions: {
                    res.add(StandardModule.Functions);
                    break;
                }
                case Relations: {
                    res.add(StandardModule.Relations);
                    break;
                }
                case Sequences: {
                    break;
                }
                case SequencesExtended: {
                    res.add(StandardModule.SequencesExtended);
                    break;
                }
            }
        }
        return res.stream().map(Enum::name).collect(Collectors.toSet());
    }

    @Override
    public void inAExpressionDefinitionDefinition(AExpressionDefinitionDefinition node) {
        String name;
        if (TLC4BGlobals.isForceTLCToEvalConstants()) {
            this.extendedStandardModules.add(StandardModule.TLC);
        }
        if (StandardModules.isKeywordInModuleExternalFunctions(name = node.getName().getText().trim())) {
            this.extendedStandardModules.add(StandardModule.ExternalFunctions);
        }
    }

    @Override
    public void inADefinitionPredicate(ADefinitionPredicate node) {
        String name = node.getDefLiteral().getText().trim();
        if (StandardModules.isKeywordInModuleExternalFunctions(name)) {
            this.extendedStandardModules.add(StandardModule.ExternalFunctions);
        }
    }

    @Override
    public void caseANaturalSetExpression(ANaturalSetExpression node) {
        this.extendedStandardModules.add(StandardModule.Naturals);
    }

    @Override
    public void caseANatural1SetExpression(ANatural1SetExpression node) {
        this.extendedStandardModules.add(StandardModule.Naturals);
    }

    @Override
    public void caseANatSetExpression(ANatSetExpression node) {
        this.extendedStandardModules.add(StandardModule.Naturals);
    }

    @Override
    public void caseANat1SetExpression(ANat1SetExpression node) {
        this.extendedStandardModules.add(StandardModule.Naturals);
    }

    @Override
    public void inALessEqualPredicate(ALessEqualPredicate node) {
        this.extendedStandardModules.add(StandardModule.Naturals);
    }

    @Override
    public void inALessPredicate(ALessPredicate node) {
        this.extendedStandardModules.add(StandardModule.Naturals);
    }

    @Override
    public void inAGreaterEqualPredicate(AGreaterEqualPredicate node) {
        this.extendedStandardModules.add(StandardModule.Naturals);
    }

    @Override
    public void inAGreaterPredicate(AGreaterPredicate node) {
        this.extendedStandardModules.add(StandardModule.Naturals);
    }

    @Override
    public void inAAddExpression(AAddExpression node) {
        this.extendedStandardModules.add(StandardModule.Naturals);
    }

    @Override
    public void inAIntervalExpression(AIntervalExpression node) {
        this.extendedStandardModules.add(StandardModule.Naturals);
    }

    @Override
    public void inAMinusOrSetSubtractExpression(AMinusOrSetSubtractExpression node) {
        BType t = this.typechecker.getType(node);
        if (t instanceof IntegerType) {
            this.extendedStandardModules.add(StandardModule.Naturals);
        }
    }

    @Override
    public void inAMultOrCartExpression(AMultOrCartExpression node) {
        BType t = this.typechecker.getType(node);
        if (t instanceof IntegerType) {
            this.extendedStandardModules.add(StandardModule.Naturals);
        }
    }

    @Override
    public void inAIntSetExpression(AIntSetExpression node) {
        this.extendedStandardModules.add(StandardModule.Integers);
    }

    @Override
    public void inAIntegerSetExpression(AIntegerSetExpression node) {
        this.extendedStandardModules.add(StandardModule.Integers);
    }

    @Override
    public void inAUnaryMinusExpression(AUnaryMinusExpression node) {
        this.extendedStandardModules.add(StandardModule.Integers);
    }

    @Override
    public void inAMinIntExpression(AMinIntExpression node) {
        this.extendedStandardModules.add(StandardModule.Integers);
    }

    @Override
    public void inACardExpression(ACardExpression node) {
        this.extendedStandardModules.add(StandardModule.FiniteSets);
    }

    @Override
    public void inAPowerOfExpression(APowerOfExpression node) {
        this.extendedStandardModules.add(StandardModule.BBuiltIns);
    }

    @Override
    public void inAMinExpression(AMinExpression node) {
        this.extendedStandardModules.add(StandardModule.BBuiltIns);
    }

    @Override
    public void inAMaxExpression(AMaxExpression node) {
        this.extendedStandardModules.add(StandardModule.BBuiltIns);
    }

    @Override
    public void inAModuloExpression(AModuloExpression node) {
        this.extendedStandardModules.add(StandardModule.BBuiltIns);
    }

    @Override
    public void inADivExpression(ADivExpression node) {
        this.extendedStandardModules.add(StandardModule.BBuiltIns);
    }

    @Override
    public void inAGeneralSumExpression(AGeneralSumExpression node) {
        this.extendedStandardModules.add(StandardModule.BBuiltIns);
    }

    @Override
    public void inAGeneralProductExpression(AGeneralProductExpression node) {
        this.extendedStandardModules.add(StandardModule.BBuiltIns);
    }

    @Override
    public void inASuccessorExpression(ASuccessorExpression node) {
        this.extendedStandardModules.add(StandardModule.BBuiltIns);
    }

    @Override
    public void inAPredecessorExpression(APredecessorExpression node) {
        this.extendedStandardModules.add(StandardModule.BBuiltIns);
    }

    @Override
    public void inAPow1SubsetExpression(APow1SubsetExpression node) {
        this.extendedStandardModules.add(StandardModule.BBuiltIns);
    }

    @Override
    public void inAFinSubsetExpression(AFinSubsetExpression node) {
        this.extendedStandardModules.add(StandardModule.BBuiltIns);
    }

    @Override
    public void inAFin1SubsetExpression(AFin1SubsetExpression node) {
        this.extendedStandardModules.add(StandardModule.BBuiltIns);
    }

    @Override
    public void inANotSubsetPredicate(ANotSubsetPredicate node) {
        this.extendedStandardModules.add(StandardModule.BBuiltIns);
    }

    @Override
    public void inANotSubsetStrictPredicate(ANotSubsetStrictPredicate node) {
        this.extendedStandardModules.add(StandardModule.BBuiltIns);
    }

    @Override
    public void inAGeneralIntersectionExpression(AGeneralIntersectionExpression node) {
        this.extendedStandardModules.add(StandardModule.BBuiltIns);
    }

    @Override
    public void inAQuantifiedIntersectionExpression(AQuantifiedIntersectionExpression node) {
        this.extendedStandardModules.add(StandardModule.BBuiltIns);
    }

    @Override
    public void inAQuantifiedUnionExpression(AQuantifiedUnionExpression node) {
    }

    private void setOfFunctions(Node node) {
        SetType set = (SetType)this.typechecker.getType(node);
        if (set.getSubtype() instanceof FunctionType) {
            this.extendedStandardModules.add(StandardModule.Functions);
        } else {
            this.extendedStandardModules.add(StandardModule.FunctionsAsRelations);
        }
    }

    @Override
    public void inAPartialFunctionExpression(APartialFunctionExpression node) {
        this.setOfFunctions(node);
    }

    @Override
    public void inATotalInjectionExpression(ATotalInjectionExpression node) {
        this.setOfFunctions(node);
    }

    @Override
    public void inAPartialInjectionExpression(APartialInjectionExpression node) {
        this.setOfFunctions(node);
    }

    @Override
    public void inATotalSurjectionExpression(ATotalSurjectionExpression node) {
        this.setOfFunctions(node);
    }

    @Override
    public void inAPartialSurjectionExpression(APartialSurjectionExpression node) {
        this.setOfFunctions(node);
    }

    @Override
    public void inATotalBijectionExpression(ATotalBijectionExpression node) {
        this.setOfFunctions(node);
    }

    @Override
    public void inAPartialBijectionExpression(APartialBijectionExpression node) {
        this.setOfFunctions(node);
    }

    @Override
    public void inAFunctionExpression(AFunctionExpression node) {
        BType type = this.typechecker.getType(node.getIdentifier());
        if (this.inAssignment) {
            if (type instanceof FunctionType) {
                this.extendedStandardModules.add(StandardModule.Functions);
            } else {
                this.extendedStandardModules.add(StandardModule.FunctionsAsRelations);
                this.extendedStandardModules.add(StandardModule.Relations);
            }
        } else if (type instanceof SetType) {
            this.extendedStandardModules.add(StandardModule.FunctionsAsRelations);
        }
    }

    @Override
    public void inATotalFunctionExpression(ATotalFunctionExpression node) {
        SetType type = (SetType)this.typechecker.getType(node);
        if (type.getSubtype() instanceof SetType) {
            this.extendedStandardModules.add(StandardModule.FunctionsAsRelations);
        }
    }

    private void evalFunctionOrRelation(Node node) {
        BType t = this.typechecker.getType(node);
        if (t instanceof FunctionType) {
            this.extendedStandardModules.add(StandardModule.Functions);
        } else {
            this.extendedStandardModules.add(StandardModule.Relations);
        }
    }

    @Override
    public void inARelationsExpression(ARelationsExpression node) {
        this.extendedStandardModules.add(StandardModule.Relations);
    }

    @Override
    public void inADomainExpression(ADomainExpression node) {
        BType t = this.typechecker.getType(node.getExpression());
        if (!(t instanceof FunctionType)) {
            this.extendedStandardModules.add(StandardModule.Relations);
        }
    }

    @Override
    public void inASetExtensionExpression(ASetExtensionExpression node) {
        BType t = this.typechecker.getType(node);
        if (t instanceof FunctionType) {
            this.extendedStandardModules.add(StandardModule.TLC);
        }
    }

    @Override
    public void inARangeExpression(ARangeExpression node) {
        this.evalFunctionOrRelation(node.getExpression());
    }

    @Override
    public void inAImageExpression(AImageExpression node) {
        this.evalFunctionOrRelation(node.getLeft());
    }

    @Override
    public void inAIdentityExpression(AIdentityExpression node) {
        this.evalFunctionOrRelation(node);
    }

    @Override
    public void inADomainRestrictionExpression(ADomainRestrictionExpression node) {
        this.evalFunctionOrRelation(node);
    }

    @Override
    public void inADomainSubtractionExpression(ADomainSubtractionExpression node) {
        this.evalFunctionOrRelation(node);
    }

    @Override
    public void inARangeRestrictionExpression(ARangeRestrictionExpression node) {
        this.evalFunctionOrRelation(node);
    }

    @Override
    public void inARangeSubtractionExpression(ARangeSubtractionExpression node) {
        this.evalFunctionOrRelation(node);
    }

    @Override
    public void inAReverseExpression(AReverseExpression node) {
        this.evalFunctionOrRelation(node.getExpression());
    }

    @Override
    public void inAOverwriteExpression(AOverwriteExpression node) {
        this.evalFunctionOrRelation(node);
    }

    @Override
    public void inAAssignSubstitution(AAssignSubstitution node) {
    }

    @Override
    public void caseAAssignSubstitution(AAssignSubstitution node) {
        this.inAAssignSubstitution(node);
        this.inAssignment = true;
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getLhsExpression());
        for (PExpression e : copy) {
            e.apply(this);
        }
        this.inAssignment = false;
        copy = new ArrayList<PExpression>(node.getRhsExpressions());
        for (PExpression e : copy) {
            e.apply(this);
        }
        this.outAAssignSubstitution(node);
    }

    @Override
    public void inADirectProductExpression(ADirectProductExpression node) {
        this.extendedStandardModules.add(StandardModule.Relations);
    }

    @Override
    public void inAParallelProductExpression(AParallelProductExpression node) {
        this.extendedStandardModules.add(StandardModule.Relations);
    }

    @Override
    public void inACompositionExpression(ACompositionExpression node) {
        this.extendedStandardModules.add(StandardModule.Relations);
    }

    @Override
    public void inAFirstProjectionExpression(AFirstProjectionExpression node) {
        this.extendedStandardModules.add(StandardModule.Relations);
    }

    @Override
    public void inASecondProjectionExpression(ASecondProjectionExpression node) {
        this.extendedStandardModules.add(StandardModule.Relations);
    }

    @Override
    public void inAIterationExpression(AIterationExpression node) {
        this.extendedStandardModules.add(StandardModule.Relations);
    }

    @Override
    public void inAClosureExpression(AClosureExpression node) {
        this.extendedStandardModules.add(StandardModule.Relations);
    }

    @Override
    public void inAReflexiveClosureExpression(AReflexiveClosureExpression node) {
        this.extendedStandardModules.add(StandardModule.Relations);
    }

    @Override
    public void inATransFunctionExpression(ATransFunctionExpression node) {
        this.extendedStandardModules.add(StandardModule.Relations);
    }

    @Override
    public void inATransRelationExpression(ATransRelationExpression node) {
        this.extendedStandardModules.add(StandardModule.Relations);
    }

    @Override
    public void inASeqExpression(ASeqExpression node) {
        SetType type = (SetType)this.typechecker.getType(node);
        if (type.getSubtype() instanceof FunctionType) {
            this.extendedStandardModules.add(StandardModule.Sequences);
        } else {
            this.extendedStandardModules.add(StandardModule.SequencesAsRelations);
        }
    }

    @Override
    public void inASizeExpression(ASizeExpression node) {
        this.evalSequenceOrRelation(node.getExpression());
    }

    @Override
    public void inAConcatExpression(AConcatExpression node) {
        this.evalSequenceOrRelation(node);
    }

    private void evalSequenceOrRelation(Node node) {
        BType type = this.typechecker.getType(node);
        if (type instanceof FunctionType) {
            this.extendedStandardModules.add(StandardModule.Sequences);
        } else {
            this.extendedStandardModules.add(StandardModule.SequencesAsRelations);
        }
    }

    @Override
    public void inAFirstExpression(AFirstExpression node) {
        this.evalSequenceOrRelation(node.getExpression());
    }

    @Override
    public void inATailExpression(ATailExpression node) {
        this.evalSequenceOrRelation(node.getExpression());
    }

    private void evalSequenceExtendedOrRelation(Node node) {
        BType type = this.typechecker.getType(node);
        if (type instanceof FunctionType) {
            this.extendedStandardModules.add(StandardModule.SequencesExtended);
        } else {
            this.extendedStandardModules.add(StandardModule.SequencesAsRelations);
        }
    }

    @Override
    public void inAIseqExpression(AIseqExpression node) {
        SetType set = (SetType)this.typechecker.getType(node);
        if (set.getSubtype() instanceof FunctionType) {
            this.extendedStandardModules.add(StandardModule.SequencesExtended);
        } else {
            this.extendedStandardModules.add(StandardModule.SequencesAsRelations);
        }
    }

    @Override
    public void inASeq1Expression(ASeq1Expression node) {
        SetType set = (SetType)this.typechecker.getType(node);
        if (set.getSubtype() instanceof FunctionType) {
            this.extendedStandardModules.add(StandardModule.SequencesExtended);
        } else {
            this.extendedStandardModules.add(StandardModule.SequencesAsRelations);
        }
    }

    @Override
    public void inAIseq1Expression(AIseq1Expression node) {
        SetType set = (SetType)this.typechecker.getType(node);
        if (set.getSubtype() instanceof FunctionType) {
            this.extendedStandardModules.add(StandardModule.SequencesExtended);
        } else {
            this.extendedStandardModules.add(StandardModule.SequencesAsRelations);
        }
    }

    @Override
    public void inAInsertFrontExpression(AInsertFrontExpression node) {
        this.evalSequenceExtendedOrRelation(node);
    }

    @Override
    public void inALastExpression(ALastExpression node) {
        this.evalSequenceExtendedOrRelation(node.getExpression());
    }

    @Override
    public void inAFrontExpression(AFrontExpression node) {
        this.evalSequenceExtendedOrRelation(node);
    }

    @Override
    public void inAPermExpression(APermExpression node) {
        SetType set = (SetType)this.typechecker.getType(node);
        if (set.getSubtype() instanceof SetType) {
            this.extendedStandardModules.add(StandardModule.SequencesAsRelations);
        } else {
            this.extendedStandardModules.add(StandardModule.SequencesExtended);
        }
    }

    @Override
    public void inARevExpression(ARevExpression node) {
        this.evalSequenceExtendedOrRelation(node);
    }

    @Override
    public void inAGeneralConcatExpression(AGeneralConcatExpression node) {
        this.evalSequenceExtendedOrRelation(node);
    }

    @Override
    public void inARestrictFrontExpression(ARestrictFrontExpression node) {
        this.evalSequenceExtendedOrRelation(node);
    }

    @Override
    public void inARestrictTailExpression(ARestrictTailExpression node) {
        this.evalSequenceExtendedOrRelation(node);
    }

    static {
        modules.add(StandardModule.Naturals);
        modules.add(StandardModule.Integers);
        modules.add(StandardModule.FiniteSets);
        modules.add(StandardModule.Sequences);
        modules.add(StandardModule.TLC);
        modules.add(StandardModule.BBuiltIns);
        modules.add(StandardModule.Relations);
        modules.add(StandardModule.Functions);
        modules.add(StandardModule.FunctionsAsRelations);
        modules.add(StandardModule.SequencesExtended);
        modules.add(StandardModule.SequencesAsRelations);
        modules.add(StandardModule.ExternalFunctions);
    }

    private static enum StandardModule {
        Naturals,
        Integers,
        FiniteSets,
        Sequences,
        TLC,
        BBuiltIns,
        Relations,
        FunctionsAsRelations,
        Functions,
        SequencesExtended,
        SequencesAsRelations,
        ExternalFunctions,
        Foo;

    }
}

