/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.ACaseSubstitution;
import de.be4.classicalb.core.parser.node.ADescriptionExpression;
import de.be4.classicalb.core.parser.node.ADescriptionOperation;
import de.be4.classicalb.core.parser.node.ADescriptionPredicate;
import de.be4.classicalb.core.parser.node.ADescriptionSet;
import de.be4.classicalb.core.parser.node.AExtendsMachineClause;
import de.be4.classicalb.core.parser.node.AFloatSetExpression;
import de.be4.classicalb.core.parser.node.AFreetypesMachineClause;
import de.be4.classicalb.core.parser.node.AIfElsifPredicatePredicate;
import de.be4.classicalb.core.parser.node.AIfPredicatePredicate;
import de.be4.classicalb.core.parser.node.AImplementationMachineParseUnit;
import de.be4.classicalb.core.parser.node.AImportsMachineClause;
import de.be4.classicalb.core.parser.node.AIncludesMachineClause;
import de.be4.classicalb.core.parser.node.ALabelPredicate;
import de.be4.classicalb.core.parser.node.APromotesMachineClause;
import de.be4.classicalb.core.parser.node.ARealExpression;
import de.be4.classicalb.core.parser.node.ARealSetExpression;
import de.be4.classicalb.core.parser.node.ARefinesModelClause;
import de.be4.classicalb.core.parser.node.AVarSubstitution;
import de.be4.classicalb.core.parser.node.AWhileSubstitution;
import de.be4.classicalb.core.parser.node.Node;
import de.tlc4b.exceptions.NotSupportedException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class UnsupportedConstructsFinder
extends DepthFirstAdapter {
    private static final Set<Class<? extends Node>> unsupportedClasses = new HashSet<Class<? extends Node>>();
    private static final List<String> SUM_TYPE;

    private static void add(Class<? extends Node> clazz) {
        unsupportedClasses.add(clazz);
    }

    private String formatClassName(String input) {
        StringWriter out = new StringWriter();
        char[] chars = input.toCharArray();
        for (int i = 1; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isUpperCase(c)) {
                if (i > 1) {
                    out.append('_');
                }
                out.append(Character.toLowerCase(c));
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    @Override
    public void defaultIn(Node node) {
        if (unsupportedClasses.contains(node.getClass())) {
            String className = node.getClass().getSimpleName();
            String formattedName = this.formatClassName(className);
            for (String suffix : SUM_TYPE) {
                if (!formattedName.endsWith("_" + suffix)) continue;
                String shortName = formattedName.substring(0, formattedName.length() - suffix.length() - 1).toUpperCase(Locale.ROOT);
                String[] split = suffix.split("_");
                String type = split[split.length - 1];
                if (type.equals("clause") || type.equals("substitution") || type.equals("expression") || type.equals("predicate")) {
                    throw new NotSupportedException(shortName + " " + type + " is not supported.");
                }
                if (suffix.endsWith("parse_unit")) {
                    throw new NotSupportedException(shortName + " parse unit is not supported.");
                }
                throw new NotSupportedException(shortName + " is not supported.");
            }
            throw new NotSupportedException(className + " is not supported.");
        }
    }

    @Override
    public void caseALabelPredicate(ALabelPredicate node) {
        node.getPredicate().apply(this);
        node.replaceBy(node.getPredicate());
    }

    @Override
    public void caseADescriptionPredicate(ADescriptionPredicate node) {
        node.getPredicate().apply(this);
        node.replaceBy(node.getPredicate());
    }

    @Override
    public void caseADescriptionExpression(ADescriptionExpression node) {
        node.getExpression().apply(this);
        node.replaceBy(node.getExpression());
    }

    @Override
    public void caseADescriptionOperation(ADescriptionOperation node) {
        node.getOperation().apply(this);
        node.replaceBy(node.getOperation());
    }

    @Override
    public void caseADescriptionSet(ADescriptionSet node) {
        node.getSet().apply(this);
        node.replaceBy(node.getSet());
    }

    static {
        UnsupportedConstructsFinder.add(ARefinesModelClause.class);
        UnsupportedConstructsFinder.add(AExtendsMachineClause.class);
        UnsupportedConstructsFinder.add(APromotesMachineClause.class);
        UnsupportedConstructsFinder.add(AIncludesMachineClause.class);
        UnsupportedConstructsFinder.add(AImportsMachineClause.class);
        UnsupportedConstructsFinder.add(AFreetypesMachineClause.class);
        UnsupportedConstructsFinder.add(AWhileSubstitution.class);
        UnsupportedConstructsFinder.add(AVarSubstitution.class);
        UnsupportedConstructsFinder.add(ACaseSubstitution.class);
        UnsupportedConstructsFinder.add(AImplementationMachineParseUnit.class);
        UnsupportedConstructsFinder.add(ARealSetExpression.class);
        UnsupportedConstructsFinder.add(AFloatSetExpression.class);
        UnsupportedConstructsFinder.add(ARealExpression.class);
        UnsupportedConstructsFinder.add(AIfPredicatePredicate.class);
        UnsupportedConstructsFinder.add(AIfElsifPredicatePredicate.class);
        SUM_TYPE = new LinkedList<String>(Arrays.asList("model_clause", "machine_clause", "machine_parse_unit", "substitution", "expression_expression", "expression", "predicate_predicate", "predicate"));
    }
}

