/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AAbstractConstantsMachineClause;
import de.be4.classicalb.core.parser.node.AAbstractMachineParseUnit;
import de.be4.classicalb.core.parser.node.AAnySubstitution;
import de.be4.classicalb.core.parser.node.AAssertionsMachineClause;
import de.be4.classicalb.core.parser.node.AAssignSubstitution;
import de.be4.classicalb.core.parser.node.AComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.AConcreteVariablesMachineClause;
import de.be4.classicalb.core.parser.node.AConstantsMachineClause;
import de.be4.classicalb.core.parser.node.AConstraintsMachineClause;
import de.be4.classicalb.core.parser.node.ADeferredSetSet;
import de.be4.classicalb.core.parser.node.ADefinitionExpression;
import de.be4.classicalb.core.parser.node.ADefinitionPredicate;
import de.be4.classicalb.core.parser.node.ADefinitionSubstitution;
import de.be4.classicalb.core.parser.node.ADefinitionsMachineClause;
import de.be4.classicalb.core.parser.node.AEnumeratedSetSet;
import de.be4.classicalb.core.parser.node.AEventBComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.AExistsPredicate;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AForallPredicate;
import de.be4.classicalb.core.parser.node.AGeneralProductExpression;
import de.be4.classicalb.core.parser.node.AGeneralSumExpression;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AInitialisationMachineClause;
import de.be4.classicalb.core.parser.node.AInvariantMachineClause;
import de.be4.classicalb.core.parser.node.ALambdaExpression;
import de.be4.classicalb.core.parser.node.ALetExpressionExpression;
import de.be4.classicalb.core.parser.node.ALetPredicatePredicate;
import de.be4.classicalb.core.parser.node.ALetSubstitution;
import de.be4.classicalb.core.parser.node.AMachineHeader;
import de.be4.classicalb.core.parser.node.AMachineReferenceNoParams;
import de.be4.classicalb.core.parser.node.AOperation;
import de.be4.classicalb.core.parser.node.AOperationCallSubstitution;
import de.be4.classicalb.core.parser.node.AOperationsMachineClause;
import de.be4.classicalb.core.parser.node.APredicateDefinitionDefinition;
import de.be4.classicalb.core.parser.node.APredicateParseUnit;
import de.be4.classicalb.core.parser.node.APrimedIdentifierExpression;
import de.be4.classicalb.core.parser.node.APropertiesMachineClause;
import de.be4.classicalb.core.parser.node.AQuantifiedIntersectionExpression;
import de.be4.classicalb.core.parser.node.AQuantifiedUnionExpression;
import de.be4.classicalb.core.parser.node.ASeesMachineClause;
import de.be4.classicalb.core.parser.node.ASetsContextClause;
import de.be4.classicalb.core.parser.node.ASubstitutionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AVariablesMachineClause;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PDefinition;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PMachineClause;
import de.be4.classicalb.core.parser.node.PMachineHeader;
import de.be4.classicalb.core.parser.node.PMachineReferenceNoParams;
import de.be4.classicalb.core.parser.node.POperation;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.PSet;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.util.Utils;
import de.tlc4b.MP;
import de.tlc4b.TLC4BGlobals;
import de.tlc4b.analysis.transformation.DefinitionsSorter;
import de.tlc4b.analysis.transformation.MachineClauseSorter;
import de.tlc4b.exceptions.NotSupportedException;
import de.tlc4b.exceptions.ScopeException;
import de.tlc4b.ltl.LTLBPredicate;
import de.tlc4b.ltl.LTLFormulaVisitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MachineContext
extends DepthFirstAdapter {
    private String machineName;
    private final Start start;
    private final ArrayList<LTLFormulaVisitor> ltlVisitors;
    private PPredicate constantsSetupPredicate;
    private boolean hasConstants = false;
    private final LinkedHashMap<String, Node> machineSetParameter;
    private final LinkedHashMap<String, Node> machineScalarParameter;
    private final LinkedHashMap<String, Node> deferredSets;
    private final LinkedHashMap<String, Node> enumeratedSets;
    private final LinkedHashMap<String, Node> enumValues;
    private final LinkedHashMap<String, Node> variables;
    private final LinkedHashMap<String, Node> constants;
    private final LinkedHashMap<String, Node> definitions;
    private final LinkedHashMap<String, Node> operations;
    private final LinkedHashMap<String, AMachineReferenceNoParams> seenMachines;
    private PMachineHeader header;
    private AAbstractMachineParseUnit abstractMachineParseUnit;
    private AConstraintsMachineClause constraintMachineClause;
    private ASeesMachineClause seesMachineClause;
    private ASetsContextClause setsMachineClause;
    private ADefinitionsMachineClause definitionMachineClause;
    private APropertiesMachineClause propertiesMachineClause;
    private AInvariantMachineClause invariantMachineClause;
    private AInitialisationMachineClause initialisationMachineClause;
    private AOperationsMachineClause operationMachineClause;
    private AAssertionsMachineClause assertionsMachineClause;
    private List<Map<String, Node>> contextTable;
    protected final Hashtable<Node, Node> referencesTable;

    public MachineContext(String machineName, Start start) {
        this.start = start;
        this.machineName = machineName;
        this.referencesTable = new Hashtable();
        this.ltlVisitors = new ArrayList();
        this.machineSetParameter = new LinkedHashMap();
        this.machineScalarParameter = new LinkedHashMap();
        this.deferredSets = new LinkedHashMap();
        this.enumeratedSets = new LinkedHashMap();
        this.enumValues = new LinkedHashMap();
        this.constants = new LinkedHashMap();
        this.variables = new LinkedHashMap();
        this.definitions = new LinkedHashMap();
        this.operations = new LinkedHashMap();
        this.seenMachines = new LinkedHashMap();
    }

    public void analyseMachine() {
        this.start.apply(this);
        this.checkConstantsSetup();
        this.checkLTLFormulas();
    }

    public void addLTLFormula(String ltlFormula) {
        LTLFormulaVisitor ltlVisitor = new LTLFormulaVisitor("ltl", this);
        ltlVisitor.parseLTLString(ltlFormula);
        this.ltlVisitors.add(ltlVisitor);
    }

    public void setConstantSetupPredicate(PPredicate constantsSetup) {
        this.constantsSetupPredicate = constantsSetup;
    }

    private void checkConstantsSetup() {
        if (this.constantsSetupPredicate == null) {
            return;
        }
        this.contextTable = new ArrayList<Map<String, Node>>();
        ArrayList<MachineContext> list = this.lookupReferencedMachines();
        for (MachineContext s : list) {
            this.contextTable.add(s.getDeferredSets());
            this.contextTable.add(s.getEnumeratedSets());
            this.contextTable.add(s.getEnumValues());
            this.contextTable.add(s.getConstants());
            this.contextTable.add(s.getDefinitions());
        }
        this.constantsSetupPredicate.apply(this);
    }

    private void checkLTLFormulas() {
        if (this.ltlVisitors.size() == 1) {
            this.ltlVisitors.get(0).start();
            return;
        }
        ArrayList<LTLFormulaVisitor> formulasNotSupportedByTLC = new ArrayList<LTLFormulaVisitor>();
        for (LTLFormulaVisitor visitor : this.ltlVisitors) {
            try {
                visitor.start();
            }
            catch (ScopeException e) {
                MP.println("Warning: LTL formula '" + visitor.getName() + "' cannot be checked by TLC.");
                formulasNotSupportedByTLC.add(visitor);
            }
        }
        this.ltlVisitors.removeAll(formulasNotSupportedByTLC);
    }

    public void checkLTLBPredicate(LTLBPredicate ltlbPredicate) {
        this.contextTable = new ArrayList<Map<String, Node>>();
        this.contextTable.add(this.getDeferredSets());
        this.contextTable.add(this.getEnumeratedSets());
        this.contextTable.add(this.getEnumValues());
        this.contextTable.add(this.getConstants());
        this.contextTable.add(this.getVariables());
        this.contextTable.add(this.getDefinitions());
        LinkedHashMap<String, Node> identifierHashTable = ltlbPredicate.getIdentifierList();
        if (!identifierHashTable.isEmpty()) {
            LinkedHashMap<String, Node> currentContext = new LinkedHashMap<String, Node>(identifierHashTable);
            this.contextTable.add(currentContext);
        }
        ltlbPredicate.getBFormula().apply(this);
    }

    private void exist(LinkedList<TIdentifierLiteral> list) {
        String name = Utils.getTIdentifierListAsString(list);
        this.identifierAlreadyExists(name);
    }

    private void identifierAlreadyExists(String name) {
        if (this.constants.containsKey(name) || this.variables.containsKey(name) || this.operations.containsKey(name) || this.deferredSets.containsKey(name) || this.enumeratedSets.containsKey(name) || this.enumValues.containsKey(name) || this.machineSetParameter.containsKey(name) || this.machineScalarParameter.containsKey(name) || this.seenMachines.containsKey(name) || this.definitions.containsKey(name)) {
            throw new ScopeException("Duplicate identifier: '" + name + "'");
        }
    }

    @Override
    public void caseAAbstractMachineParseUnit(AAbstractMachineParseUnit node) {
        this.abstractMachineParseUnit = node;
        if (node.getVariant() != null) {
            node.getVariant().apply(this);
        }
        if (node.getHeader() != null) {
            node.getHeader().apply(this);
        }
        LinkedList<PMachineClause> machineClauses = node.getMachineClauses();
        MachineClauseSorter.sortMachineClauses(this.start);
        for (PMachineClause e : machineClauses) {
            e.apply(this);
        }
    }

    @Override
    public void caseAMachineHeader(AMachineHeader node) {
        this.header = node;
        if (this.machineName == null) {
            ArrayList<TIdentifierLiteral> nameList = new ArrayList<TIdentifierLiteral>(node.getName());
            this.machineName = Utils.getTIdentifierListAsString(nameList);
        }
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getParameters());
        for (PExpression e : copy) {
            AIdentifierExpression p = (AIdentifierExpression)e;
            String name = Utils.getTIdentifierListAsString(p.getIdentifier());
            this.exist(p.getIdentifier());
            if (Character.isUpperCase(name.charAt(0))) {
                this.machineSetParameter.put(name, p);
                continue;
            }
            this.machineScalarParameter.put(name, p);
        }
    }

    @Override
    public void caseAPredicateParseUnit(APredicateParseUnit node) {
        node.getPredicate().apply(this);
    }

    @Override
    public void caseADefinitionsMachineClause(ADefinitionsMachineClause node) {
        this.definitionMachineClause = node;
        DefinitionsSorter.sortDefinitions(node);
        LinkedList<PDefinition> copy = node.getDefinitions();
        HashSet<AExpressionDefinitionDefinition> definitionsToRemove = new HashSet<AExpressionDefinitionDefinition>();
        for (PDefinition e : copy) {
            if (e instanceof AExpressionDefinitionDefinition) {
                AExpressionDefinitionDefinition def = (AExpressionDefinitionDefinition)e;
                String name = def.getName().getText();
                if (name.startsWith("ASSERT_LTL")) {
                    if (TLC4BGlobals.isCheckLTL()) {
                        LTLFormulaVisitor visitor = new LTLFormulaVisitor(name, this);
                        visitor.parseDefinition(def);
                        this.ltlVisitors.add(visitor);
                    }
                    definitionsToRemove.add(def);
                } else if (name.startsWith("ANIMATION_")) {
                    definitionsToRemove.add(def);
                }
                this.evalDefinitionName(((AExpressionDefinitionDefinition)e).getName().getText(), e);
                continue;
            }
            if (e instanceof APredicateDefinitionDefinition) {
                this.evalDefinitionName(((APredicateDefinitionDefinition)e).getName().getText(), e);
                continue;
            }
            if (!(e instanceof ASubstitutionDefinitionDefinition)) continue;
            this.evalDefinitionName(((ASubstitutionDefinitionDefinition)e).getName().getText(), e);
        }
        copy.removeAll(definitionsToRemove);
        this.contextTable = new ArrayList<Map<String, Node>>();
        ArrayList<MachineContext> list = this.lookupReferencedMachines();
        for (MachineContext s : list) {
            this.contextTable.add(s.getDeferredSets());
            this.contextTable.add(s.getEnumeratedSets());
            this.contextTable.add(s.getEnumValues());
            this.contextTable.add(s.getConstants());
            this.contextTable.add(s.getVariables());
            this.contextTable.add(s.getDefinitions());
        }
        for (PDefinition e : copy) {
            e.apply(this);
        }
    }

    private void evalDefinitionName(String name, Node node) {
        this.identifierAlreadyExists(name);
        this.definitions.put(name, node);
    }

    @Override
    public void caseAExpressionDefinitionDefinition(AExpressionDefinitionDefinition node) {
        this.visitBDefinition(node, node.getName().getText(), node.getParameters(), node.getRhs());
    }

    @Override
    public void caseAPredicateDefinitionDefinition(APredicateDefinitionDefinition node) {
        this.visitBDefinition(node, node.getName().getText(), node.getParameters(), node.getRhs());
    }

    @Override
    public void caseASubstitutionDefinitionDefinition(ASubstitutionDefinitionDefinition node) {
        this.visitBDefinition(node, node.getName().getText(), node.getParameters(), node.getRhs());
    }

    public void visitBDefinition(Node node, String name, List<PExpression> copy, Node rightSide) {
        if (!this.definitions.containsValue(node)) {
            return;
        }
        this.contextTable.add(new LinkedHashMap());
        for (PExpression e : copy) {
            this.putLocalVariableIntoCurrentScope((AIdentifierExpression)e);
        }
        rightSide.apply(this);
        this.contextTable.remove(this.contextTable.size() - 1);
    }

    @Override
    public void caseADefinitionExpression(ADefinitionExpression node) {
        this.visitBDefinitionCall(node, node.getDefLiteral().getText(), node.getParameters());
    }

    @Override
    public void caseADefinitionPredicate(ADefinitionPredicate node) {
        this.visitBDefinitionCall(node, node.getDefLiteral().getText(), node.getParameters());
    }

    @Override
    public void caseADefinitionSubstitution(ADefinitionSubstitution node) {
        this.visitBDefinitionCall(node, node.getDefLiteral().getText(), node.getParameters());
    }

    private void visitBDefinitionCall(Node node, String name, List<PExpression> copy) {
        for (PExpression pExpression : copy) {
            pExpression.apply(this);
        }
        for (int i = this.contextTable.size() - 1; i >= 0; --i) {
            Map<String, Node> currentScope = this.contextTable.get(i);
            if (!currentScope.containsKey(name)) continue;
            this.referencesTable.put(node, currentScope.get(name));
            return;
        }
        throw new ScopeException("Unknown definition: '" + name + "' at position: " + node.getStartPos());
    }

    @Override
    public void caseASeesMachineClause(ASeesMachineClause node) {
        this.seesMachineClause = node;
        for (PMachineReferenceNoParams e : new ArrayList<PMachineReferenceNoParams>(node.getMachineNames())) {
            AMachineReferenceNoParams p = (AMachineReferenceNoParams)e;
            String name = Utils.getTIdentifierListAsString(p.getMachineName());
            try {
                this.identifierAlreadyExists(name);
            }
            catch (ScopeException e2) {
                throw new ScopeException("Machine '" + name + "' is seen twice.", e2);
            }
            this.seenMachines.put(name, p);
        }
    }

    @Override
    public void caseASetsContextClause(ASetsContextClause node) {
        this.setsMachineClause = node;
        ArrayList<PSet> copy = new ArrayList<PSet>(node.getSet());
        for (PSet e : copy) {
            e.apply(this);
        }
    }

    @Override
    public void caseADeferredSetSet(ADeferredSetSet node) {
        ArrayList<TIdentifierLiteral> copy = new ArrayList<TIdentifierLiteral>(node.getIdentifier());
        String name = Utils.getTIdentifierListAsString(copy);
        this.exist(node.getIdentifier());
        this.deferredSets.put(name, node);
    }

    @Override
    public void caseAEnumeratedSetSet(AEnumeratedSetSet node) {
        ArrayList<TIdentifierLiteral> copy = new ArrayList<TIdentifierLiteral>(node.getIdentifier());
        String name = Utils.getTIdentifierListAsString(copy);
        this.exist(node.getIdentifier());
        this.enumeratedSets.put(name, node);
        this.extractIdentifierExpressions(new ArrayList<PExpression>(node.getElements()), this.enumValues);
    }

    @Override
    public void caseAConstantsMachineClause(AConstantsMachineClause node) {
        this.hasConstants = true;
        this.extractIdentifierExpressions(new ArrayList<PExpression>(node.getIdentifiers()), this.constants);
    }

    @Override
    public void caseAAbstractConstantsMachineClause(AAbstractConstantsMachineClause node) {
        this.hasConstants = true;
        this.extractIdentifierExpressions(new ArrayList<PExpression>(node.getIdentifiers()), this.constants);
    }

    @Override
    public void caseAVariablesMachineClause(AVariablesMachineClause node) {
        this.extractIdentifierExpressions(new ArrayList<PExpression>(node.getIdentifiers()), this.variables);
    }

    @Override
    public void caseAConcreteVariablesMachineClause(AConcreteVariablesMachineClause node) {
        this.extractIdentifierExpressions(new ArrayList<PExpression>(node.getIdentifiers()), this.variables);
    }

    private void extractIdentifierExpressions(List<PExpression> copy, Map<String, Node> addToMap) {
        for (PExpression e : copy) {
            AIdentifierExpression identifier = (AIdentifierExpression)e;
            String name = Utils.getTIdentifierListAsString(identifier.getIdentifier());
            this.exist(identifier.getIdentifier());
            addToMap.put(name, identifier);
        }
    }

    private void putLocalVariableIntoCurrentScope(AIdentifierExpression node) throws ScopeException {
        String name = Utils.getTIdentifierListAsString(node.getIdentifier());
        Map<String, Node> currentScope = this.contextTable.get(this.contextTable.size() - 1);
        if (currentScope.containsKey(name)) {
            throw new ScopeException("Duplicate Identifier: " + name);
        }
        currentScope.put(name, node);
    }

    @Override
    public void caseAIdentifierExpression(AIdentifierExpression node) {
        String name = Utils.getTIdentifierListAsString(node.getIdentifier());
        for (int i = this.contextTable.size() - 1; i >= 0; --i) {
            Map<String, Node> currentScope = this.contextTable.get(i);
            if (!currentScope.containsKey(name)) continue;
            this.referencesTable.put(node, currentScope.get(name));
            return;
        }
        throw new ScopeException("Unknown Identifier: '" + name + "' at position: " + node.getStartPos());
    }

    @Override
    public void caseAPrimedIdentifierExpression(APrimedIdentifierExpression node) {
        String name = Utils.getTIdentifierListAsString(node.getIdentifier());
        for (int i = this.contextTable.size() - 1; i >= 0; --i) {
            Map<String, Node> currentScope = this.contextTable.get(i);
            if (!currentScope.containsKey(name)) continue;
            this.referencesTable.put(node, currentScope.get(name));
            return;
        }
        throw new ScopeException("Unknown Identifier: '" + name + "' at position: " + node.getStartPos());
    }

    private ArrayList<MachineContext> lookupReferencedMachines() {
        ArrayList<MachineContext> list = new ArrayList<MachineContext>();
        list.add(this);
        return list;
    }

    @Override
    public void caseAConstraintsMachineClause(AConstraintsMachineClause node) {
        this.constraintMachineClause = node;
        this.contextTable = new ArrayList<Map<String, Node>>();
        this.contextTable.add(this.machineScalarParameter);
        this.contextTable.add(this.machineSetParameter);
        if (node.getPredicates() != null) {
            node.getPredicates().apply(this);
        }
    }

    @Override
    public void caseAPropertiesMachineClause(APropertiesMachineClause node) {
        this.propertiesMachineClause = node;
        this.hasConstants = true;
        this.contextTable = new ArrayList<Map<String, Node>>();
        ArrayList<MachineContext> list = this.lookupReferencedMachines();
        for (MachineContext s : list) {
            this.contextTable.add(s.getDeferredSets());
            this.contextTable.add(s.getEnumeratedSets());
            this.contextTable.add(s.getEnumValues());
            this.contextTable.add(s.getConstants());
            this.contextTable.add(s.getDefinitions());
        }
        if (node.getPredicates() != null) {
            node.getPredicates().apply(this);
        }
    }

    @Override
    public void caseAInvariantMachineClause(AInvariantMachineClause node) {
        this.invariantMachineClause = node;
        this.contextTable = new ArrayList<Map<String, Node>>();
        ArrayList<MachineContext> list = this.lookupReferencedMachines();
        for (MachineContext s : list) {
            this.contextTable.add(s.getSetParameter());
            this.contextTable.add(s.getScalarParameter());
            this.contextTable.add(s.getDeferredSets());
            this.contextTable.add(s.getEnumeratedSets());
            this.contextTable.add(s.getEnumValues());
            this.contextTable.add(s.getConstants());
            this.contextTable.add(s.getDefinitions());
            this.contextTable.add(s.getVariables());
        }
        node.getPredicates().apply(this);
    }

    @Override
    public void caseAAssertionsMachineClause(AAssertionsMachineClause node) {
        this.assertionsMachineClause = node;
        this.contextTable = new ArrayList<Map<String, Node>>();
        ArrayList<MachineContext> list = this.lookupReferencedMachines();
        for (MachineContext s : list) {
            this.contextTable.add(s.getSetParameter());
            this.contextTable.add(s.getScalarParameter());
            this.contextTable.add(s.getDeferredSets());
            this.contextTable.add(s.getEnumeratedSets());
            this.contextTable.add(s.getEnumValues());
            this.contextTable.add(s.getConstants());
            this.contextTable.add(s.getDefinitions());
            this.contextTable.add(s.getVariables());
        }
        ArrayList<PPredicate> copy = new ArrayList<PPredicate>(node.getPredicates());
        for (PPredicate e : copy) {
            e.apply(this);
        }
    }

    @Override
    public void caseAInitialisationMachineClause(AInitialisationMachineClause node) {
        this.initialisationMachineClause = node;
        this.contextTable = new ArrayList<Map<String, Node>>();
        ArrayList<MachineContext> list = this.lookupReferencedMachines();
        for (MachineContext s : list) {
            this.contextTable.add(s.getSetParameter());
            this.contextTable.add(s.getScalarParameter());
            this.contextTable.add(s.getDeferredSets());
            this.contextTable.add(s.getEnumeratedSets());
            this.contextTable.add(s.getEnumValues());
            this.contextTable.add(s.getConstants());
            this.contextTable.add(s.getDefinitions());
            this.contextTable.add(s.getVariables());
        }
        if (node.getSubstitutions() != null) {
            node.getSubstitutions().apply(this);
        }
    }

    @Override
    public void caseAOperationsMachineClause(AOperationsMachineClause node) {
        this.operationMachineClause = node;
        this.contextTable = new ArrayList<Map<String, Node>>();
        ArrayList<MachineContext> list = this.lookupReferencedMachines();
        for (MachineContext s : list) {
            this.contextTable.add(s.getSetParameter());
            this.contextTable.add(s.getScalarParameter());
            this.contextTable.add(s.getDeferredSets());
            this.contextTable.add(s.getEnumeratedSets());
            this.contextTable.add(s.getEnumValues());
            this.contextTable.add(s.getConstants());
            this.contextTable.add(s.getDefinitions());
            this.contextTable.add(s.getVariables());
        }
        ArrayList<POperation> copy = new ArrayList<POperation>(node.getOperations());
        for (POperation e : copy) {
            AOperation op = (AOperation)e;
            String name = Utils.getTIdentifierListAsString(op.getOpName());
            if (this.operations.containsKey(name)) {
                throw new ScopeException(String.format("Duplicate operation: '%s'", name));
            }
            this.operations.put(name, op);
        }
        for (POperation e : copy) {
            e.apply(this);
        }
    }

    @Override
    public void caseAOperation(AOperation node) {
        AIdentifierExpression id;
        this.contextTable.add(new LinkedHashMap());
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getReturnValues());
        for (PExpression e : copy) {
            id = (AIdentifierExpression)e;
            this.exist(id.getIdentifier());
            this.putLocalVariableIntoCurrentScope((AIdentifierExpression)e);
        }
        copy = new ArrayList<PExpression>(node.getParameters());
        for (PExpression e : copy) {
            id = (AIdentifierExpression)e;
            this.exist(id.getIdentifier());
            this.putLocalVariableIntoCurrentScope((AIdentifierExpression)e);
        }
        if (node.getOperationBody() != null) {
            node.getOperationBody().apply(this);
        }
        this.contextTable.remove(this.contextTable.size() - 1);
    }

    @Override
    public void caseAAssignSubstitution(AAssignSubstitution node) {
        super.caseAAssignSubstitution(node);
    }

    @Override
    public void caseALetSubstitution(ALetSubstitution node) {
        this.contextTable.add(new LinkedHashMap());
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            this.putLocalVariableIntoCurrentScope((AIdentifierExpression)e);
        }
        node.getPredicate().apply(this);
        node.getSubstitution().apply(this);
        this.contextTable.remove(this.contextTable.size() - 1);
    }

    @Override
    public void caseALetExpressionExpression(ALetExpressionExpression node) {
        this.contextTable.add(new LinkedHashMap());
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            this.putLocalVariableIntoCurrentScope((AIdentifierExpression)e);
        }
        node.getAssignment().apply(this);
        node.getExpr().apply(this);
        this.contextTable.remove(this.contextTable.size() - 1);
    }

    @Override
    public void caseALetPredicatePredicate(ALetPredicatePredicate node) {
        this.contextTable.add(new LinkedHashMap());
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            this.putLocalVariableIntoCurrentScope((AIdentifierExpression)e);
        }
        node.getAssignment().apply(this);
        node.getPred().apply(this);
        this.contextTable.remove(this.contextTable.size() - 1);
    }

    @Override
    public void caseAAnySubstitution(AAnySubstitution node) {
        this.contextTable.add(new LinkedHashMap());
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            this.putLocalVariableIntoCurrentScope((AIdentifierExpression)e);
        }
        node.getWhere().apply(this);
        node.getThen().apply(this);
        this.contextTable.remove(this.contextTable.size() - 1);
    }

    @Override
    public void caseAOperationCallSubstitution(AOperationCallSubstitution node) {
        if (!node.getResultIdentifiers().isEmpty()) {
            throw new NotSupportedException("Operation calls with return values are not supported.");
        }
        String name = Utils.getTIdentifierListAsString(node.getOperation());
        Node o = this.operations.get(name);
        if (o == null) {
            throw new ScopeException("Unknown operation '" + name + "'");
        }
        AIdentifierExpression op = new AIdentifierExpression(node.getOperation().stream().map(TIdentifierLiteral::clone).collect(Collectors.toList()));
        this.referencesTable.put(op, o);
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getParameters());
        for (PExpression e : copy) {
            e.apply(this);
        }
    }

    @Override
    public void caseAForallPredicate(AForallPredicate node) {
        this.contextTable.add(new LinkedHashMap());
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            this.putLocalVariableIntoCurrentScope((AIdentifierExpression)e);
        }
        if (node.getImplication() != null) {
            node.getImplication().apply(this);
        }
        this.contextTable.remove(this.contextTable.size() - 1);
    }

    @Override
    public void caseAExistsPredicate(AExistsPredicate node) {
        this.contextTable.add(new LinkedHashMap());
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            this.putLocalVariableIntoCurrentScope((AIdentifierExpression)e);
        }
        if (node.getPredicate() != null) {
            node.getPredicate().apply(this);
        }
        this.contextTable.remove(this.contextTable.size() - 1);
    }

    @Override
    public void caseALambdaExpression(ALambdaExpression node) {
        this.contextTable.add(new LinkedHashMap());
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            this.putLocalVariableIntoCurrentScope((AIdentifierExpression)e);
        }
        node.getPredicate().apply(this);
        node.getExpression().apply(this);
        this.contextTable.remove(this.contextTable.size() - 1);
    }

    @Override
    public void caseAComprehensionSetExpression(AComprehensionSetExpression node) {
        this.contextTable.add(new LinkedHashMap());
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            this.putLocalVariableIntoCurrentScope((AIdentifierExpression)e);
        }
        node.getPredicates().apply(this);
        this.contextTable.remove(this.contextTable.size() - 1);
    }

    @Override
    public void caseAEventBComprehensionSetExpression(AEventBComprehensionSetExpression node) {
        this.contextTable.add(new LinkedHashMap());
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            this.putLocalVariableIntoCurrentScope((AIdentifierExpression)e);
        }
        node.getPredicates().apply(this);
        node.getExpression().apply(this);
        this.contextTable.remove(this.contextTable.size() - 1);
    }

    @Override
    public void caseAQuantifiedUnionExpression(AQuantifiedUnionExpression node) {
        this.contextTable.add(new LinkedHashMap());
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            this.putLocalVariableIntoCurrentScope((AIdentifierExpression)e);
        }
        if (node.getPredicates() != null) {
            node.getPredicates().apply(this);
        }
        if (node.getExpression() != null) {
            node.getExpression().apply(this);
        }
        this.contextTable.remove(this.contextTable.size() - 1);
    }

    @Override
    public void caseAQuantifiedIntersectionExpression(AQuantifiedIntersectionExpression node) {
        this.contextTable.add(new LinkedHashMap());
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            this.putLocalVariableIntoCurrentScope((AIdentifierExpression)e);
        }
        if (node.getPredicates() != null) {
            node.getPredicates().apply(this);
        }
        if (node.getExpression() != null) {
            node.getExpression().apply(this);
        }
        this.contextTable.remove(this.contextTable.size() - 1);
    }

    @Override
    public void caseAGeneralProductExpression(AGeneralProductExpression node) {
        this.contextTable.add(new LinkedHashMap());
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            this.putLocalVariableIntoCurrentScope((AIdentifierExpression)e);
        }
        if (node.getPredicates() != null) {
            node.getPredicates().apply(this);
        }
        if (node.getExpression() != null) {
            node.getExpression().apply(this);
        }
        this.contextTable.remove(this.contextTable.size() - 1);
    }

    @Override
    public void caseAGeneralSumExpression(AGeneralSumExpression node) {
        this.contextTable.add(new LinkedHashMap());
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (PExpression e : copy) {
            this.putLocalVariableIntoCurrentScope((AIdentifierExpression)e);
        }
        if (node.getPredicates() != null) {
            node.getPredicates().apply(this);
        }
        if (node.getExpression() != null) {
            node.getExpression().apply(this);
        }
        this.contextTable.remove(this.contextTable.size() - 1);
    }

    public String getMachineName() {
        return this.machineName;
    }

    public PMachineHeader getHeader() {
        return this.header;
    }

    public Start getStartNode() {
        return this.start;
    }

    public LinkedHashMap<String, Node> getSetParameter() {
        return new LinkedHashMap<String, Node>(this.machineSetParameter);
    }

    public ArrayList<Node> getConstantArrayList() {
        ArrayList<Node> list = new ArrayList<Node>();
        for (Map.Entry<String, Node> entry : this.constants.entrySet()) {
            list.add(entry.getValue());
        }
        return list;
    }

    public LinkedHashMap<String, Node> getScalarParameter() {
        return new LinkedHashMap<String, Node>(this.machineScalarParameter);
    }

    public LinkedHashMap<String, Node> getConstants() {
        return this.constants;
    }

    public LinkedHashMap<String, Node> getDefinitions() {
        return new LinkedHashMap<String, Node>(this.definitions);
    }

    public LinkedHashMap<String, Node> getVariables() {
        return new LinkedHashMap<String, Node>(this.variables);
    }

    public LinkedHashMap<String, Node> getOperations() {
        return new LinkedHashMap<String, Node>(this.operations);
    }

    public LinkedHashMap<String, Node> getDeferredSets() {
        return new LinkedHashMap<String, Node>(this.deferredSets);
    }

    public LinkedHashMap<String, Node> getEnumeratedSets() {
        return new LinkedHashMap<String, Node>(this.enumeratedSets);
    }

    public LinkedHashMap<String, Node> getEnumValues() {
        return new LinkedHashMap<String, Node>(this.enumValues);
    }

    public LinkedHashMap<String, AMachineReferenceNoParams> getSeenMachines() {
        return new LinkedHashMap<String, AMachineReferenceNoParams>(this.seenMachines);
    }

    protected Hashtable<Node, Node> getReferences() {
        return this.referencesTable;
    }

    public Node getReferenceNode(Node node) {
        return this.referencesTable.get(node);
    }

    public void addReference(Node node, Node ref) {
        this.referencesTable.put(node, ref);
    }

    public ArrayList<LTLFormulaVisitor> getLTLFormulas() {
        return this.ltlVisitors;
    }

    public AAbstractMachineParseUnit getAbstractMachineParseUnit() {
        return this.abstractMachineParseUnit;
    }

    public AConstraintsMachineClause getConstraintMachineClause() {
        return this.constraintMachineClause;
    }

    public ASeesMachineClause getSeesMachineClause() {
        return this.seesMachineClause;
    }

    public ASetsContextClause getSetsMachineClause() {
        return this.setsMachineClause;
    }

    public APropertiesMachineClause getPropertiesMachineClause() {
        return this.propertiesMachineClause;
    }

    public AAssertionsMachineClause getAssertionMachineClause() {
        return this.assertionsMachineClause;
    }

    public void setPropertiesMachineClaus(APropertiesMachineClause propertiesMachineClause) {
        this.propertiesMachineClause = propertiesMachineClause;
    }

    public AInvariantMachineClause getInvariantMachineClause() {
        return this.invariantMachineClause;
    }

    public boolean machineContainsOperations() {
        return !this.operations.isEmpty();
    }

    public AInitialisationMachineClause getInitialisationMachineClause() {
        return this.initialisationMachineClause;
    }

    public AOperationsMachineClause getOperationMachineClause() {
        return this.operationMachineClause;
    }

    public ADefinitionsMachineClause getDefinitionMachineClause() {
        return this.definitionMachineClause;
    }

    public void setDefinitionsMachineClause(ADefinitionsMachineClause definitionMachineClause) {
        this.definitionMachineClause = definitionMachineClause;
    }

    public PPredicate getConstantsSetup() {
        return this.constantsSetupPredicate;
    }

    public boolean hasConstants() {
        return this.hasConstants;
    }
}

