/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b;

import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.tlc4b.MP;
import de.tlc4b.TLC4BGlobals;
import de.tlc4b.TLC4BOption;
import de.tlc4b.TLCRunner;
import de.tlc4b.Translator;
import de.tlc4b.exceptions.TLC4BException;
import de.tlc4b.exceptions.TLC4BIOException;
import de.tlc4b.exceptions.TranslationException;
import de.tlc4b.tlc.TLCOutputInfo;
import de.tlc4b.tlc.TLCResults;
import de.tlc4b.util.StopWatch;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class TLC4B {
    private static final String CSV_DELIMITER = ";";
    private File mainfile;
    private File traceFile;
    private String machineFileNameWithoutFileExtension;
    private File logFile;
    private File buildDir;
    private String tlaModule;
    private String config;
    private Translator translator;
    private TLCOutputInfo tlcOutputInfo;
    private String ltlFormula;
    private String constantsSetup;

    public static void main(String[] args) {
        try {
            TLC4B.run(args);
        }
        catch (BCompoundException e) {
            MP.printlnErr("***** Parsing Error *****");
            MP.printlnErr(e.getMessage());
            System.exit(-1);
        }
        catch (TLC4BException e) {
            MP.printlnErr(e.getMessage());
            MP.println("Result: " + e.getError());
            System.exit(-1);
        }
        catch (IOException e) {
            MP.printlnErr(e.getMessage());
            MP.println("Result: I/O Error");
            System.exit(-1);
        }
        System.exit(0);
    }

    public static TLCResults run(String[] args) throws TLC4BException, IOException, BCompoundException {
        System.setProperty("apple.awt.UIElement", "true");
        TLC4B tlc4b = new TLC4B();
        tlc4b.process(args);
        TLCResults results = null;
        if (TLC4BGlobals.isRunTLC()) {
            try {
                TLCRunner.runTLC(tlc4b.machineFileNameWithoutFileExtension, tlc4b.buildDir);
                results = new TLCResults(tlc4b.tlcOutputInfo);
                results.evalResults();
                tlc4b.printResults(results);
                tlc4b.createLogFile(results);
            }
            catch (NoClassDefFoundError e) {
                MP.printlnErr("Can not find TLC. The tlatools.jar must be included in the classpath.");
            }
        }
        return results;
    }

    public static void checkTLC4BIsApplicable(String path) throws BCompoundException {
        TLC4B tlc4B = new TLC4B();
        tlc4B.processArgs(new String[]{path, TLC4BOption.SILENT.cliArg()});
        tlc4B.translate();
    }

    private void printResults(TLCResults results) throws IOException {
        this.printOperationsCount(results);
        MP.printlnSilent("Used Options");
        if (TLC4BGlobals.getDfidInitialDepth() > 0) {
            MP.printlnSilent("| Use DFS with initial depth: " + TLC4BGlobals.getDfidInitialDepth());
        }
        MP.printlnSilent("| Number of workers: " + TLC4BGlobals.getWorkers());
        MP.printlnSilent("| Invariants check: " + TLC4BGlobals.isInvariant());
        MP.printlnSilent("| Deadlock check: " + TLC4BGlobals.isDeadlockCheck());
        MP.printlnSilent("| Assertion check: " + TLC4BGlobals.isAssertion());
        MP.printlnSilent("| Find Goal check: " + TLC4BGlobals.isGOAL());
        MP.printlnSilent("| LTL formulas check: " + TLC4BGlobals.isCheckLTL());
        MP.printlnSilent("| Partial invariant evaluation: " + TLC4BGlobals.isPartialInvariantEvaluation());
        MP.printlnSilent("| Lazy constants setup: " + !TLC4BGlobals.isForceTLCToEvalConstants());
        MP.printlnSilent("| Aggressive well-definedness check: " + TLC4BGlobals.checkWelldefinedness());
        MP.printlnSilent("| ProB constant setup: " + TLC4BGlobals.isProBconstantsSetup());
        MP.printlnSilent("| Symmetry reduction: " + TLC4BGlobals.useSymmetry());
        MP.printlnSilent("| MIN Int: " + TLC4BGlobals.getMIN_INT());
        MP.printlnSilent("| MAX Int: " + TLC4BGlobals.getMAX_INT());
        MP.printlnSilent("| Standard deferred set size: " + TLC4BGlobals.getDEFERRED_SET_SIZE());
        MP.printlnSilent("--------------------------------");
        if (TLC4BGlobals.isTranslate()) {
            MP.printlnSilent("Parsing time: " + StopWatch.getRunTime(StopWatch.Watches.PARSING_TIME) + " ms");
            MP.printlnSilent("Translation time: " + StopWatch.getRunTime(StopWatch.Watches.TRANSLATION_TIME) + " ms");
        }
        if (TLC4BGlobals.isRunTLC()) {
            MP.println("Model checking time: " + results.getModelCheckingTime() + " sec");
            if (!results.getViolatedAssertions().isEmpty()) {
                MP.println("Violated assertions: " + results.getViolatedAssertions());
            }
            MP.println("States analysed: " + results.getNumberOfDistinctStates());
            MP.println("Transitions fired: " + results.getNumberOfTransitions());
            MP.println("Result: " + results.getResultString());
            String violatedDefinition = results.getViolatedDefinition();
            if (violatedDefinition != null) {
                MP.println("Violated Definition: " + violatedDefinition);
            }
            if (results.hasTrace() && TLC4BGlobals.isCreateTraceFile()) {
                String trace = results.getTrace();
                String tracefileName = this.machineFileNameWithoutFileExtension + ".tla.trace";
                this.traceFile = TLC4B.createFile(this.buildDir, tracefileName, trace, TLC4BGlobals.isDeleteOnExit());
                results.addTraceFilePath(this.traceFile.getAbsolutePath());
                MP.println("Trace file '" + this.traceFile.getAbsolutePath() + "' created.");
            }
        }
    }

    private void printOperationsCount(TLCResults results) {
        Map<String, Long> operationCount = results.getOperationCount();
        if (TLC4BGlobals.isPrintCoverage() && operationCount != null) {
            MP.printlnSilent("---------- Coverage statistics ----------");
            for (Map.Entry<String, Long> entry : operationCount.entrySet()) {
                MP.printlnSilent(entry.getKey() + ": " + entry.getValue().toString());
            }
            MP.printlnSilent("---------- End of coverage statistics ----------");
        }
    }

    public static void test(String[] args, boolean deleteFiles) throws Exception {
        System.setProperty("apple.awt.UIElement", "true");
        TLC4BGlobals.resetGlobals();
        TLC4BGlobals.setDeleteOnExit(deleteFiles);
        TLC4B tlc4b = new TLC4B();
        try {
            tlc4b.process(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            MP.printlnErr(e.getMessage());
            throw e;
        }
        if (TLC4BGlobals.isRunTLC()) {
            MP.TLCOutputStream.changeOutputStream();
            TLCRunner.runTLC(tlc4b.machineFileNameWithoutFileExtension, tlc4b.buildDir);
            MP.TLCOutputStream.resetOutputStream();
            TLCResults results = new TLCResults(tlc4b.tlcOutputInfo);
            results.evalResults();
            tlc4b.printResults(results);
            tlc4b.createLogFile(results);
            System.exit(0);
        }
    }

    public static void testString(String machineString, boolean deleteFiles) throws Exception {
        System.setProperty("apple.awt.UIElement", "true");
        TLC4BGlobals.resetGlobals();
        TLC4BGlobals.setDeleteOnExit(deleteFiles);
        TLC4B tlc4b = new TLC4B();
        tlc4b.buildDir = new File("temp/");
        tlc4b.machineFileNameWithoutFileExtension = "Test";
        StopWatch.start(StopWatch.Watches.PARSING_TIME);
        MP.printSilent("Parsing... ");
        tlc4b.translator = new Translator(machineString);
        StopWatch.stop(StopWatch.Watches.PARSING_TIME);
        MP.printlnSilent("(" + StopWatch.getRunTimeAsString(StopWatch.Watches.PARSING_TIME) + "ms)");
        StopWatch.start(StopWatch.Watches.TRANSLATION_TIME);
        MP.printSilent("Translating... ");
        tlc4b.translator.translate();
        tlc4b.tlaModule = tlc4b.translator.getModuleString();
        tlc4b.config = tlc4b.translator.getConfigString();
        tlc4b.tlcOutputInfo = tlc4b.translator.getTLCOutputInfo();
        StopWatch.stop(StopWatch.Watches.TRANSLATION_TIME);
        MP.printlnSilent("(" + StopWatch.getRunTimeAsString(StopWatch.Watches.TRANSLATION_TIME) + "ms)");
        MP.printlnSilent("Translated TLA:\n" + tlc4b.tlaModule);
        tlc4b.createFiles();
        if (TLC4BGlobals.isRunTLC()) {
            MP.TLCOutputStream.changeOutputStream();
            TLCRunner.runTLC(tlc4b.machineFileNameWithoutFileExtension, tlc4b.buildDir);
            MP.TLCOutputStream.resetOutputStream();
            TLCResults results = new TLCResults(tlc4b.tlcOutputInfo);
            results.evalResults();
            tlc4b.printResults(results);
            System.exit(0);
        }
    }

    private static Options getCommandlineOptions() {
        Options options = new Options();
        for (TLC4BOption option : TLC4BOption.values()) {
            options.addOption(option.arg(), option.expectsArg() != null, option.desc());
        }
        return options;
    }

    private void handleParameter(String[] args) {
        DefaultParser parser = new DefaultParser();
        Options options = TLC4B.getCommandlineOptions();
        try {
            CommandLine line = parser.parse(options, args);
            String[] remainingArgs = line.getArgs();
            if (remainingArgs.length != 1) {
                throw new TLC4BIOException("Main machine required!");
            }
            this.mainfile = new File(remainingArgs[0]);
            TLC4BGlobals.resetGlobals();
            TLC4BGlobals.setVerbose(line.hasOption(TLC4BOption.VERBOSE.arg()));
            TLC4BGlobals.setSilent(line.hasOption(TLC4BOption.SILENT.arg()));
            TLC4BGlobals.setDeadlockCheck(!line.hasOption(TLC4BOption.NODEAD.arg()));
            TLC4BGlobals.setRunTLC(!line.hasOption(TLC4BOption.NOTLC.arg()));
            TLC4BGlobals.setTranslate(!line.hasOption(TLC4BOption.NOTRANSLATION.arg()));
            TLC4BGlobals.setGOAL(!line.hasOption(TLC4BOption.NOGOAL.arg()));
            TLC4BGlobals.setInvariant(!line.hasOption(TLC4BOption.NOINV.arg()));
            TLC4BGlobals.setAssertionCheck(!line.hasOption(TLC4BOption.NOASS.arg()));
            TLC4BGlobals.setWelldefinednessCheck(line.hasOption(TLC4BOption.WDCHECK.arg()));
            TLC4BGlobals.setSymmetryUse(line.hasOption(TLC4BOption.SYMMETRY.arg()));
            TLC4BGlobals.setCheckltl(!line.hasOption(TLC4BOption.NOLTL.arg()));
            TLC4BGlobals.setForceTLCToEvalConstants(!line.hasOption(TLC4BOption.LAZYCONSTANTS.arg()));
            TLC4BGlobals.setCreateTraceFile(!line.hasOption(TLC4BOption.NOTRACE.arg()));
            TLC4BGlobals.setDeleteOnExit(line.hasOption(TLC4BOption.DEL.arg()));
            TLC4BGlobals.setPartialInvariantEvaluation(line.hasOption(TLC4BOption.PARINVEVAL.arg()));
            TLC4BGlobals.setPrintCoverage(line.hasOption(TLC4BOption.COVERAGE.arg()));
            if (line.hasOption(TLC4BOption.TMP.arg())) {
                this.buildDir = new File(System.getProperty("java.io.tmpdir"));
            }
            if (line.hasOption(TLC4BOption.LOG.arg())) {
                String logFileString = line.getOptionValue(TLC4BOption.LOG.arg());
                if (logFileString == null) {
                    throw new TLC4BIOException("Error: File required after option '-log'.");
                }
                this.logFile = new File(logFileString);
            }
            if (line.hasOption(TLC4BOption.MAXINT.arg())) {
                String maxint = line.getOptionValue(TLC4BOption.MAXINT.arg());
                if (maxint == null) {
                    throw new TLC4BIOException("Error: Number required after option '-maxint'.");
                }
                TLC4BGlobals.setMAX_INT(Integer.parseInt(maxint));
            }
            if (line.hasOption(TLC4BOption.DEFAULT_SETSIZE.arg())) {
                String deferredSetSize = line.getOptionValue(TLC4BOption.DEFAULT_SETSIZE.arg());
                if (deferredSetSize == null) {
                    throw new TLC4BIOException("Error: Number required after option '-default_setsize'.");
                }
                TLC4BGlobals.setDEFERRED_SET_SIZE(Integer.parseInt(deferredSetSize));
            }
            if (line.hasOption(TLC4BOption.MININT.arg())) {
                String minint = line.getOptionValue(TLC4BOption.MININT.arg());
                if (minint == null) {
                    throw new TLC4BIOException("Error: Number required after option '-minint'.");
                }
                TLC4BGlobals.setMIN_INT(Integer.parseInt(minint));
            }
            if (line.hasOption(TLC4BOption.WORKERS.arg())) {
                String workers = line.getOptionValue(TLC4BOption.WORKERS.arg());
                if (workers == null) {
                    throw new TLC4BIOException("Error: Number required after option '-workers'.");
                }
                TLC4BGlobals.setWorkers(Integer.parseInt(workers));
            }
            if (line.hasOption(TLC4BOption.DFID.arg())) {
                String dfid_initial_depth = line.getOptionValue(TLC4BOption.DFID.arg());
                if (dfid_initial_depth == null) {
                    throw new TLC4BIOException("Error: Number required after option '-dfid'.");
                }
                TLC4BGlobals.setDfidInitialDepth(Integer.parseInt(dfid_initial_depth));
            }
            if (line.hasOption(TLC4BOption.CONSTANTSSETUP.arg())) {
                TLC4BGlobals.setProBconstantsSetup(true);
                this.constantsSetup = line.getOptionValue(TLC4BOption.CONSTANTSSETUP.arg());
                if (this.constantsSetup == null) {
                    throw new TLC4BIOException("Error: String required after option '-constantssetup'.");
                }
            }
            if (line.hasOption(TLC4BOption.LTLFORMULA.arg())) {
                this.ltlFormula = line.getOptionValue(TLC4BOption.LTLFORMULA.arg());
                if (this.ltlFormula == null) {
                    throw new TLC4BIOException("Error: LTL formula required after option '-ltlformula'.");
                }
            }
            if (line.hasOption(TLC4BOption.OUTPUT.arg())) {
                this.buildDir = new File(line.getOptionValue(TLC4BOption.OUTPUT.arg()));
            }
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("[file]", options);
            throw new TLC4BIOException(e);
        }
    }

    private void processArgs(String[] args) {
        this.handleParameter(args);
        this.handleMainFileName();
        MP.printVerbose("Arguments: ");
        for (String string : args) {
            MP.printVerbose(string);
            MP.printVerbose(" ");
        }
        MP.printlnVerbose("");
    }

    private void translate() throws BCompoundException {
        StopWatch.start(StopWatch.Watches.PARSING_TIME);
        MP.printSilent("Parsing... ");
        this.translator = new Translator(this.machineFileNameWithoutFileExtension, this.mainfile, this.ltlFormula, this.constantsSetup);
        StopWatch.stop(StopWatch.Watches.PARSING_TIME);
        MP.printlnSilent("(" + StopWatch.getRunTimeAsString(StopWatch.Watches.PARSING_TIME) + "ms)");
        StopWatch.start(StopWatch.Watches.TRANSLATION_TIME);
        MP.printSilent("Translating... ");
        this.translator.translate();
        this.tlaModule = this.translator.getModuleString();
        this.config = this.translator.getConfigString();
        this.tlcOutputInfo = this.translator.getTLCOutputInfo();
        StopWatch.stop(StopWatch.Watches.TRANSLATION_TIME);
        MP.printlnSilent("(" + StopWatch.getRunTimeAsString(StopWatch.Watches.TRANSLATION_TIME) + "ms)");
    }

    public void process(String[] args) throws IOException, BCompoundException {
        this.processArgs(args);
        if (TLC4BGlobals.isTranslate()) {
            this.translate();
            this.createFiles();
        }
    }

    private void handleMainFileName() {
        if (!this.mainfile.exists()) {
            throw new TLC4BIOException("The file " + this.mainfile.getPath() + " does not exist.");
        }
        try {
            this.mainfile = this.mainfile.getCanonicalFile();
        }
        catch (IOException e) {
            throw new TLC4BIOException("The file '" + this.mainfile.getPath() + "' can not be accessed.", e);
        }
        this.machineFileNameWithoutFileExtension = this.mainfile.getName().substring(0, this.mainfile.getName().length() - 4);
        if (this.buildDir == null) {
            this.buildDir = new File(this.mainfile.getParentFile(), this.machineFileNameWithoutFileExtension);
        }
    }

    private String getLogCsvString(TLCResults tlcResults) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<String> fieldValues = new ArrayList<String>();
        fieldNames.add("Machine File");
        String machineFile = this.mainfile.getAbsolutePath();
        fieldValues.add(machineFile);
        fieldNames.add("TLC Model Checking Time (s)");
        double tlcModelCheckingTime = tlcResults.getModelCheckingTime();
        fieldValues.add(String.valueOf(tlcModelCheckingTime));
        fieldNames.add("Parsing Time Of B machine (ms)");
        long parseTime = StopWatch.getRunTime(StopWatch.Watches.PARSING_TIME);
        fieldValues.add(String.valueOf(parseTime));
        fieldNames.add("Translation Time (ms)");
        long translationTime = StopWatch.getRunTime(StopWatch.Watches.TRANSLATION_TIME);
        fieldValues.add(String.valueOf(translationTime));
        fieldNames.add("Model Checking Time (ms)");
        long modelCheckingTime = StopWatch.getRunTime(StopWatch.Watches.MODEL_CHECKING_TIME);
        fieldValues.add(String.valueOf(modelCheckingTime));
        fieldNames.add("TLC Result");
        fieldValues.add(tlcResults.getResultString());
        fieldNames.add("States analysed");
        fieldValues.add(Integer.toString(tlcResults.getNumberOfDistinctStates()));
        fieldNames.add("Transitions fired");
        fieldValues.add(Integer.toString(tlcResults.getNumberOfTransitions()));
        fieldNames.add("Violated Definition");
        String violatedDefinition = tlcResults.getViolatedDefinition();
        fieldValues.add(violatedDefinition != null ? violatedDefinition : "");
        fieldNames.add("Violated Assertions");
        List<String> violatedAssertions = tlcResults.getViolatedAssertions();
        fieldValues.add(!violatedAssertions.isEmpty() ? String.join((CharSequence)CSV_DELIMITER, violatedAssertions) : "");
        fieldNames.add("Operation Coverage");
        Map<String, Long> operationCount = tlcResults.getOperationCount();
        ArrayList opCountString = new ArrayList();
        if (operationCount != null) {
            operationCount.forEach((operation, count) -> opCountString.add(operation + CSV_DELIMITER + count));
        }
        fieldValues.add(!opCountString.isEmpty() ? String.join((CharSequence)CSV_DELIMITER, opCountString) : "");
        fieldNames.add("Trace File");
        fieldValues.add(this.traceFile != null ? this.traceFile.getAbsolutePath() : "");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldNames.size(); ++i) {
            sb.append((String)fieldNames.get(i)).append(CSV_DELIMITER).append((String)fieldValues.get(i)).append("\n");
        }
        return sb.toString();
    }

    private void createLogFile(TLCResults results) throws IOException {
        if (this.logFile != null) {
            String logCsvString = this.getLogCsvString(results);
            try (FileWriter fw = new FileWriter(this.logFile, true);){
                fw.write(logCsvString);
            }
            MP.println("Log file: " + this.logFile.getAbsolutePath());
        }
    }

    private void createFiles() throws IOException {
        boolean dirCreated = this.buildDir.mkdir();
        if (dirCreated && TLC4BGlobals.isDeleteOnExit()) {
            this.buildDir.deleteOnExit();
        }
        File moduleFile = TLC4B.createFile(this.buildDir, this.machineFileNameWithoutFileExtension + ".tla", this.tlaModule, TLC4BGlobals.isDeleteOnExit());
        MP.println("TLA+ module '" + moduleFile.getAbsolutePath() + "' created.");
        File configFile = TLC4B.createFile(this.buildDir, this.machineFileNameWithoutFileExtension + ".cfg", this.config, TLC4BGlobals.isDeleteOnExit());
        MP.println("Configuration file '" + configFile.getAbsolutePath() + "' created.");
        this.createStandardModules();
    }

    private void createStandardModules() throws IOException {
        for (String module : this.translator.getStandardModuleToBeCreated()) {
            this.createStandardModule(this.buildDir, module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStandardModule(File path, String name) throws IOException {
        File file = new File(path, name + ".tla");
        InputStream resourceStream = TLC4B.class.getResourceAsStream("standardModules/" + name + ".tla");
        if (resourceStream == null) {
            throw new TranslationException("Unable to determine the source of the standard module: " + name);
        }
        try (InputStream is = resourceStream;
             FileOutputStream fos = new FileOutputStream(file);){
            int read;
            byte[] bytes = new byte[1024];
            while ((read = is.read(bytes)) != -1) {
                ((OutputStream)fos).write(bytes, 0, read);
            }
            MP.println("Standard module '" + file.getName() + "' created.");
        }
        finally {
            if (TLC4BGlobals.isDeleteOnExit() && file.exists()) {
                file.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createFile(File dir, String fileName, String text, boolean deleteOnExit) throws IOException {
        File file = new File(dir, fileName);
        boolean exists = false;
        try {
            exists = file.createNewFile();
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                out.write(text);
            }
            File file2 = file;
            return file2;
        }
        finally {
            if (deleteOnExit && exists) {
                file.deleteOnExit();
            }
        }
    }
}

