/*
 * Decompiled with CFR 0.152.
 */
package de.be4.ltl.core.parser.internal;

import de.be4.ltl.core.parser.node.Token;

abstract class LexerHelper<TOKEN, STATE> {
    private int count;
    private TOKEN externalFormula;
    private StringBuilder text;
    private STATE state;
    private STATE lastState;
    private boolean inQuote;

    protected abstract String readToken(TOKEN var1);

    protected abstract void writeToken(TOKEN var1, String var2);

    protected abstract boolean isInAction(STATE var1);

    protected abstract boolean isOpening(TOKEN var1);

    protected abstract boolean isClosing(TOKEN var1);

    protected abstract boolean correctBalancedParenthesis(int var1, TOKEN var2);

    protected abstract boolean isInActions(STATE var1);

    protected abstract boolean isOpeningActionArg(TOKEN var1);

    protected abstract boolean isClosingActionArg(TOKEN var1);

    protected abstract boolean isBeginningActionsToken(TOKEN var1);

    protected abstract boolean isArgumentClosing(TOKEN var1);

    protected abstract boolean isArgumentSplittingToken(TOKEN var1);

    protected abstract boolean isQuote(TOKEN var1);

    public LexerHelper(STATE initialState) {
        this.lastState = initialState;
    }

    public TOKEN filter(STATE newState, TOKEN token) {
        if (this.isQuote(token)) {
            this.inQuote = !this.inQuote;
        }
        this.state = newState;
        if (this.isInAction(this.state)) {
            if (this.externalFormula == null) {
                this.initialiseActionToken(token);
                token = null;
            } else {
                String tokenText = this.readToken(token);
                this.text.append(tokenText);
                if (this.isOpening(token) && !this.inQuote) {
                    ++this.count;
                } else if (this.isClosing(token) && !this.inQuote) {
                    --this.count;
                }
                if (!this.correctBalancedParenthesis(this.count, token)) {
                    return token;
                }
                if (this.count != 0) {
                    token = null;
                } else {
                    this.text.deleteCharAt(this.text.length() - 1);
                    this.writeToken(this.externalFormula, this.text.toString());
                    token = this.externalFormula;
                    this.state = this.lastState;
                    this.externalFormula = null;
                }
            }
        } else if (this.isInActions(this.state)) {
            if (!this.isBeginningActionsToken(token)) {
                if (this.externalFormula == null) {
                    this.initialiseActionToken(token);
                    String tokenText = this.readToken(token);
                    this.text.append(tokenText);
                    token = null;
                } else {
                    if (this.isOpeningActionArg(token)) {
                        ++this.count;
                    } else if (this.isClosingActionArg(token)) {
                        --this.count;
                    }
                    if (!this.correctBalancedParenthesis(this.count, token)) {
                        return token;
                    }
                    if (this.count == 1 && !this.isArgumentClosing(token) || this.count > 1) {
                        String tokenText = this.readToken(token);
                        this.text.append(tokenText);
                    }
                    if (this.count == 1 && this.isArgumentSplittingToken(token)) {
                        token = this.updateTokenText();
                    } else if (this.count == 0) {
                        token = this.updateTokenText();
                        this.state = this.lastState;
                    } else {
                        token = null;
                    }
                }
            }
        } else {
            this.lastState = this.state;
        }
        return token;
    }

    public void initialiseActionToken(TOKEN token) {
        this.externalFormula = token;
        this.text = new StringBuilder();
        this.count = 1;
        this.inQuote = false;
    }

    public TOKEN updateTokenText() {
        this.writeToken(this.externalFormula, this.text.toString().trim());
        TOKEN tok = this.externalFormula;
        this.externalFormula = null;
        return tok;
    }

    public TOKEN getIdentifier(TOKEN token, TOKEN ident) {
        String str = ((Token)token).getText();
        String identifier = str.substring(1, str.length() - 1).trim();
        ((Token)ident).setText(identifier);
        token = ident;
        return token;
    }

    public STATE getState() {
        return this.state;
    }
}

