/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.rules;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.ABooleanFalseExpression;
import de.be4.classicalb.core.parser.node.ABooleanTrueExpression;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AIntegerExpression;
import de.be4.classicalb.core.parser.node.AOperatorExpression;
import de.be4.classicalb.core.parser.node.AOperatorPredicate;
import de.be4.classicalb.core.parser.node.APredicateDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AStringExpression;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.rules.AbstractOperation;
import de.be4.classicalb.core.parser.rules.IModel;
import de.be4.classicalb.core.parser.rules.RuleOperation;
import de.be4.classicalb.core.parser.rules.RulesParseUnit;
import de.be4.classicalb.core.parser.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RulesMachineRunConfiguration {
    public static final String GOAL = "GOAL";
    final Map<String, AbstractOperation> allOperations;
    final RulesParseUnit mainModel;
    final Map<String, RuleGoalAssumption> rulesGoalAssumptions = new HashMap<String, RuleGoalAssumption>();
    private final Map<String, String> preferencesInMainMachine = new HashMap<String, String>();

    public static RulesMachineRunConfiguration extractConfigurationOfMainModel(IModel mainModel, Map<String, AbstractOperation> allOperations) {
        RulesMachineRunConfiguration rulesMachineRunConfiguration = new RulesMachineRunConfiguration(mainModel, allOperations);
        rulesMachineRunConfiguration.collect();
        return rulesMachineRunConfiguration;
    }

    private RulesMachineRunConfiguration(IModel mainModel, Map<String, AbstractOperation> allOperations) {
        this.mainModel = (RulesParseUnit)mainModel;
        this.allOperations = allOperations;
    }

    public void collect() {
        DefinitionsFinder definitionsFinder = new DefinitionsFinder();
        this.mainModel.getStart().apply(definitionsFinder);
    }

    public Map<String, String> getPreferencesInModel() {
        return new HashMap<String, String>(this.preferencesInMainMachine);
    }

    public Set<RuleGoalAssumption> getRulesGoalAssumptions() {
        return new HashSet<RuleGoalAssumption>(this.rulesGoalAssumptions.values());
    }

    public static class RuleGoalAssumption {
        final String name;
        final RuleOperation ruleOperation;
        final HashSet<Integer> errorTypesAssumedToFail = new HashSet();
        final HashSet<Integer> errorTypesAssumedToSucceed = new HashSet();
        boolean checkedForCounterexamples = false;

        public RuleGoalAssumption(String name, RuleOperation ruleOperation) {
            this.name = name;
            this.ruleOperation = ruleOperation;
        }

        public void setCheckedForCounterexamples() {
            this.checkedForCounterexamples = true;
        }

        public void setFailedWithoutSpecificErrorType() {
            Integer n = this.ruleOperation.getNumberOfErrorTypes();
            if (n == 1) {
                this.errorTypesAssumedToFail.add(1);
            }
        }

        public void setFailedForAllErrorTypes() {
            Integer n = this.ruleOperation.getNumberOfErrorTypes();
            for (int i = 1; i <= n; ++i) {
                this.errorTypesAssumedToFail.add(i);
            }
        }

        public void setSuccessForAllErrorTypes() {
            Integer n = this.ruleOperation.getNumberOfErrorTypes();
            for (int i = 1; i <= n; ++i) {
                this.errorTypesAssumedToSucceed.add(i);
            }
        }

        public String getRuleName() {
            return this.name;
        }

        public RuleOperation getRuleOperation() {
            return this.ruleOperation;
        }

        public void addErrorTypeAssumedToFail(Integer i) {
            this.errorTypesAssumedToFail.add(i);
        }

        public void addErrorTypeAssumedToSucceed(Integer i) {
            this.errorTypesAssumedToSucceed.add(i);
        }

        public Set<Integer> getErrorTypesAssumedToFail() {
            return new HashSet<Integer>(this.errorTypesAssumedToFail);
        }

        public Set<Integer> getErrorTypesAssumedToSucceed() {
            return new HashSet<Integer>(this.errorTypesAssumedToSucceed);
        }

        public boolean isCheckedForCounterexamples() {
            return this.checkedForCounterexamples;
        }
    }

    class RulesInGoalFinder
    extends DepthFirstAdapter {
        RulesInGoalFinder() {
        }

        @Override
        public void caseAOperatorExpression(AOperatorExpression node) {
            String operatorName = node.getName().getText();
            if ("GET_RULE_COUNTEREXAMPLES".equals(operatorName)) {
                RuleGoalAssumption ruleGoalAssumption = this.getRuleCoverage(node.getIdentifiers().get(0));
                ruleGoalAssumption.setCheckedForCounterexamples();
            }
        }

        private RuleGoalAssumption getRuleCoverage(PExpression pExpression) {
            AIdentifierExpression identifier = (AIdentifierExpression)pExpression;
            String ruleName = Utils.getTIdentifierListAsString(identifier.getIdentifier());
            return this.getRuleCoverage(ruleName);
        }

        private RuleGoalAssumption getRuleCoverage(String ruleName) {
            if (RulesMachineRunConfiguration.this.rulesGoalAssumptions.containsKey(ruleName)) {
                return RulesMachineRunConfiguration.this.rulesGoalAssumptions.get(ruleName);
            }
            RuleGoalAssumption ruleGoalAssumption = new RuleGoalAssumption(ruleName, (RuleOperation)RulesMachineRunConfiguration.this.allOperations.get(ruleName));
            RulesMachineRunConfiguration.this.rulesGoalAssumptions.put(ruleName, ruleGoalAssumption);
            return ruleGoalAssumption;
        }

        @Override
        public void caseAOperatorPredicate(AOperatorPredicate node) {
            String operatorName;
            ArrayList<PExpression> arguments = new ArrayList<PExpression>(node.getIdentifiers());
            switch (operatorName = node.getName().getText()) {
                case "SUCCEEDED_RULE": {
                    this.getRuleCoverage((PExpression)arguments.get(0)).setSuccessForAllErrorTypes();
                    return;
                }
                case "FAILED_RULE": {
                    this.getRuleCoverage((PExpression)arguments.get(0)).setFailedWithoutSpecificErrorType();
                    return;
                }
                case "FAILED_RULE_ALL_ERROR_TYPES": {
                    this.getRuleCoverage((PExpression)arguments.get(0)).setFailedForAllErrorTypes();
                    return;
                }
                case "SUCCEEDED_RULE_ERROR_TYPE": 
                case "FAILED_RULE_ERROR_TYPE": {
                    RuleGoalAssumption ruleGoalAssumption = this.getRuleCoverage((PExpression)arguments.get(0));
                    AIntegerExpression intExpr = (AIntegerExpression)arguments.get(1);
                    String text = intExpr.getLiteral().getText();
                    int errorType = Integer.parseInt(text);
                    if ("SUCCEEDED_RULE_ERROR_TYPE".equals(operatorName)) {
                        this.getRuleCoverage((PExpression)arguments.get(0)).addErrorTypeAssumedToSucceed(errorType);
                    } else {
                        ruleGoalAssumption.addErrorTypeAssumedToFail(errorType);
                    }
                    return;
                }
            }
        }
    }

    class DefinitionsFinder
    extends DepthFirstAdapter {
        private static final String PROB_PREFERENCES_PREFIX = "SET_PREF_";

        DefinitionsFinder() {
        }

        @Override
        public void caseAExpressionDefinitionDefinition(AExpressionDefinitionDefinition node) {
            String name = node.getName().getText();
            if (name.startsWith(PROB_PREFERENCES_PREFIX)) {
                String prefName = name.substring(PROB_PREFERENCES_PREFIX.length());
                if (node.getRhs() instanceof AIntegerExpression) {
                    AIntegerExpression aIntExpr = (AIntegerExpression)node.getRhs();
                    String value = aIntExpr.getLiteral().getText();
                    RulesMachineRunConfiguration.this.preferencesInMainMachine.put(prefName, value);
                } else if (node.getRhs() instanceof AStringExpression) {
                    AStringExpression aStringExpr = (AStringExpression)node.getRhs();
                    String value = aStringExpr.getContent().getText();
                    RulesMachineRunConfiguration.this.preferencesInMainMachine.put(prefName, value);
                } else if (node.getRhs() instanceof ABooleanTrueExpression) {
                    RulesMachineRunConfiguration.this.preferencesInMainMachine.put(prefName, "TRUE");
                } else if (node.getRhs() instanceof ABooleanFalseExpression) {
                    RulesMachineRunConfiguration.this.preferencesInMainMachine.put(prefName, "FALSE");
                }
            }
        }

        @Override
        public void caseAPredicateDefinitionDefinition(APredicateDefinitionDefinition node) {
            String name = node.getName().getText();
            if (RulesMachineRunConfiguration.GOAL.equals(name)) {
                RulesInGoalFinder rulesInGoalFinder = new RulesInGoalFinder();
                node.getRhs().apply(rulesInGoalFinder);
            }
        }
    }
}

