/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.analysis.prolog;

import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.be4.classicalb.core.parser.exceptions.BException;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.output.PrologTermOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public final class PrologExceptionPrinter {
    private PrologExceptionPrinter() {
    }

    public static void printException(OutputStream out, IOException e) {
        PrologTermOutput pto = new PrologTermOutput(out, false);
        PrologExceptionPrinter.printException((IPrologTermOutput)pto, e);
        pto.fullstop();
    }

    public static void printException(PrintWriter out, IOException e) {
        PrologTermOutput pto = new PrologTermOutput(out, false);
        PrologExceptionPrinter.printException((IPrologTermOutput)pto, e);
        pto.fullstop();
    }

    public static void printException(IPrologTermOutput pto, IOException e) {
        pto.openTerm("io_exception");
        pto.printAtom(String.valueOf(e.getMessage()));
        pto.closeTerm();
    }

    public static void printException(OutputStream out, BCompoundException e) {
        PrologTermOutput pto = new PrologTermOutput(out, false);
        PrologExceptionPrinter.printException((IPrologTermOutput)pto, e);
        pto.fullstop();
    }

    public static void printException(PrintWriter out, BCompoundException e) {
        PrologTermOutput pto = new PrologTermOutput(out, false);
        PrologExceptionPrinter.printException((IPrologTermOutput)pto, e);
        pto.fullstop();
    }

    public static void printException(IPrologTermOutput pto, BCompoundException e) {
        if (e.getBExceptions().size() > 1) {
            pto.openTerm("compound_exception", true);
            pto.openList();
            for (BException ex : e.getBExceptions()) {
                PrologExceptionPrinter.printBException(pto, ex);
            }
            pto.closeList();
            pto.closeTerm();
        } else if (e.getBExceptions().size() == 1) {
            PrologExceptionPrinter.printBException(pto, e.getBExceptions().get(0));
        } else {
            throw new IllegalStateException("Empty compoundException.");
        }
    }

    public static void printBException(IPrologTermOutput pto, BException e) {
        pto.openTerm("parse_exception");
        pto.openList();
        for (BException.Location location : e.getLocations()) {
            pto.openTerm("pos");
            pto.printNumber(location.getStartLine());
            pto.printNumber(location.getStartColumn());
            pto.printNumber(location.getEndLine());
            pto.printNumber(location.getEndColumn());
            pto.printAtom(String.valueOf(location.getFilename()));
            pto.closeTerm();
        }
        pto.closeList();
        pto.printAtom(String.valueOf(e.getMessage()));
        pto.closeTerm();
    }
}

