/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.translation;

import de.tla2b.analysis.AbstractASTVisitor;
import de.tla2b.analysis.SpecAnalyser;
import de.tla2b.config.ConfigfileEvaluator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import tla2sany.semantic.AssumeNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SymbolNode;

public class BMacroHandler
extends AbstractASTVisitor {
    private final Map<FormalParamNode, String> renamingTable = new HashMap<FormalParamNode, String>();
    private Set<FormalParamNode> definitionParameters;
    private Set<FormalParamNode> localVariables;
    private final Map<FormalParamNode, Set<FormalParamNode>> parameterContext = new HashMap<FormalParamNode, Set<FormalParamNode>>();
    private Set<FormalParamNode> illegalParams;
    final Set<String> globalNames = new HashSet<String>();

    public BMacroHandler(SpecAnalyser specAnalyser, ConfigfileEvaluator conEval) {
        ModuleNode moduleNode = specAnalyser.getModuleNode();
        List bDefs = Arrays.stream(moduleNode.getOpDefs()).filter(def -> specAnalyser.getUsedDefinitions().contains(def)).filter(def -> conEval == null || !conEval.getConstantOverrides().containsValue(def)).collect(Collectors.toList());
        for (OpDefNode opDefNode : bDefs) {
            this.visitDefinition(opDefNode);
        }
        this.visitAssumptions(moduleNode.getAssumptions());
    }

    public BMacroHandler() {
    }

    @Override
    public void visitDefinition(OpDefNode def) {
        this.definitionParameters = new HashSet<FormalParamNode>(Arrays.asList(def.getParams()));
        for (FormalParamNode param : this.definitionParameters) {
            this.parameterContext.put(param, new HashSet());
        }
        this.localVariables = new HashSet<FormalParamNode>();
        this.visitExprNode(def.getBody());
        this.definitionParameters = null;
        this.localVariables = null;
    }

    @Override
    public void visitAssumeNode(AssumeNode assumeNode) {
        this.definitionParameters = new HashSet<FormalParamNode>();
        this.localVariables = new HashSet<FormalParamNode>();
        this.visitExprNode(assumeNode.getAssume());
        this.definitionParameters = null;
        this.localVariables = null;
    }

    @Override
    public void visitBuiltInNode(OpApplNode n) {
        switch (BMacroHandler.getOpCode(n.getOperator().getName())) {
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 22: {
                HashSet set = new HashSet();
                for (FormalParamNode[] formalParamNodeArray : n.getBdedQuantSymbolLists()) {
                    Collections.addAll(set, formalParamNodeArray);
                }
                this.localVariables.addAll(set);
                for (FormalParamNode[] formalParamNodeArray : n.getBdedQuantBounds()) {
                    this.visitExprNode((ExprNode)formalParamNodeArray);
                }
                for (FormalParamNode[] formalParamNodeArray : n.getArgs()) {
                    this.visitExprOrOpArgNode((ExprOrOpArgNode)formalParamNodeArray);
                }
                this.localVariables.removeAll(set);
                return;
            }
        }
        super.visitBuiltInNode(n);
    }

    private Set<String> getStringSet(Set<FormalParamNode> set) {
        return set.stream().map(s -> s.getName().toString()).collect(Collectors.toSet());
    }

    private void addToIllegalParams(Set<FormalParamNode> set) {
        if (this.illegalParams == null) {
            this.illegalParams = new HashSet<FormalParamNode>();
        }
        this.illegalParams.addAll(set);
    }

    private Set<FormalParamNode> getContextOfParam(FormalParamNode param) {
        Set<FormalParamNode> set = this.parameterContext.get(param);
        if (set == null) {
            set = new HashSet<FormalParamNode>();
        }
        return set;
    }

    @Override
    public void visitUserDefinedNode(OpApplNode n) {
        OpDefNode operator = (OpDefNode)n.getOperator();
        FormalParamNode[] params = operator.getParams();
        ExprOrOpArgNode[] arguments = n.getArgs();
        for (int i = 0; i < arguments.length; ++i) {
            Set<FormalParamNode> set = this.getContextOfParam(params[i]);
            this.addToIllegalParams(set);
            this.visitExprOrOpArgNode(arguments[i]);
            this.illegalParams.removeAll(set);
        }
    }

    @Override
    public void visitFormalParamNode(OpApplNode n) {
        FormalParamNode param = (FormalParamNode)n.getOperator();
        if (this.definitionParameters.contains(param)) {
            this.parameterContext.get(param).addAll(this.localVariables);
        }
        this.hasSymbolAValidName(n);
    }

    @Override
    public void visitConstantNode(OpApplNode n) {
        this.hasSymbolAValidName(n);
    }

    @Override
    public void visitVariableNode(OpApplNode n) {
        this.hasSymbolAValidName(n);
    }

    private void hasSymbolAValidName(OpApplNode n) {
        SymbolNode symbol = n.getOperator();
        String symbolName = symbol.getName().toString();
        if (this.illegalParams != null) {
            for (FormalParamNode illegalParam : this.illegalParams) {
                if (!symbolName.equals(illegalParam.getName().toString())) continue;
                Set<String> illgalNames = this.getStringSet(this.illegalParams);
                String newName = this.incName(symbolName, illgalNames);
                this.renamingTable.put(illegalParam, newName);
            }
        }
    }

    private Boolean existingName(String name) {
        return this.globalNames.contains(name);
    }

    private String incName(String name, Set<String> tempSet) {
        String res = name;
        int i = 1;
        while (this.existingName(res).booleanValue() || tempSet.contains(res)) {
            res = name + "_" + i;
            ++i;
        }
        return res;
    }

    public boolean containsSymbolNode(SymbolNode s) {
        return this.renamingTable.containsKey(s);
    }

    public String getNewName(SymbolNode s) {
        return this.renamingTable.get(s);
    }
}

