/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.output;

import de.be4.classicalb.core.parser.analysis.prolog.ClassicalPositionPrinter;
import de.be4.classicalb.core.parser.analysis.prolog.INodeIds;
import de.be4.classicalb.core.parser.node.Node;
import de.prob.prolog.output.IPrologTermOutput;
import de.tla2b.exceptions.NotImplementedException;
import de.tla2b.output.TypeVisitorInterface;
import de.tla2b.types.BoolType;
import de.tla2b.types.EnumType;
import de.tla2b.types.FunctionType;
import de.tla2b.types.IntType;
import de.tla2b.types.IntegerOrRealType;
import de.tla2b.types.ModelValueType;
import de.tla2b.types.RealType;
import de.tla2b.types.SetType;
import de.tla2b.types.StringType;
import de.tla2b.types.StructOrFunctionType;
import de.tla2b.types.StructType;
import de.tla2b.types.TLAType;
import de.tla2b.types.TupleOrFunction;
import de.tla2b.types.TupleType;
import de.tla2b.types.UntypedType;
import java.util.List;
import java.util.Map;

public class TlaTypePrinter
extends ClassicalPositionPrinter
implements TypeVisitorInterface {
    private IPrologTermOutput pout;
    private final Map<Node, TLAType> types;

    public TlaTypePrinter(INodeIds nodeIds, Map<Node, TLAType> types) {
        super(nodeIds);
        super.setPrintSourcePositions(true, true);
        this.types = types;
    }

    @Override
    public void printPosition(Node node) {
        TLAType type = this.types.get(node);
        if (type != null) {
            this.pout.openTerm("info");
        }
        super.printPosition(node);
        if (type != null) {
            this.pout.openTerm("tla_type");
            type.apply(this);
            this.pout.closeTerm();
            this.pout.closeTerm();
        }
    }

    @Override
    public void setPrologTermOutput(IPrologTermOutput pout) {
        super.setPrologTermOutput(pout);
        this.pout = pout;
    }

    @Override
    public void caseIntegerType(IntType t) {
        this.pout.printAtom("integer");
    }

    @Override
    public void caseBoolType(BoolType t) {
        this.pout.printAtom("bool");
    }

    @Override
    public void caseEnumType(EnumType type) {
        this.pout.printAtom("modelvalue");
    }

    @Override
    public void caseFunctionType(FunctionType type) {
        this.pout.openTerm("function", true);
        type.getDomain().apply(this);
        type.getRange().apply(this);
        this.pout.closeTerm();
    }

    @Override
    public void caseModelValueType(ModelValueType type) {
        this.pout.printAtom("modelvalue");
    }

    @Override
    public void caseRealType(RealType type) {
        this.pout.printAtom("real");
    }

    @Override
    public void caseIntegerOrRealType(IntegerOrRealType type) {
        throw new NotImplementedException("should not happen");
    }

    @Override
    public void caseSetType(SetType type) {
        this.pout.openTerm("set");
        type.getSubType().apply(this);
        this.pout.closeTerm();
    }

    @Override
    public void caseStringType(StringType type) {
        this.pout.printAtom("string");
    }

    @Override
    public void caseStructOrFunction(StructOrFunctionType type) {
        throw new NotImplementedException("should not happen");
    }

    @Override
    public void caseStructType(StructType type) {
        this.pout.openTerm("record");
        this.pout.openList();
        List<String> fields = type.getFields();
        for (String field : fields) {
            if (type.isExtensible()) {
                this.pout.openTerm("opt");
            } else {
                this.pout.openTerm("field");
            }
            this.pout.printAtom(field);
            type.getType(field).apply(this);
            this.pout.closeTerm();
        }
        this.pout.closeList();
        this.pout.closeTerm();
    }

    @Override
    public void caseTupleType(TupleType type) {
        this.pout.openTerm("tuple");
        this.pout.openList();
        for (TLAType t : type.getTypes()) {
            t.apply(this);
        }
        this.pout.closeList();
        this.pout.closeTerm();
    }

    @Override
    public void caseTupleOrFunctionType(TupleOrFunction type) {
        throw new NotImplementedException("should not happen");
    }

    @Override
    public void caseUntyped(UntypedType type) {
        throw new NotImplementedException("should not happen");
    }
}

