/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.config;

import de.tla2b.config.TLCValueNode;
import de.tla2b.exceptions.ConfigFileErrorException;
import de.tla2b.exceptions.UnificationException;
import de.tla2b.types.BoolType;
import de.tla2b.types.EnumType;
import de.tla2b.types.IntType;
import de.tla2b.types.SetType;
import de.tla2b.types.StringType;
import de.tla2b.types.TLAType;
import de.tla2b.types.UntypedType;
import de.tla2b.util.DebugUtils;
import de.tla2b.util.TlaUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.InstanceNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.OpDefOrDeclNode;
import tlc2.tool.impl.ModelConfig;
import tlc2.util.Vect;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.Value;

public class ConfigfileEvaluator {
    private final ModelConfig configAst;
    private final ModuleNode moduleNode;
    private final Map<String, OpDefNode> definitions;
    private final Map<String, OpDeclNode> constants;
    private final OpDefNode specNode;
    private final OpDefNode nextNode;
    private final OpDefNode initNode;
    private final List<OpDefNode> invariantNodeList = new ArrayList<OpDefNode>();
    private final List<String> enumeratedSet = new ArrayList<String>();
    private final Map<String, EnumType> enumeratedTypes = new LinkedHashMap<String, EnumType>();
    private final Map<OpDeclNode, TLCValueNode> constantAssignments = new HashMap<OpDeclNode, TLCValueNode>();
    private final Map<OpDefNode, TLCValueNode> operatorAssignments = new HashMap<OpDefNode, TLCValueNode>();
    private final List<OpDefNode> operatorModelvalues = new ArrayList<OpDefNode>();
    private final List<OpDeclNode> bConstantList = new ArrayList<OpDeclNode>();
    private final Map<OpDefNode, OpDefNode> operatorOverrides = new HashMap<OpDefNode, OpDefNode>();
    private final Map<OpDeclNode, OpDefNode> constantOverrides = new HashMap<OpDeclNode, OpDefNode>();

    public ConfigfileEvaluator(ModelConfig configAst, ModuleNode moduleNode) throws ConfigFileErrorException {
        this.configAst = configAst;
        this.moduleNode = moduleNode;
        this.definitions = TlaUtils.getOpDefsMap(moduleNode.getOpDefs());
        this.constants = TlaUtils.getDeclarationsMap(moduleNode.getConstantDecls());
        this.bConstantList.addAll(this.constants.values());
        this.nextNode = this.evalPredicate(configAst.getNext(), "next state");
        this.initNode = this.evalPredicate(configAst.getInit(), "initialisation");
        this.specNode = this.evalPredicate(configAst.getSpec(), "specification");
        if (moduleNode.getVariableDecls().length > 0 && this.initNode == null && this.specNode == null) {
            throw new ConfigFileErrorException("The module contains variables. Hence there must be either a SPECIFICATION or INIT declaration.");
        }
        this.evalInvariants();
        this.evalConstantOrDefOverrides();
        try {
            this.evalConstantOrOperatorAssignments();
            this.evalModConOrDefAssignments();
        }
        catch (AbortException e) {
            throw new RuntimeException(e);
        }
        this.evalModConOrDefOverrides();
    }

    private OpDefNode evalPredicate(String predicate, String description) throws ConfigFileErrorException {
        if (!predicate.isEmpty()) {
            if (!this.definitions.containsKey(predicate)) {
                throw new ConfigFileErrorException("Invalid declaration of the " + description + " predicate. Module does not contain the definition '" + predicate + "'");
            }
            return this.definitions.get(predicate);
        }
        return null;
    }

    private void evalInvariants() throws ConfigFileErrorException {
        Vect v = this.configAst.getInvariants();
        for (int i = 0; i < v.size(); ++i) {
            if (!(v.elementAt(i) instanceof String)) continue;
            String inv = (String)v.elementAt(i);
            if (!this.definitions.containsKey(inv)) {
                throw new ConfigFileErrorException("Invalid invariant declaration. Module does not contain definition '" + inv + "'");
            }
            this.invariantNodeList.add(this.definitions.get(inv));
        }
    }

    private void evalConstantOrDefOverrides() throws ConfigFileErrorException {
        for (Map.Entry<String, String> entry : this.configAst.getOverrides().entrySet()) {
            String left = entry.getKey();
            String right = entry.getValue();
            OpDefNode rightDefNode = this.definitions.get(right);
            if (rightDefNode == null) {
                throw new ConfigFileErrorException("Invalid substitution for " + left + ".\n Module does not contain definition " + right + ".");
            }
            if (this.constants.containsKey(left)) {
                OpDeclNode conNode = this.constants.get(left);
                if (conNode.getArity() != rightDefNode.getArity()) {
                    throw new ConfigFileErrorException(String.format("Invalid substitution for %s.%n Constant %s has %s arguments while %s has %s arguments.", left, left, conNode.getArity(), right, rightDefNode.getArity()));
                }
                if (conNode.getArity() > 0) {
                    this.bConstantList.remove(conNode);
                }
                DebugUtils.printMsg("Putting Constant into CONSTANT OverrideTable " + conNode.getName() + "/" + conNode.getArity());
                this.constantOverrides.put(conNode, rightDefNode);
                continue;
            }
            if (this.definitions.containsKey(left)) {
                OpDefNode defNode = this.definitions.get(left);
                if (defNode.getArity() != rightDefNode.getArity()) {
                    throw new ConfigFileErrorException(String.format("Invalid substitution for %s.%n Operator %s has %s arguments while %s has %s arguments.", left, left, defNode.getArity(), right, rightDefNode.getArity()));
                }
                DebugUtils.printMsg("Putting Definition into OPERATOR OverrideTable " + defNode.getName() + "/" + defNode.getArity());
                this.operatorOverrides.put(defNode, rightDefNode);
                continue;
            }
            throw new ConfigFileErrorException("Module does not contain the symbol: " + left);
        }
    }

    private void evalConstantOrOperatorAssignments() throws ConfigFileErrorException, AbortException {
        Vect configCons = this.configAst.getConstants();
        for (int i = 0; i < configCons.size(); ++i) {
            Vect symbol = (Vect)configCons.elementAt(i);
            String symbolName = symbol.firstElement().toString();
            Value symbolValue = (Value)symbol.lastElement();
            TLAType symbolType = this.conGetType(symbol.lastElement());
            if (this.constants.containsKey(symbolName)) {
                OpDeclNode c = this.constants.get(symbolName);
                this.constantAssignments.put(c, new TLCValueNode(symbolValue, symbolType, c.getTreeNode()));
                if (!(symbolType instanceof EnumType) || !symbolName.equals(symbolValue.toString())) continue;
                this.bConstantList.remove(c);
                continue;
            }
            if (this.definitions.containsKey(symbolName)) {
                OpDefNode def = this.definitions.get(symbolName);
                this.operatorAssignments.put(def, new TLCValueNode(symbolValue, symbolType, def.getBody().getTreeNode()));
                if (symbolType instanceof SetType && ((SetType)symbolType).getSubType() instanceof EnumType) {
                    this.operatorModelvalues.add(def);
                    continue;
                }
                if (!(symbolType instanceof EnumType)) continue;
                this.operatorModelvalues.add(def);
                continue;
            }
            throw new ConfigFileErrorException("Module does not contain the symbol: " + symbolName);
        }
    }

    private void evalModConOrDefAssignments() throws ConfigFileErrorException, AbortException {
        Hashtable configCons = this.configAst.getModConstants();
        for (Map.Entry entry : configCons.entrySet()) {
            String moduleName = (String)entry.getKey();
            Vect assignments = (Vect)entry.getValue();
            ModuleNode mNode = this.searchModule(moduleName);
            for (int i = 0; i < assignments.size(); ++i) {
                Vect assignment = (Vect)assignments.elementAt(i);
                OpDefOrDeclNode opDefOrDeclNode = this.searchDefinitionOrConstant(mNode, (String)assignment.firstElement());
                Value symbolValue = (Value)assignment.elementAt(1);
                TLAType symbolType = this.conGetType(symbolValue);
                if (opDefOrDeclNode instanceof OpDeclNode) {
                    OpDeclNode c = (OpDeclNode)opDefOrDeclNode;
                    this.constantAssignments.put(c, new TLCValueNode(symbolValue, symbolType, c.getTreeNode()));
                    String symbolName = opDefOrDeclNode.getName().toString();
                    if (!symbolName.equals(symbolValue.toString())) continue;
                    this.bConstantList.remove(c);
                    continue;
                }
                OpDefNode def = (OpDefNode)opDefOrDeclNode;
                this.operatorAssignments.put(def, new TLCValueNode(symbolValue, symbolType, def.getBody().getTreeNode()));
                if (symbolType instanceof SetType) {
                    if (!(((SetType)symbolType).getSubType() instanceof EnumType)) continue;
                    this.operatorModelvalues.add(def);
                    continue;
                }
                if (!(symbolType instanceof EnumType)) continue;
                this.operatorModelvalues.add(def);
            }
        }
    }

    private void evalModConOrDefOverrides() throws ConfigFileErrorException {
        Hashtable configCons = this.configAst.getModOverrides();
        for (Map.Entry entry : configCons.entrySet()) {
            String moduleName = (String)entry.getKey();
            Map o = (Map)entry.getValue();
            for (Map.Entry entry1 : o.entrySet()) {
                String left = (String)entry1.getKey();
                String right = (String)entry1.getValue();
                OpDefNode rightDefNode = this.definitions.get(right);
                if (rightDefNode == null) {
                    throw new ConfigFileErrorException("Invalid substitution for " + left + ".\n Module does not contain definition " + right + ".");
                }
                OpDefOrDeclNode opDefOrDeclNode = this.searchDefinitionOrConstant(this.searchModule(moduleName), left);
                if (opDefOrDeclNode instanceof OpDefNode) {
                    OpDefNode defNode = (OpDefNode)opDefOrDeclNode;
                    if (defNode.getArity() != rightDefNode.getArity()) {
                        throw new ConfigFileErrorException(String.format("Invalid substitution for %s.%n Operator %s has %s arguments while %s has %s arguments.", left, left, defNode.getArity(), right, rightDefNode.getArity()));
                    }
                    this.operatorOverrides.put(defNode, rightDefNode);
                    continue;
                }
                InstanceNode[] instanceNodes = this.moduleNode.getInstances();
                for (int i = 0; i < instanceNodes.length; ++i) {
                }
                OpDeclNode conNode = (OpDeclNode)opDefOrDeclNode;
                if (conNode.getArity() != rightDefNode.getArity()) {
                    throw new ConfigFileErrorException(String.format("Invalid substitution for %s.%n Constant %s has %s arguments while %s has %s arguments.", left, left, conNode.getArity(), right, rightDefNode.getArity()));
                }
                this.bConstantList.remove(conNode);
                this.constantOverrides.put(conNode, rightDefNode);
            }
        }
    }

    public ModuleNode searchModule(String moduleName) throws ConfigFileErrorException {
        for (ModuleNode m : this.moduleNode.getExtendedModuleSet()) {
            if (!m.getName().toString().equals(moduleName)) continue;
            return m;
        }
        OpDefNode[] defs = this.moduleNode.getOpDefs();
        for (int j = defs.length - 1; j > 0; --j) {
            OpDefNode def = null;
            OpDefNode source = defs[j];
            while (def != source) {
                def = source;
                source = def.getSource();
                ModuleNode m = def.getOriginallyDefinedInModuleNode();
                if (!m.getName().toString().equals(moduleName)) continue;
                return m;
            }
        }
        throw new ConfigFileErrorException(String.format("Module '%s' is not included in the specification.", moduleName));
    }

    public OpDefOrDeclNode searchDefinitionOrConstant(ModuleNode n, String defOrConName) throws ConfigFileErrorException {
        for (OpDefNode opDefNode : n.getOpDefs()) {
            if (!opDefNode.getName().toString().equals(defOrConName)) continue;
            return opDefNode;
        }
        for (OpDefOrDeclNode opDefOrDeclNode : n.getConstantDecls()) {
            if (!opDefOrDeclNode.getName().toString().equals(defOrConName)) continue;
            return opDefOrDeclNode;
        }
        throw new ConfigFileErrorException("Module does not contain the symbol: " + defOrConName);
    }

    private TLAType conGetType(Object o) throws ConfigFileErrorException {
        if (o instanceof IntValue) {
            return IntType.getInstance();
        }
        if (o instanceof SetEnumValue) {
            TLAType elemType;
            SetEnumValue set = (SetEnumValue)o;
            if (set.isEmpty()) {
                throw new ConfigFileErrorException("type error: empty set is not permitted!");
            }
            SetType t = new SetType(new UntypedType());
            if (set.elems.firstElement() instanceof ModelValue) {
                EnumType e = new EnumType(new ArrayList<String>());
                for (int i = 0; i < set.size(); ++i) {
                    String mv;
                    if (set.elems.elementAt(i) instanceof ModelValue) {
                        mv = set.elems.elementAt(i).toString();
                        if (!this.enumeratedSet.contains(mv)) {
                            this.enumeratedSet.add(mv);
                        } else {
                            EnumType e2 = this.enumeratedTypes.get(mv);
                            try {
                                e = e2.unify(e2);
                            }
                            catch (UnificationException unificationException) {
                                // empty catch block
                            }
                        }
                    } else {
                        throw new ConfigFileErrorException("type error: elements of the set must have the same type: " + o);
                    }
                    e.modelvalues.add(mv);
                }
                for (String s : e.modelvalues) {
                    this.enumeratedTypes.put(s, e);
                }
                elemType = e;
            } else {
                elemType = this.conGetType(set.elems.firstElement());
                for (int i = 1; i < set.size(); ++i) {
                    elemType = this.conGetType(set.elems.elementAt(i));
                    if (t.getSubType().compare(elemType)) continue;
                    throw new ConfigFileErrorException("type error: elements of the set must have the same type: " + o);
                }
            }
            t.setSubType(elemType);
            return t;
        }
        if (o instanceof ModelValue) {
            String mv = ((ModelValue)o).toString();
            if (!this.enumeratedSet.contains(mv)) {
                this.enumeratedSet.add(mv);
                EnumType e = new EnumType(Collections.singletonList(mv));
                this.enumeratedTypes.put(mv, e);
                return e;
            }
            return this.enumeratedTypes.get(mv);
        }
        if (o instanceof StringValue) {
            return StringType.getInstance();
        }
        if (o instanceof BoolValue) {
            return BoolType.getInstance();
        }
        throw new ConfigFileErrorException("type error: unknown constant type: " + o + " " + o.getClass());
    }

    public OpDefNode getSpecNode() {
        return this.specNode;
    }

    public OpDefNode getNextNode() {
        return this.nextNode;
    }

    public OpDefNode getInitNode() {
        return this.initNode;
    }

    public Map<OpDeclNode, OpDefNode> getConstantOverrides() {
        return this.constantOverrides;
    }

    public List<OpDefNode> getInvariants() {
        return this.invariantNodeList;
    }

    public Map<OpDeclNode, TLCValueNode> getConstantAssignments() {
        return this.constantAssignments;
    }

    public Map<OpDefNode, TLCValueNode> getOperatorAssignments() {
        return this.operatorAssignments;
    }

    public List<OpDeclNode> getbConstantList() {
        return this.bConstantList;
    }

    public Map<OpDefNode, OpDefNode> getOperatorOverrides() {
        return this.operatorOverrides;
    }

    public List<String> getEnumerationSet() {
        return this.enumeratedSet;
    }

    public List<OpDefNode> getOperatorModelvalues() {
        return this.operatorModelvalues;
    }
}

