/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.analysis;

import de.tla2b.global.BBuiltInOPs;
import tla2sany.semantic.ASTConstants;
import tla2sany.semantic.AssumeNode;
import tla2sany.semantic.AtNode;
import tla2sany.semantic.DecimalNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.NumeralNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.StringNode;
import tla2sany.semantic.SubstInNode;
import tlc2.tool.BuiltInOPs;

public class AbstractASTVisitor
extends BuiltInOPs
implements ASTConstants {
    public void visitModuleNode(ModuleNode moduleNode) {
        this.visitDefinitions(moduleNode.getOpDefs());
        this.visitAssumptions(moduleNode.getAssumptions());
    }

    public void visitDefinitions(OpDefNode[] opDefs) {
        for (OpDefNode opDefNode : opDefs) {
            this.visitDefinition(opDefNode);
        }
    }

    public void visitDefinition(OpDefNode opDefNode) {
        this.visitExprNode(opDefNode.getBody());
    }

    public void visitAssumptions(AssumeNode[] assumptions) {
        for (AssumeNode assumeNode : assumptions) {
            this.visitAssumeNode(assumeNode);
        }
    }

    public void visitAssumeNode(AssumeNode assumeNode) {
        this.visitExprNode(assumeNode.getAssume());
    }

    public void visitExprOrOpArgNode(ExprOrOpArgNode n) {
        if (!(n instanceof ExprNode)) {
            throw new RuntimeException("Should not appear.");
        }
        this.visitExprNode((ExprNode)n);
    }

    public void visitExprNode(ExprNode node) {
        switch (node.getKind()) {
            case 9: {
                this.visitOpApplNode((OpApplNode)node);
                return;
            }
            case 16: {
                this.visitNumeralNode((NumeralNode)node);
                return;
            }
            case 17: {
                this.visitDecimalNode((DecimalNode)node);
                return;
            }
            case 18: {
                this.visitStringNode((StringNode)node);
                return;
            }
            case 13: {
                this.visitSubstInNode((SubstInNode)node);
                return;
            }
            case 19: {
                this.visitAtNode((AtNode)node);
                return;
            }
            case 10: {
                this.visitLetInNode((LetInNode)node);
            }
        }
    }

    public void visitOpApplNode(OpApplNode node) {
        switch (node.getOperator().getKind()) {
            case 3: {
                this.visitVariableNode(node);
                return;
            }
            case 2: {
                this.visitConstantNode(node);
                return;
            }
            case 11: {
                this.visitFormalParamNode(node);
                return;
            }
            case 7: {
                this.visitBuiltInNode(node);
                return;
            }
            case 5: {
                if (BBuiltInOPs.contains(node.getOperator().getName())) {
                    this.visitBBuiltinsNode(node);
                    break;
                }
                this.visitUserDefinedNode(node);
            }
        }
    }

    public void visitBBuiltinsNode(OpApplNode n) {
        ExprOrOpArgNode[] arguments;
        ExprNode[] in;
        for (ExprNode exprNode : in = n.getBdedQuantBounds()) {
            this.visitExprNode(exprNode);
        }
        for (ExprOrOpArgNode exprOrOpArgNode : arguments = n.getArgs()) {
            this.visitExprOrOpArgNode(exprOrOpArgNode);
        }
    }

    public void visitBuiltInNode(OpApplNode n) {
        ExprOrOpArgNode[] arguments;
        ExprNode[] in;
        for (ExprNode exprNode : in = n.getBdedQuantBounds()) {
            this.visitExprNode(exprNode);
        }
        for (ExprOrOpArgNode exprOrOpArgNode : arguments = n.getArgs()) {
            if (exprOrOpArgNode == null) continue;
            this.visitExprOrOpArgNode(exprOrOpArgNode);
        }
    }

    public void visitLetInNode(LetInNode node) {
        OpDefNode[] lets;
        for (OpDefNode opDefNode : lets = node.getLets()) {
            this.visitLocalDefinition(opDefNode);
        }
        this.visitExprNode(node.getBody());
    }

    public void visitLocalDefinition(OpDefNode opDefNode) {
        this.visitExprNode(opDefNode.getBody());
    }

    public void visitAtNode(AtNode n) {
    }

    public void visitSubstInNode(SubstInNode n) {
        this.visitExprNode(n.getBody());
    }

    public void visitUserDefinedNode(OpApplNode n) {
        for (ExprOrOpArgNode exprOrOpArgNode : n.getArgs()) {
            this.visitExprOrOpArgNode(exprOrOpArgNode);
        }
    }

    public void visitFormalParamNode(OpApplNode n) {
    }

    public void visitConstantNode(OpApplNode n) {
    }

    public void visitVariableNode(OpApplNode n) {
    }

    public void visitStringNode(StringNode n) {
    }

    public void visitNumeralNode(NumeralNode n) {
    }

    public void visitDecimalNode(DecimalNode n) {
    }
}

