/*
 * Decompiled with CFR 0.152.
 */
package de.prob.prolog.match;

import de.prob.prolog.match.PrologMatch;
import de.prob.prolog.term.FloatPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.Map;

public final class PrologFloatMatch
extends PrologMatch {
    private final Double number;
    private final Double delta;

    private PrologFloatMatch(String name, Double number, Double delta) {
        super(name);
        if (delta != null && (!Double.isFinite(delta) || delta < 0.0)) {
            throw new IllegalArgumentException("delta must be finite and non-negative");
        }
        if (!(delta == null || number != null && Double.isFinite(number))) {
            throw new IllegalArgumentException("wanted delta is inconsistent with wanted number");
        }
        this.number = number;
        this.delta = delta;
    }

    public static PrologFloatMatch anonFloat() {
        return PrologFloatMatch.namedFloat(null);
    }

    public static PrologFloatMatch anonFloat(Double number) {
        return PrologFloatMatch.namedFloat(null, number);
    }

    public static PrologFloatMatch anonFloat(Double number, Double delta) {
        return PrologFloatMatch.namedFloat(null, number, delta);
    }

    public static PrologFloatMatch namedFloat(String name) {
        return PrologFloatMatch.namedFloat(name, null);
    }

    public static PrologFloatMatch namedFloat(String name, Double number) {
        return PrologFloatMatch.namedFloat(name, number, null);
    }

    public static PrologFloatMatch namedFloat(String name, Double number, Double delta) {
        return new PrologFloatMatch(name, number, delta);
    }

    @Override
    protected boolean isMatch(PrologTerm term, Map<String, PrologTerm> hits) {
        double value;
        boolean match = term instanceof FloatPrologTerm;
        if (match && this.number != null && Double.compare(value = ((FloatPrologTerm)term).getValue(), this.number) != 0) {
            match = this.delta != null && Math.abs(value - this.number) <= this.delta;
        }
        return match;
    }
}

