/*
 * Decompiled with CFR 0.152.
 */
package de.prob.parserbase;

import de.prob.parserbase.ProBParseException;
import de.prob.parserbase.ProBParserBase;
import de.prob.prolog.output.IPrologTermOutput;

public class UnparsedParserBase
implements ProBParserBase {
    private final String expr;
    private final String pred;
    private final String trans;

    public UnparsedParserBase(String expr, String pred, String trans) {
        this.expr = expr;
        this.pred = pred;
        this.trans = trans;
    }

    @Override
    public void parseExpression(IPrologTermOutput pto, String expression, boolean wrap) throws ProBParseException {
        this.parse(pto, expression, wrap, this.expr, "expression");
    }

    @Override
    public void parsePredicate(IPrologTermOutput pto, String predicate, boolean wrap) throws ProBParseException {
        this.parse(pto, predicate, wrap, this.pred, "predicate");
    }

    @Override
    public void parseTransitionPredicate(IPrologTermOutput pto, String transPredicate, boolean wrap) throws ProBParseException {
        this.parse(pto, transPredicate, wrap, this.trans, "transition predicate");
    }

    private void parse(IPrologTermOutput pto, String formula, boolean wrap, String wrapper, String type) {
        if (wrapper == null) {
            throw new UnsupportedOperationException(type + " not supported");
        }
        if (wrap) {
            pto.openTerm(wrapper);
        }
        pto.printAtom(formula);
        if (wrap) {
            pto.closeTerm();
        }
    }
}

