/*
 * Decompiled with CFR 0.152.
 */
package de.prob.cliparser;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConsoleOptions {
    private String intro = null;
    private final Map<String, Option> options = new HashMap<String, Option>();
    private final List<Option> listOfOptions = new ArrayList<Option>();
    private final Map<String, String[]> concreteOptions = new HashMap<String, String[]>();
    private String[] remaining;

    public void setIntro(String intro) {
        this.intro = intro;
    }

    public void addOption(String key, String desc, int values) {
        if (this.options.containsKey(key)) {
            throw new IllegalArgumentException("key " + key + " added twice");
        }
        Option option = new Option(key, desc, values);
        this.options.put(key, option);
        this.listOfOptions.add(option);
    }

    public void addOption(String key, String desc) {
        this.addOption(key, desc, 0);
    }

    public void parseOptions(String[] cmd) {
        ArrayList<String> rest = new ArrayList<String>();
        this.concreteOptions.clear();
        for (int i = 0; i < cmd.length; ++i) {
            String key = cmd[i];
            Option option = this.options.get(key);
            if (option == null) {
                rest.add(key);
                continue;
            }
            if (i + option.expected_values < cmd.length) {
                String[] params = new String[option.expected_values];
                System.arraycopy(cmd, i + 1, params, 0, option.expected_values);
                this.concreteOptions.put(key, params);
                i += option.expected_values;
                continue;
            }
            throw new IllegalArgumentException("Too few arguments for option " + key);
        }
        this.remaining = rest.toArray(new String[0]);
    }

    public boolean isOptionSet(String key) {
        return this.concreteOptions.containsKey(key);
    }

    public String[] getRemainingOptions() {
        return this.remaining;
    }

    public String[] getOptions(String key) {
        return this.concreteOptions.get(key);
    }

    public void printUsage(PrintWriter out) {
        if (this.intro != null) {
            out.println(this.intro);
        }
        int width = 0;
        for (String key : this.options.keySet()) {
            if (key.length() <= width) continue;
            width = key.length();
        }
        for (Option option : this.listOfOptions) {
            out.print(option.key);
            for (int i = 0; i < width + 1 - option.key.length(); ++i) {
                out.print(' ');
            }
            out.println(option.description);
        }
        out.flush();
    }

    public void printUsage(OutputStream out) {
        this.printUsage(new PrintWriter(out));
    }

    private static class Option {
        private final String key;
        private final String description;
        private final int expected_values;

        public Option(String key, String description, int expected_values) {
            this.expected_values = expected_values;
            this.key = key;
            this.description = description;
        }
    }
}

